set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8704594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '4434302',
      2.952951,
      NULL,
      6,
      3,
      '4314',
      3.375011,
      1,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      NULL,
      3.594808,
      3.571303,
      ' 2-10-1982',
      NULL,
      0.235154,
      18,
      92,
      NULL,
      ' 7-16-1985',
      ' 6-29-2003',
      ' 6- 5-1996',
      2,
      3,
      0,
      3,
      0.995771,
      0.643292,
      3,
      2,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      22,
      NULL,
      1,
      23,
      0,
      2,
      3.328579,
      1,
      NULL,
      0,
      NULL,
      0.531651,
      1,
      NULL,
      3.829160,
      0,
      1.459670,
      1,
      NULL,
      5,
      2,
      NULL,
      3,
      1,
      0,
      3,
      0,
      1,
      5,
      1,
      0,
      1,
      1,
      1,
      3.526775,
      NULL,
      2,
      NULL,
      1,
      1.361811,
      NULL,
      NULL,
      0.952876,
      NULL,
      NULL,
      1,
      NULL,
      1.823434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.494614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3,
      0,
      NULL,
      5,
      1,
      0,
      1,
      0,
      4,
      NULL,
      1,
      6,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      2,
      1,
      NULL,
      0,
      5,
      0,
      0,
      4,
      5,
      1,
      1,
      1,
      3.286759,
      NULL,
      ' 0- 9-1997',
      169,
      NULL,
      8.479213,
      1.778012,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      1.549672,
      NULL,
      1,
      4,
      1,
      1,
      4.777428,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.400264,
      0.562251,
      NULL,
      0,
      1,
      0.101750,
      NULL,
      0.316396,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      3,
      2,
      NULL,
      NULL,
      2,
      2,
      3,
      1,
      3.863039,
      3,
      0.235534,
      NULL,
      1.433784,
      0.019089,
      0,
      1.796756,
      NULL,
      0,
      0,
      0.357464,
      1.812663,
      NULL,
      1.869530,
      0,
      0,
      1,
      1,
      2.861195,
      NULL,
      2,
      3.953986,
      2.132045,
      2,
      NULL,
      3.945713,
      NULL,
      1,
      0.864967,
      NULL,
      43,
      0,
      0.274588,
      NULL,
      NULL,
      40,
      21,
      2,
      4.143665,
      3.243744,
      NULL,
      '',
      '',
      1.424541,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      26,
      7,
      3.381432,
      37.275099,
      NULL,
      NULL,
      5,
      2.397179,
      3,
      1,
      0.771267,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      1.633333,
      0.735538,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.466929,
      1.331425,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484743,
      NULL,
      NULL,
      0,
      7,
      3.635941,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.617546,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.639188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130476,
      NULL,
      NULL,
      1.069440,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.166092,
      0.166770,
      1,
      1.038540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5.833269,
      NULL,
      2,
      3,
      0.485503,
      2.121161,
      1.536215,
      1.807224,
      7,
      NULL,
      2.910136,
      0.591140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.162188,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4.804165,
      NULL,
      3,
      0,
      NULL,
      1.414994,
      NULL,
      NULL,
      NULL,
      2.434322,
      NULL,
      0,
      3.994171,
      NULL,
      1.779784,
      3.931404,
      1.397523,
      NULL,
      5,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949378,
      0.140760,
      NULL,
      NULL,
      NULL,
      1.467360,
      1,
      0.456156,
      2,
      3,
      0.305360,
      7,
      4,
      1,
      3.751665,
      1,
      1,
      1,
      1.295619,
      NULL,
      0.708243,
      0.739726,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273159,
      NULL,
      NULL,
      1.527563,
      NULL,
      NULL,
      3.333788,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.074153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716518,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1.018573,
      1.102981,
      0.324550,
      1.139444,
      2.377535,
      0,
      NULL,
      NULL,
      0.453095,
      NULL,
      2.933614,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.420751,
      NULL,
      NULL,
      NULL,
      1.534327,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235276,
      NULL,
      NULL,
      NULL,
      0.914860,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.796285,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.239430,
      NULL,
      NULL,
      NULL,
      0.833277,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.243058,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.537806,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.995540,
      NULL,
      NULL,
      NULL,
      3.390123,
      NULL,
      9.549983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.441750,
      2.169162,
      NULL,
      0.730360,
      3.767555,
      2,
      0.757829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      47,
      22,
      3,
      1.186564,
      3,
      0.157300,
      0.272348,
      1,
      1,
      0,
      1.976875,
      0.856782,
      1.401680,
      1,
      1,
      0,
      1,
      1,
      2,
      3.021777,
      0,
      0.727746,
      1.793673,
      3,
      0.742414,
      0,
      0,
      2,
      NULL,
      0.231268,
      0.671699,
      1.842635,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840150,
      0.161601,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370833,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694347,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857846,
      1.283779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094001,
      1.854217,
      NULL,
      0.689454,
      NULL,
      NULL,
      1.667819,
      0,
      1.346904,
      NULL,
      NULL,
      NULL,
      1,
      1.597305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      5,
      1,
      1.895068,
      NULL,
      3,
      2.970884,
      NULL,
      0.787127,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.161671,
      NULL,
      NULL,
      NULL,
      1.164768,
      NULL,
      3.391977,
      0,
      NULL,
      1.954855,
      1,
      NULL,
      1,
      1.386805,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390813,
      NULL,
      0,
      1.829483,
      NULL,
      3,
      NULL,
      1.055138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633356,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      73.400339,
      NULL,
      5,
      4,
      1,
      '44313',
      '',
      '',
      1.271535,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


