set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8704594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      NULL,
      14.262468,
      '0331013',
      2,
      1.370792,
      NULL,
      3,
      '2030',
      0,
      1,
      NULL,
      NULL,
      ' 6- 6-1996',
      NULL,
      36.418475,
      NULL,
      3.685385,
      0.626903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 6- 2-1989',
      ' 6- 0-1999',
      NULL,
      NULL,
      1,
      3.541705,
      0,
      0,
      NULL,
      1,
      1,
      0.787157,
      13.724376,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1,
      1,
      0.567617,
      0,
      1.378034,
      0,
      1,
      1.377814,
      1,
      NULL,
      2,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      3,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.913063,
      NULL,
      NULL,
      NULL,
      1,
      0.845831,
      1.890034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.770147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      4,
      2,
      1,
      0,
      5.060282,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      1,
      4,
      1,
      NULL,
      5,
      4,
      4,
      0,
      NULL,
      1.714407,
      0.138714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0.931297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      1,
      0,
      0.329773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.653004,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.820651,
      3,
      0.764589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.545779,
      1,
      1,
      0.271138,
      0,
      0,
      0.745178,
      0.379710,
      8.220685,
      3,
      0.699572,
      NULL,
      NULL,
      NULL,
      1,
      0.782456,
      3.232518,
      2,
      3,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      2,
      3,
      0,
      NULL,
      2.464463,
      3.874241,
      0,
      0.829824,
      0.681534,
      0.355843,
      0.874535,
      1.308787,
      0,
      1,
      1,
      0.830358,
      0,
      1,
      2,
      NULL,
      NULL,
      8.565768,
      4.291108,
      4.676571,
      8,
      0.457120,
      NULL,
      5.332296,
      NULL,
      NULL,
      NULL,
      1,
      3,
      22,
      2,
      0,
      69,
      NULL,
      54,
      72.365662,
      0,
      5,
      3,
      '20442',
      '',
      NULL,
      0.127422,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      3,
      35.282879,
      5.404342,
      37,
      1,
      15,
      0.062055,
      NULL,
      NULL,
      0,
      3,
      1.978663,
      0,
      NULL,
      NULL,
      0.677507,
      NULL,
      NULL,
      NULL,
      2,
      0.752184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.039664,
      0,
      0.559435,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.334186,
      0.410070,
      0,
      1.883660,
      0,
      NULL,
      NULL,
      0.406143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413692,
      NULL,
      NULL,
      0.198845,
      NULL,
      NULL,
      0.776427,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301432,
      NULL,
      NULL,
      0.378643,
      NULL,
      NULL,
      1.546631,
      3,
      1.185160,
      1.969771,
      NULL,
      NULL,
      6,
      NULL,
      4,
      NULL,
      2,
      3,
      0,
      1,
      0,
      2,
      NULL,
      4,
      0.301218,
      NULL,
      NULL,
      1.280709,
      NULL,
      NULL,
      0.953418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.577540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319083,
      NULL,
      NULL,
      NULL,
      3,
      0.332108,
      2,
      1,
      1.930258,
      1.883983,
      1,
      1.853648,
      2,
      2,
      0.830740,
      NULL,
      3.563535,
      1.890188,
      2.249452,
      NULL,
      NULL,
      2.832278,
      NULL,
      3.461803,
      5,
      9.696436,
      5,
      3.680596,
      0.840420,
      2,
      3,
      0.561921,
      3,
      2,
      2.047965,
      3.634061,
      0.694712,
      0,
      0.368705,
      NULL,
      3,
      5.141397,
      0.126034,
      3,
      3.582514,
      3.480861,
      4,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1.587265,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202261,
      NULL,
      NULL,
      1.750067,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.454309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620485,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.644477,
      NULL,
      0,
      0,
      3.606650,
      0.123455,
      2.045129,
      NULL,
      0.124110,
      NULL,
      NULL,
      NULL,
      28.308768,
      NULL,
      NULL,
      NULL,
      1,
      2.088735,
      2,
      NULL,
      3,
      3,
      3.021092,
      NULL,
      1,
      NULL,
      1.936456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332864,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.769286,
      1.670643,
      NULL,
      NULL,
      0,
      0.925954,
      1.221422,
      NULL,
      1.869625,
      NULL,
      1,
      NULL,
      0,
      3.418761,
      1,
      NULL,
      0,
      NULL,
      3.277648,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.752112,
      1,
      2,
      NULL,
      1.627133,
      1,
      1,
      NULL,
      1.677305,
      NULL,
      1,
      NULL,
      1.640940,
      2,
      0,
      NULL,
      11.617538,
      0,
      4,
      NULL,
      2.072028,
      0,
      1,
      7,
      3,
      2.653787,
      17.673921,
      12,
      1,
      24.488326,
      2,
      1,
      NULL,
      NULL,
      0.961663,
      NULL,
      NULL,
      1.217189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      724,
      9.670019,
      0.349840,
      NULL,
      1.552251,
      0,
      0.685778,
      0.971312,
      0,
      0.212871,
      0,
      0,
      NULL,
      3.780214,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.131158,
      NULL,
      1.599042,
      NULL,
      2.347919,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.813144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.393424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602187,
      0.358700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745573,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256579,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      2.946967,
      3,
      2.783111,
      2,
      NULL,
      3,
      1.997256,
      0.023770,
      0,
      1.969201,
      1,
      NULL,
      1,
      NULL,
      2.900718,
      NULL,
      0,
      1.327292,
      NULL,
      1,
      3.823073,
      0.708557,
      0.957023,
      2.836838,
      0.514982,
      NULL,
      0.973532,
      0.529622,
      0.664784,
      NULL,
      0,
      1,
      1,
      1,
      2,
      1,
      1,
      1.869876,
      3.745436,
      3.741433,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591966,
      0.004646,
      0,
      0.403153,
      1,
      1,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      64.711960,
      65,
      2,
      0,
      0.340369,
      '12400',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


