set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9907503';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      0,
      NULL,
      0,
      5,
      3,
      7.693583,
      3.595017,
      '441',
      '42230011',
      24.373122,
      70.027402,
      NULL,
      0,
      0.074603,
      0,
      3,
      NULL,
      0.434590,
      1,
      NULL,
      NULL,
      ' 1- 1-2002',
      NULL,
      NULL,
      NULL,
      0,
      2.059598,
      ' 3- 1-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '11-18-1986',
      ' 1- 9-1987',
      '11-15-1998',
      2.784043,
      0,
      1,
      1.807915,
      NULL,
      2,
      NULL,
      0,
      NULL,
      29.121861,
      0,
      16,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      0,
      1,
      1.424243,
      0.285165,
      1.707849,
      1,
      NULL,
      0.947700,
      0.982547,
      150.821179,
      2,
      4,
      6,
      NULL,
      5,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      4.763265,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      1.949844,
      0.608717,
      0.256681,
      0,
      1.756952,
      0.524542,
      1.819280,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      7.598488,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      4,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1.945595,
      NULL,
      0,
      0,
      5,
      2,
      4,
      NULL,
      3,
      1,
      1,
      0,
      4,
      0,
      NULL,
      1,
      NULL,
      1,
      3,
      3,
      4,
      1,
      0,
      1,
      4,
      NULL,
      NULL,
      0,
      0.673505,
      0.766640,
      '11-11-1989',
      NULL,
      NULL,
      47.944777,
      0,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1,
      2,
      2,
      1,
      1.134707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043318,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.245532,
      0.710746,
      3.836439,
      0.220846,
      1,
      2,
      5,
      0.672006,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0.702413,
      1.032080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.682177,
      1.916742,
      1.146254,
      NULL,
      133,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      2,
      3.895805,
      1.431135,
      1.001974,
      0,
      1.225725,
      NULL,
      0.761173,
      0,
      1.883339,
      0.196669,
      0.467948,
      0,
      1.580435,
      1.732368,
      0,
      0,
      1,
      3,
      1.045677,
      NULL,
      4.987286,
      4.892128,
      NULL,
      NULL,
      3.821472,
      2.426407,
      3.201169,
      NULL,
      1.346428,
      2.463509,
      3.420853,
      17.840796,
      2,
      0,
      18,
      NULL,
      57,
      NULL,
      4,
      0,
      0.489317,
      '14313',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.218386,
      '',
      '',
      NULL,
      1,
      31,
      89.801698,
      NULL,
      3.343815,
      NULL,
      2.881850,
      6,
      1,
      1.325749,
      NULL,
      0.898941,
      0.187554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.435706,
      0.637059,
      0,
      0,
      1.769142,
      3.445700,
      1.576093,
      1.336737,
      1,
      NULL,
      NULL,
      0.833868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.979070,
      1,
      0.723664,
      NULL,
      0.163462,
      NULL,
      NULL,
      NULL,
      1.624544,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.126208,
      2,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      3,
      0,
      2,
      3,
      NULL,
      0.967430,
      NULL,
      1,
      1.877153,
      3.258572,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.850675,
      NULL,
      NULL,
      1.275433,
      NULL,
      NULL,
      8.003569,
      1.112815,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.046733,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.267173,
      2,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.800458,
      0.479858,
      0,
      NULL,
      2.773629,
      NULL,
      0.077018,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.865109,
      NULL,
      NULL,
      1,
      0.798380,
      0,
      NULL,
      0,
      0.476891,
      6,
      0,
      NULL,
      NULL,
      5,
      3.745303,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3.101193,
      1.956840,
      2,
      2,
      3,
      1,
      0,
      9,
      NULL,
      NULL,
      1.251001,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.931185,
      3,
      0,
      NULL,
      3.986566,
      2.308946,
      2.849606,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1.002019,
      1.832025,
      1.609924,
      2,
      NULL,
      NULL,
      0.170812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914050,
      NULL,
      NULL,
      3.335557,
      NULL,
      NULL,
      3.941560,
      NULL,
      NULL,
      1.176294,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.132928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.404421,
      1.482514,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979449,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.286765,
      NULL,
      3.411518,
      NULL,
      1,
      NULL,
      1.797813,
      NULL,
      0.774073,
      NULL,
      2.079627,
      NULL,
      3.026019,
      NULL,
      2.075437,
      NULL,
      1.134025,
      NULL,
      NULL,
      NULL,
      2.929438,
      NULL,
      0,
      NULL,
      3.261467,
      NULL,
      3,
      NULL,
      0.526230,
      NULL,
      0.642695,
      NULL,
      0.934936,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.956268,
      NULL,
      0.017441,
      NULL,
      NULL,
      NULL,
      0.447581,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.874080,
      NULL,
      2,
      NULL,
      0.827612,
      NULL,
      7.828578,
      NULL,
      11.263552,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.933420,
      0.127608,
      5,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.101797,
      0,
      1.288821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.785912,
      NULL,
      0.334702,
      362,
      14,
      0,
      1.845809,
      1.057326,
      1.280706,
      NULL,
      NULL,
      1.146632,
      0.292001,
      NULL,
      NULL,
      1,
      0.624181,
      1,
      NULL,
      1,
      0,
      NULL,
      0.197668,
      1.468414,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.125628,
      NULL,
      0.756984,
      NULL,
      25.680265,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.191971,
      18.605289,
      0.444958,
      NULL,
      1.739648,
      NULL,
      1.523674,
      NULL,
      0,
      NULL,
      0.091140,
      NULL,
      1.798745,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.512527,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599942,
      1.556403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637428,
      3,
      NULL,
      1.690148,
      NULL,
      1.226379,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.566923,
      NULL,
      0.310182,
      1.860687,
      0.689119,
      3.288402,
      NULL,
      3.640594,
      NULL,
      98,
      NULL,
      NULL,
      NULL,
      0.944954,
      NULL,
      0,
      NULL,
      1.018724,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.333869,
      0.127111,
      0.516591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.913581,
      0.697418,
      NULL,
      2.785222,
      NULL,
      21,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.248940,
      NULL,
      0,
      0.630419,
      6,
      NULL,
      3.407277,
      1.292391,
      3.373431,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.884429,
      NULL,
      1,
      4.017048,
      2.934831,
      1,
      0,
      0.782924,
      1.133102,
      NULL,
      1,
      2.805642,
      NULL,
      0,
      1.907859,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0.739805,
      1,
      NULL,
      1,
      2.196254,
      NULL,
      NULL,
      1,
      NULL,
      1.935661,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.732599,
      1,
      NULL,
      2.207084,
      1.898556,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.139201,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      NULL,
      62.677162,
      NULL,
      2,
      NULL,
      4,
      '31044',
      '12233',
      '01111',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


