set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9755023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1,
      3.887769,
      NULL,
      0,
      3,
      3.558579,
      3,
      '44',
      '42122034',
      23,
      28,
      '2012301',
      3,
      1.874256,
      0,
      0,
      '0233',
      5.661748,
      0,
      NULL,
      NULL,
      '10-10-1979',
      229,
      51,
      NULL,
      0.338254,
      6,
      ' 7- 7-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10- 5-1991',
      ' 9- 8-1985',
      ' 4-12-1997',
      NULL,
      NULL,
      0.193153,
      3,
      0,
      3.035214,
      1,
      0.063830,
      NULL,
      NULL,
      NULL,
      11.895874,
      3.060509,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.497548,
      NULL,
      1,
      3.944755,
      1,
      0,
      3,
      NULL,
      3,
      1.952425,
      NULL,
      1,
      0,
      NULL,
      4,
      NULL,
      4,
      1,
      NULL,
      1,
      5,
      1,
      8.786036,
      0,
      2,
      NULL,
      0,
      1.415441,
      NULL,
      NULL,
      1.226227,
      NULL,
      NULL,
      1,
      1,
      2.707011,
      NULL,
      1.408673,
      NULL,
      2,
      0.777257,
      1,
      3,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      3,
      0.925393,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.950301,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      2,
      4,
      0,
      3,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      5,
      1,
      NULL,
      1,
      5,
      3,
      1,
      3,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      5,
      4,
      0,
      NULL,
      NULL,
      1,
      7.785360,
      0,
      ' 9-13-1981',
      276,
      ' 8- 6-2003',
      34,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.403642,
      0,
      1.310560,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.131059,
      0,
      5.736397,
      2,
      3.124750,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.325243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.280401,
      1,
      1.844163,
      0,
      NULL,
      0,
      3.541932,
      18,
      2,
      1.294790,
      NULL,
      NULL,
      NULL,
      1,
      0.275567,
      NULL,
      1,
      2,
      3,
      1,
      1,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1.160309,
      3,
      1,
      1,
      0.955700,
      NULL,
      NULL,
      0.011049,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      9.042929,
      4.537936,
      NULL,
      1.360511,
      10,
      4,
      4.265528,
      1.854922,
      3,
      1.233891,
      0,
      2.175242,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      77.740861,
      NULL,
      4,
      NULL,
      '03203',
      NULL,
      '',
      0.911902,
      NULL,
      '',
      '',
      0.582517,
      '',
      '',
      '',
      2.559611,
      NULL,
      48.914743,
      41.132024,
      0.921445,
      6.023622,
      2.913364,
      2.285415,
      2,
      0,
      1,
      1,
      1.362339,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.544265,
      0,
      1.228775,
      1.077377,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      1,
      0,
      0,
      0.098714,
      0.545160,
      2,
      0.725146,
      1,
      2,
      1,
      1,
      6,
      4.176237,
      7.254086,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.313543,
      3.891355,
      1.777475,
      NULL,
      1.314676,
      2,
      1.730282,
      2.785704,
      1,
      2.661217,
      0.917452,
      2,
      0.254058,
      1.689538,
      1.273112,
      2,
      NULL,
      0.816317,
      0.174886,
      NULL,
      1.975885,
      3,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      0.656176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.237447,
      6.720820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721537,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.921311,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.956663,
      NULL,
      1,
      0,
      0.057537,
      0.871958,
      NULL,
      NULL,
      NULL,
      4,
      3.284494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107386,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1.123440,
      1.238530,
      0,
      6.742860,
      1,
      4.029035,
      3,
      1.477151,
      5,
      1,
      1.688237,
      1,
      3,
      NULL,
      0.275785,
      2,
      0.799053,
      2,
      2.861598,
      1.949111,
      2,
      7.083398,
      1,
      1,
      2.523187,
      NULL,
      NULL,
      2.294329,
      0,
      NULL,
      1,
      2.403261,
      1.177958,
      0,
      0.368401,
      0,
      4.748442,
      1,
      3.640606,
      0.452849,
      NULL,
      NULL,
      0.979175,
      NULL,
      NULL,
      0.954156,
      1.092698,
      NULL,
      0.390611,
      0.252824,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.955808,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515032,
      2.811962,
      2.999998,
      0.957629,
      0.352420,
      NULL,
      1.027524,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259614,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.033342,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700575,
      1,
      2,
      NULL,
      2.675494,
      43.818248,
      NULL,
      3,
      9.750313,
      0.458982,
      0,
      NULL,
      NULL,
      0.970429,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.383271,
      NULL,
      NULL,
      1.212901,
      NULL,
      1.957626,
      0.817593,
      1,
      0.119052,
      1.869426,
      NULL,
      0.320441,
      1,
      1.873236,
      1.969606,
      0,
      0.824461,
      1,
      0.720257,
      0.631659,
      0.888171,
      1,
      1.664130,
      NULL,
      0.176934,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      6.978139,
      NULL,
      0,
      3.528102,
      0,
      NULL,
      3,
      0,
      NULL,
      1.523038,
      NULL,
      NULL,
      2.586163,
      NULL,
      NULL,
      2.981639,
      0.146413,
      NULL,
      0.959384,
      0.044784,
      NULL,
      1.395208,
      0.220832,
      NULL,
      1,
      1,
      NULL,
      0,
      3.968979,
      NULL,
      NULL,
      3.276993,
      NULL,
      1.432507,
      NULL,
      NULL,
      1.141247,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.921673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.722812,
      NULL,
      0,
      NULL,
      2.724200,
      NULL,
      1.570411,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.657078,
      NULL,
      3.465691,
      NULL,
      0.640069,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.502087,
      NULL,
      1,
      NULL,
      1,
      0.362936,
      NULL,
      NULL,
      31,
      10,
      3,
      0,
      0,
      '4004',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      1.290291,
      '',
      '',
      '');
commit;
end;
/


