set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9755023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0,
      0,
      0.652028,
      0,
      NULL,
      1,
      2,
      NULL,
      '40322240',
      7.924229,
      60.508426,
      NULL,
      1.989189,
      0,
      1,
      NULL,
      NULL,
      0.868136,
      0.110591,
      NULL,
      NULL,
      ' 0-18-1986',
      190.114750,
      94,
      NULL,
      NULL,
      1.589573,
      ' 1-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 7-23-1999',
      1,
      NULL,
      3,
      0.964879,
      1,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      3.893083,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.203488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      7,
      NULL,
      4,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      5,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.995618,
      0,
      1,
      1.025279,
      2,
      0.718832,
      0,
      3,
      0.268129,
      NULL,
      NULL,
      0,
      3.815415,
      1,
      0,
      0,
      2.984142,
      1,
      2,
      NULL,
      0.130845,
      NULL,
      NULL,
      1.509702,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      5,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      2.994465,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0.572793,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      1,
      1,
      0,
      0,
      0,
      5,
      NULL,
      1,
      0,
      NULL,
      3,
      4,
      2,
      NULL,
      0,
      5,
      0,
      1,
      0,
      1,
      ' 2- 2-1996',
      591.155702,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.204857,
      3.016332,
      1.303758,
      1.003486,
      1.973606,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.548759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.834420,
      NULL,
      0.730744,
      1,
      0.049982,
      0.273705,
      0,
      0.166651,
      NULL,
      3.186056,
      0.610720,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1,
      1,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0.082084,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      0.380192,
      0.566276,
      0,
      0.694096,
      0.543356,
      NULL,
      0,
      1,
      NULL,
      1,
      8,
      4.325642,
      6.954065,
      3,
      NULL,
      4.236589,
      NULL,
      NULL,
      NULL,
      0,
      1.396499,
      3.800618,
      39.830580,
      0,
      NULL,
      65,
      NULL,
      NULL,
      NULL,
      5,
      0.600910,
      1,
      '24041',
      '',
      NULL,
      1.682370,
      NULL,
      NULL,
      '',
      2,
      '2012',
      '',
      '',
      3,
      14.363134,
      2,
      38,
      0,
      0.289032,
      NULL,
      1,
      4,
      NULL,
      1.462698,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      3,
      3.579976,
      NULL,
      0,
      0.255405,
      NULL,
      NULL,
      3.776841,
      NULL,
      1,
      1,
      3,
      0,
      3.532387,
      1.117240,
      0,
      0,
      1,
      0.329657,
      0.329178,
      NULL,
      0,
      NULL,
      0.010456,
      NULL,
      NULL,
      5.500880,
      3,
      NULL,
      0.342478,
      NULL,
      NULL,
      NULL,
      1.684136,
      NULL,
      NULL,
      NULL,
      1.997180,
      0,
      3.833196,
      1.545144,
      1,
      NULL,
      1.155173,
      1,
      NULL,
      2.680474,
      3,
      3.232965,
      0,
      1.219182,
      1.113803,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      0.407093,
      0.689923,
      2.885424,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383437,
      NULL,
      NULL,
      4.537054,
      0.601234,
      6.095697,
      NULL,
      0.023938,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.636430,
      0,
      3.864558,
      1,
      1.174095,
      NULL,
      0.471075,
      1.732230,
      0.583686,
      3.268570,
      NULL,
      1,
      NULL,
      NULL,
      6.764354,
      0.033880,
      3.427632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914550,
      NULL,
      NULL,
      1.485957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.622062,
      0,
      0,
      1.283421,
      NULL,
      7,
      0,
      4,
      0.575357,
      0,
      7.088012,
      5.308393,
      NULL,
      0,
      0.217802,
      0.816125,
      1.531235,
      NULL,
      3.011681,
      NULL,
      1.220476,
      3,
      3.041578,
      3.370105,
      5.341807,
      NULL,
      NULL,
      2,
      1,
      3,
      3,
      NULL,
      NULL,
      1.169083,
      3,
      NULL,
      NULL,
      1.337065,
      6.668217,
      NULL,
      1.542851,
      7.467003,
      0,
      2,
      2.287604,
      3,
      2,
      1.034469,
      1.094778,
      0,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.714550,
      NULL,
      NULL,
      1.859636,
      NULL,
      NULL,
      0.949127,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.744121,
      NULL,
      NULL,
      NULL,
      1.882075,
      NULL,
      NULL,
      2.836954,
      NULL,
      NULL,
      NULL,
      9.922278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.556976,
      NULL,
      NULL,
      NULL,
      0.784289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385343,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.716132,
      NULL,
      NULL,
      NULL,
      2.275754,
      NULL,
      NULL,
      NULL,
      0.808042,
      NULL,
      NULL,
      NULL,
      5.564339,
      NULL,
      NULL,
      NULL,
      1.782074,
      0,
      5,
      NULL,
      NULL,
      133,
      65.490077,
      1.094661,
      3.505556,
      1.202675,
      1,
      NULL,
      NULL,
      0.892869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.070997,
      0.253825,
      0.606536,
      1.796849,
      0.770319,
      0.445917,
      1.387340,
      0,
      0,
      1.839878,
      1.029568,
      0,
      1,
      0,
      0.137763,
      1.182713,
      1.437921,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      4,
      2.240872,
      1,
      1,
      0,
      1.042362,
      0.901396,
      2.212919,
      NULL,
      NULL,
      2,
      1.639843,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.356671,
      NULL,
      0.639154,
      NULL,
      NULL,
      0.372924,
      1,
      NULL,
      NULL,
      1.454648,
      NULL,
      1,
      0,
      NULL,
      1.639380,
      1,
      NULL,
      0,
      3.881851,
      NULL,
      0.612444,
      3,
      NULL,
      1.061659,
      0.346734,
      0.622218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.041737,
      NULL,
      1.851722,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.171937,
      NULL,
      NULL,
      NULL,
      1.419425,
      NULL,
      0.358527,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.876083,
      NULL,
      0,
      0.085885,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      6,
      5,
      1,
      NULL,
      NULL,
      41,
      72,
      0,
      NULL,
      NULL,
      '41402',
      NULL,
      '',
      1.250503,
      '',
      '',
      NULL,
      2,
      '3111',
      '',
      '');
commit;
end;
/


