set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      0,
      1,
      6,
      2,
      '3443',
      0,
      NULL,
      NULL,
      NULL,
      ' 4-11-1979',
      52.623570,
      NULL,
      1,
      1.799309,
      2.703498,
      NULL,
      1.740360,
      0.307963,
      NULL,
      64,
      NULL,
      ' 7-10-1995',
      NULL,
      ' 1-20-1994',
      2.407820,
      2,
      0,
      2,
      1,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7.158980,
      17,
      12.973760,
      3,
      0,
      1,
      3,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      3,
      2,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.808488,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.234813,
      0.020698,
      1,
      0,
      0.359202,
      1.055847,
      0.664250,
      1.117163,
      2,
      0.059108,
      0.848418,
      0.183047,
      2,
      NULL,
      0,
      5,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1.516286,
      NULL,
      NULL,
      1,
      4,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.486551,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.536005,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0,
      5,
      0,
      4,
      1,
      NULL,
      2,
      2,
      0,
      3,
      NULL,
      1,
      1,
      3,
      4.976491,
      NULL,
      ' 5-25-1982',
      73,
      ' 1-11-1982',
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      0.079170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.448498,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.108315,
      1.763692,
      0,
      2.396566,
      1,
      NULL,
      NULL,
      NULL,
      1.181562,
      0.542869,
      1.233226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.474642,
      1.725414,
      0.467938,
      0,
      NULL,
      0,
      1.439649,
      0.801929,
      0,
      3.259974,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      2,
      0,
      1,
      3,
      2,
      2.501135,
      2.326912,
      1,
      5,
      1,
      0.849525,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0.419837,
      NULL,
      1,
      2.220817,
      2.747498,
      NULL,
      2,
      NULL,
      6.792269,
      3.608623,
      3,
      7.585053,
      1.715651,
      1.398073,
      3.436419,
      51.501482,
      2,
      2,
      NULL,
      42,
      60,
      5.534067,
      4,
      NULL,
      5,
      '40211',
      '33413',
      '',
      0.720456,
      '',
      '',
      '',
      0.627774,
      '',
      NULL,
      '',
      0.733486,
      11,
      9,
      NULL,
      NULL,
      7,
      2,
      NULL,
      0,
      3,
      1,
      1,
      0.880177,
      NULL,
      NULL,
      1.307662,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      NULL,
      2,
      2.120634,
      1.017002,
      NULL,
      NULL,
      0,
      3.104472,
      1.677718,
      1.054561,
      NULL,
      NULL,
      0.033957,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      5,
      5.180460,
      1,
      1.464286,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.210103,
      1.530736,
      1.278511,
      0,
      NULL,
      NULL,
      2.459984,
      1,
      1.786088,
      NULL,
      1.583506,
      0,
      1,
      1,
      0,
      0,
      0.151710,
      0.519669,
      0.728048,
      1.151619,
      0.195745,
      1.423829,
      NULL,
      1.871499,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445395,
      4.036166,
      0.358717,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.389296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.197070,
      2,
      2.118995,
      3.564511,
      1.093727,
      NULL,
      NULL,
      3.903083,
      2.627813,
      0.800682,
      1.001611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.866284,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.619217,
      NULL,
      NULL,
      0.267458,
      NULL,
      NULL,
      1,
      2.326221,
      7,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      0.096923,
      1,
      2,
      3,
      1.273418,
      2,
      4,
      NULL,
      4,
      1.719761,
      0.170643,
      NULL,
      1.376264,
      NULL,
      NULL,
      3,
      1.001668,
      3,
      NULL,
      2.147453,
      NULL,
      NULL,
      0,
      7,
      5,
      1,
      3.848715,
      2.341593,
      0,
      3,
      NULL,
      0.631535,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.235428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431601,
      NULL,
      NULL,
      0.089337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.778971,
      NULL,
      NULL,
      0.153192,
      1,
      1,
      0.313680,
      0.667643,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.235999,
      NULL,
      NULL,
      NULL,
      1.345586,
      NULL,
      NULL,
      NULL,
      0.090924,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.991911,
      NULL,
      NULL,
      NULL,
      1.777984,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.056321,
      NULL,
      NULL,
      NULL,
      1.571186,
      NULL,
      NULL,
      NULL,
      7.750650,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.802462,
      2.756261,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.947533,
      NULL,
      NULL,
      0.105635,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      467.560262,
      4,
      0.261023,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1.324873,
      1.310601,
      3.362424,
      NULL,
      2,
      0,
      0.101904,
      0,
      NULL,
      1,
      0.030800,
      NULL,
      1.045556,
      NULL,
      0.187129,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      18.686748,
      NULL,
      NULL,
      2.212577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.824249,
      NULL,
      0,
      NULL,
      1.876950,
      NULL,
      1,
      NULL,
      0.218011,
      NULL,
      1.086592,
      NULL,
      1,
      NULL,
      0.472658,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691672,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.125063,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      0.777622,
      NULL,
      NULL,
      NULL,
      1.797008,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.896027,
      NULL,
      31,
      NULL,
      2.460808,
      NULL,
      3.231745,
      1.120713,
      3,
      1.710582,
      2,
      NULL,
      126,
      1,
      1.611727,
      0.280064,
      1.605354,
      1.251545,
      0,
      0,
      0,
      NULL,
      NULL,
      3.345067,
      0,
      NULL,
      3.937694,
      2,
      2,
      3,
      6,
      3.208309,
      3.361757,
      2,
      3,
      14,
      NULL,
      3.522159,
      0.981257,
      0.490568,
      1.199194,
      NULL,
      2.468896,
      0.959818,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      0.988017,
      NULL,
      1,
      1.663608,
      NULL,
      1,
      1,
      NULL,
      0.114761,
      0.234414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.206328,
      NULL,
      3.624776,
      3.820610,
      NULL,
      1.419083,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685548,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      0,
      1.813947,
      NULL,
      NULL,
      48.554642,
      35.741648,
      3,
      3,
      4.862139,
      '30020',
      '24331',
      '',
      0.485025,
      NULL,
      NULL,
      '',
      0.506426,
      '',
      '',
      '');
commit;
end;
/


