set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7413272';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      0.509812,
      NULL,
      2,
      0,
      '3000',
      0,
      1.142391,
      NULL,
      NULL,
      '10-15-1988',
      0.926007,
      NULL,
      2,
      3,
      0.773526,
      NULL,
      13.028861,
      2,
      NULL,
      9.416880,
      NULL,
      '10-28-1990',
      '10-29-1978',
      ' 6-13-1999',
      2.136963,
      NULL,
      1.725881,
      0.272663,
      0,
      NULL,
      2,
      1.937267,
      1.794108,
      68,
      0,
      7,
      2.417590,
      NULL,
      NULL,
      0,
      5.269772,
      0,
      0,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.810169,
      1.375971,
      0,
      0,
      1,
      0.275788,
      3,
      4,
      5,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      2.353842,
      NULL,
      1,
      0.572172,
      1,
      NULL,
      NULL,
      1.826020,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.495698,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0.641313,
      4,
      0,
      NULL,
      1,
      NULL,
      5,
      5,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      2,
      NULL,
      4,
      0,
      1,
      NULL,
      0,
      2,
      0,
      0,
      0.741314,
      1.868431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.320545,
      0.911455,
      0,
      0,
      NULL,
      7.660550,
      0.217531,
      1.375876,
      0.515550,
      0.308253,
      NULL,
      NULL,
      NULL,
      0.932225,
      2.268155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725682,
      0.018209,
      0,
      0.882496,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.602983,
      0,
      NULL,
      NULL,
      3,
      1,
      2,
      2,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.186543,
      1.309731,
      4.230175,
      1,
      2.057853,
      0,
      1.588077,
      NULL,
      2.878494,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.291848,
      3.633083,
      1.518358,
      4,
      9,
      2.784932,
      NULL,
      10,
      5.781902,
      2,
      NULL,
      4,
      3.345374,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      21,
      14,
      34.275138,
      0,
      1.298043,
      1.428299,
      '44130',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.358421,
      '',
      NULL,
      '',
      NULL,
      9,
      216,
      19,
      2.617415,
      10.004464,
      8.784561,
      1.149044,
      0,
      0.168493,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141188,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.904127,
      NULL,
      NULL,
      3,
      NULL,
      0.900806,
      1.076101,
      0.700311,
      0.556922,
      NULL,
      0.040348,
      0.914147,
      1,
      1,
      1,
      1,
      1.969903,
      0.600708,
      0.227639,
      2,
      1,
      1,
      0,
      0.112144,
      0,
      0,
      NULL,
      NULL,
      1.131724,
      NULL,
      NULL,
      0.492649,
      0.460715,
      1,
      1,
      0.866552,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.100747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236256,
      0,
      0,
      1,
      NULL,
      NULL,
      3.126783,
      0,
      0.169352,
      1,
      NULL,
      NULL,
      1.252397,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.545257,
      NULL,
      NULL,
      0.859380,
      NULL,
      NULL,
      1.179191,
      NULL,
      NULL,
      1.377312,
      NULL,
      NULL,
      1,
      NULL,
      2.863334,
      0,
      NULL,
      NULL,
      5,
      2.040016,
      5,
      3.321660,
      2,
      0.112023,
      1,
      NULL,
      NULL,
      0.894501,
      NULL,
      NULL,
      3.329571,
      NULL,
      NULL,
      3.680312,
      3.787592,
      0,
      2.771891,
      7.044159,
      3,
      3.370643,
      2.702678,
      NULL,
      1.688167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      5,
      1.127411,
      0.567454,
      0.505547,
      3,
      NULL,
      0.972435,
      2,
      2,
      0.668455,
      1,
      0,
      9,
      NULL,
      NULL,
      11.831937,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.141860,
      NULL,
      NULL,
      1.754978,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1,
      NULL,
      2.538401,
      2,
      1.188496,
      2.578740,
      1,
      0.542177,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.299667,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.304701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.105322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.968073,
      NULL,
      NULL,
      NULL,
      1.999790,
      NULL,
      NULL,
      NULL,
      1.422712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      8,
      5,
      3.163661,
      78,
      10.220677,
      3.816287,
      166.952753,
      1611,
      0.541802,
      NULL,
      NULL,
      1.619567,
      NULL,
      NULL,
      1.120951,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.291370,
      1,
      0,
      NULL,
      0,
      0,
      1.234404,
      NULL,
      0,
      0.789153,
      1.572087,
      0,
      0.463608,
      0,
      NULL,
      1.064151,
      0.436402,
      0.843506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.185596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476440,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.456736,
      NULL,
      3,
      NULL,
      6,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.848202,
      0.170915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705923,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066768,
      3.834630,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      326.410507,
      NULL,
      2.996993,
      NULL,
      0.306902,
      NULL,
      NULL,
      0,
      2.503933,
      NULL,
      34.547984,
      1.167709,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4.918756,
      3,
      0,
      2.451344,
      NULL,
      0,
      1,
      0.128429,
      1,
      NULL,
      1.398421,
      NULL,
      NULL,
      1.500238,
      1,
      0,
      2.814079,
      1.037445,
      0.914988,
      0,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0.740257,
      0,
      2,
      1,
      3.375384,
      0,
      1.436887,
      1.914446,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276560,
      1.089646,
      3.397321,
      2.199443,
      2,
      NULL,
      1,
      1.405474,
      2,
      0,
      1.934647,
      3,
      0,
      0,
      1,
      1.290125,
      0.868695,
      1,
      2,
      0,
      0,
      0.663639,
      1,
      3.715900,
      NULL,
      1.784919,
      4.233459,
      0.520914,
      2.758974,
      1.495482,
      0.114106,
      1,
      0.817128,
      1,
      1,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1,
      1.991030,
      1.435877,
      '23431',
      '',
      '',
      1.050117,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


