set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9539650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.598951,
      1.450828,
      2.701843,
      5.683145,
      5.702897,
      1.332972,
      1.181209,
      0.505112,
      '222',
      '13323241',
      48,
      67.160342,
      '0441223',
      2.788470,
      NULL,
      2,
      3,
      NULL,
      5,
      1,
      NULL,
      NULL,
      ' 5-25-1992',
      30,
      65.227297,
      NULL,
      2.403778,
      0,
      ' 1-27-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 9-11-1979',
      '10-22-1977',
      '10- 3-1977',
      2.283687,
      2.759661,
      1,
      3.454114,
      NULL,
      2.212555,
      1,
      1.663912,
      NULL,
      NULL,
      NULL,
      11.297146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      2,
      0,
      1.773772,
      1.966117,
      0.809239,
      0,
      0,
      1,
      0.758611,
      1,
      0,
      5,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      1,
      1,
      3,
      0,
      1,
      1,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.324970,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.952790,
      3,
      1,
      0.775985,
      1,
      NULL,
      1,
      2,
      NULL,
      1.090415,
      3,
      2.419971,
      3,
      1.114672,
      0.332359,
      NULL,
      3,
      3,
      0,
      3,
      4.575820,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1.179605,
      NULL,
      1,
      3,
      0,
      2,
      0,
      1,
      2,
      2,
      1,
      5,
      3,
      3,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      5,
      2,
      5,
      NULL,
      0.898937,
      0.975352,
      ' 7-12-1977',
      345.274418,
      NULL,
      18,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0.235813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.425174,
      0.435126,
      0.539669,
      NULL,
      NULL,
      4,
      1,
      2,
      3,
      1,
      0.995910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.745841,
      1,
      1.722570,
      1.639154,
      0.749040,
      0.394587,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.130495,
      0.776641,
      1,
      1,
      0,
      3,
      0,
      2,
      0,
      2,
      1,
      0,
      NULL,
      1.267959,
      0.746948,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.990597,
      NULL,
      1,
      0,
      1.111861,
      0,
      NULL,
      5,
      0.281433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.309803,
      12,
      NULL,
      61,
      56,
      5,
      2,
      4,
      '0310',
      '23224',
      '34300',
      0.851864,
      '',
      '',
      '',
      1,
      '42241',
      '',
      NULL,
      0,
      13,
      138,
      2,
      NULL,
      17,
      0,
      NULL,
      0,
      1.848383,
      0.143639,
      NULL,
      0.394463,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.134920,
      1,
      0.183723,
      1.126146,
      NULL,
      NULL,
      0.765524,
      NULL,
      NULL,
      NULL,
      0.374768,
      1,
      1.902816,
      NULL,
      NULL,
      1.655889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.197088,
      1,
      0.612296,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.462307,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.154159,
      1,
      0.233499,
      NULL,
      1.410152,
      1,
      1.352551,
      0.517373,
      3,
      2.891529,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.638440,
      0,
      1.886201,
      1.873597,
      0,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.667320,
      NULL,
      NULL,
      NULL,
      0.253213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.450070,
      4.695533,
      2.008983,
      0,
      NULL,
      NULL,
      1.737864,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.615155,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.988314,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983609,
      2,
      1,
      NULL,
      NULL,
      2.670297,
      NULL,
      4,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.206135,
      0.617312,
      0,
      2.884225,
      0,
      0,
      5,
      0.828140,
      NULL,
      0.005139,
      0.190422,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314068,
      0.557711,
      1,
      NULL,
      2,
      1.030805,
      NULL,
      2.797249,
      4,
      NULL,
      2.591402,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.410240,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499329,
      1.320391,
      0.123276,
      1,
      1.646198,
      1.628653,
      0.739948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.780077,
      1,
      2,
      0,
      1,
      2.852653,
      NULL,
      1.882370,
      NULL,
      1.600150,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.885174,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.315124,
      1.449398,
      NULL,
      1,
      0.988326,
      NULL,
      NULL,
      1.433366,
      0,
      0,
      0.802059,
      0.229277,
      1.219084,
      0.808570,
      1.180262,
      1.952441,
      1,
      0,
      0.703137,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      3,
      2,
      NULL,
      4,
      0,
      3.078775,
      1,
      3,
      NULL,
      NULL,
      1.765449,
      1,
      NULL,
      0.984210,
      1.989468,
      NULL,
      2.761072,
      3.583572,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.275964,
      0.124550,
      NULL,
      1.520389,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      1.101914,
      1,
      NULL,
      NULL,
      1.055208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.201758,
      NULL,
      0.251088,
      NULL,
      2,
      1,
      4,
      1,
      NULL,
      NULL,
      61.490797,
      NULL,
      4,
      3,
      3,
      '0134',
      '02323',
      '30031',
      0,
      '',
      NULL,
      NULL,
      3.245112,
      NULL,
      '',
      '');
commit;
end;
/


