set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7411597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      NULL,
      5,
      1,
      NULL,
      3,
      NULL,
      '324',
      '01031304',
      37.630602,
      26.551994,
      '4440443',
      3.654787,
      1,
      NULL,
      2,
      '1302',
      6,
      1.226204,
      NULL,
      NULL,
      NULL,
      37.063053,
      138.223210,
      NULL,
      NULL,
      1.866615,
      '10-23-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-15-1989',
      ' 0- 7-1985',
      ' 7-14-1974',
      1.169810,
      3,
      3.730450,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      7.641843,
      NULL,
      8.266750,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.605127,
      3,
      NULL,
      1.951357,
      1,
      0,
      1.797233,
      1.705096,
      0.794195,
      0.007361,
      NULL,
      NULL,
      5,
      4,
      NULL,
      4,
      0,
      1,
      5,
      NULL,
      3,
      0,
      0,
      2,
      NULL,
      1,
      1,
      0.379810,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0.989429,
      NULL,
      NULL,
      1,
      1,
      1,
      0.441522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      0,
      1,
      1.894163,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      NULL,
      4,
      NULL,
      2,
      2,
      0,
      NULL,
      3.431100,
      1.784294,
      ' 5-16-1989',
      896,
      ' 7-26-1978',
      231.035985,
      2,
      2,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      0,
      3.500927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.244795,
      3.260476,
      0,
      NULL,
      NULL,
      0,
      1.217623,
      4,
      NULL,
      5,
      5.141423,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436095,
      1.153038,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      1.108298,
      1.536798,
      37,
      2.664106,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      1,
      3,
      1,
      1,
      2.802099,
      NULL,
      NULL,
      2,
      1.394135,
      0.205150,
      1.248094,
      1,
      1.684290,
      1.142660,
      0.019880,
      NULL,
      1.494727,
      1,
      1.602732,
      NULL,
      1.940845,
      3.535404,
      0.089346,
      4.448401,
      NULL,
      6.846905,
      1.743940,
      2.883312,
      2.777745,
      NULL,
      NULL,
      0.534854,
      1.980759,
      2.645626,
      1,
      6,
      3,
      3.035807,
      NULL,
      NULL,
      37,
      22,
      NULL,
      0.027230,
      NULL,
      '00213',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0.860248,
      '',
      NULL,
      '',
      1.177922,
      28.514239,
      265,
      32.601186,
      0,
      35.753670,
      NULL,
      1,
      0,
      1,
      2,
      0.239011,
      0,
      NULL,
      NULL,
      0.342423,
      NULL,
      NULL,
      0.786712,
      0.083900,
      1.776275,
      1,
      NULL,
      NULL,
      2.206989,
      1.787393,
      1.421533,
      NULL,
      3.632983,
      0,
      1.045202,
      NULL,
      NULL,
      0.930501,
      1.087528,
      1.084117,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.280111,
      3,
      0,
      1,
      NULL,
      NULL,
      0.228867,
      NULL,
      NULL,
      1.825664,
      NULL,
      NULL,
      0.765022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993414,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.673004,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.470032,
      2,
      3.900880,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.981882,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.655373,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.260491,
      NULL,
      NULL,
      1.424169,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.737033,
      NULL,
      NULL,
      0.417679,
      1.352083,
      0,
      NULL,
      NULL,
      NULL,
      0.172426,
      1.240007,
      1,
      1,
      1,
      NULL,
      0.108910,
      NULL,
      NULL,
      0.815939,
      NULL,
      NULL,
      0.777387,
      3,
      1.574046,
      2.138142,
      3.694452,
      3,
      NULL,
      4.137695,
      3.895508,
      1,
      NULL,
      0.621466,
      3,
      3.201812,
      1.248329,
      0,
      0,
      NULL,
      0.721212,
      0.714073,
      2,
      2,
      5,
      NULL,
      2.036421,
      1.230028,
      1.948635,
      3,
      NULL,
      2,
      NULL,
      NULL,
      1.618450,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.591160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364645,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.489728,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1.489589,
      NULL,
      0.318869,
      1.365547,
      NULL,
      1.689920,
      0,
      NULL,
      3,
      1.043481,
      NULL,
      NULL,
      27.967313,
      11,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569392,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.594786,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.997043,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1.413493,
      NULL,
      NULL,
      1.452335,
      NULL,
      NULL,
      NULL,
      0.059954,
      1,
      NULL,
      NULL,
      5,
      7.300079,
      NULL,
      NULL,
      3.751003,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6.369351,
      0,
      0.149108,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.216192,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      395.739793,
      4.528165,
      0,
      3,
      NULL,
      NULL,
      0.017211,
      1.888739,
      0,
      3.250717,
      0.517310,
      NULL,
      NULL,
      0,
      0,
      1.641483,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.962084,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      19,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.435068,
      NULL,
      1,
      NULL,
      0.394158,
      NULL,
      1.670713,
      NULL,
      1,
      NULL,
      1.555535,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.522302,
      3.274685,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787595,
      1.259076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355598,
      1.995231,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.592180,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.577584,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.541241,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      52.192060,
      NULL,
      0.394916,
      2,
      3,
      NULL,
      1,
      1.752173,
      0.326802,
      NULL,
      NULL,
      NULL,
      0.387463,
      0.562882,
      0.310119,
      0,
      1.474172,
      1.088636,
      1,
      27,
      33.255668,
      3,
      2,
      3.920368,
      4,
      3,
      NULL,
      3,
      8.743991,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.755521,
      NULL,
      NULL,
      0.197133,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2.825639,
      NULL,
      0,
      1,
      NULL,
      1.391327,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.367131,
      NULL,
      1,
      0.257549,
      NULL,
      0.361484,
      1,
      NULL,
      3,
      1.089586,
      NULL,
      1.370417,
      NULL,
      NULL,
      3,
      0,
      1.705389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961175,
      NULL,
      NULL,
      NULL,
      0,
      4,
      7,
      0,
      NULL,
      NULL,
      NULL,
      89,
      5,
      1,
      NULL,
      '40301',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


