set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      1.181219,
      0.706794,
      NULL,
      2,
      '2110',
      2.781529,
      0.821303,
      NULL,
      NULL,
      ' 8- 1-2001',
      57,
      NULL,
      5,
      0.612298,
      1,
      NULL,
      NULL,
      NULL,
      3,
      166.520589,
      3,
      '10-12-1986',
      ' 9-16-1982',
      ' 6-14-1979',
      0.101551,
      1.260988,
      2.581626,
      NULL,
      0.016576,
      2.488788,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      9.013288,
      9.220153,
      9,
      5,
      10.888740,
      1,
      NULL,
      NULL,
      0.006132,
      1,
      1,
      0.138907,
      0,
      1,
      1.617079,
      NULL,
      NULL,
      1,
      0.332135,
      1,
      3,
      NULL,
      3.943539,
      NULL,
      4,
      0,
      0,
      NULL,
      0,
      4,
      NULL,
      3,
      0,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.756420,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.956442,
      NULL,
      1.523514,
      0,
      NULL,
      0,
      0,
      0.344349,
      NULL,
      0.558700,
      2.132603,
      1.993885,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      2,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1.321981,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      5,
      5,
      0,
      3,
      0,
      2,
      NULL,
      1,
      0,
      2,
      0,
      2,
      NULL,
      1,
      5,
      5,
      NULL,
      NULL,
      NULL,
      5,
      4,
      0,
      2,
      2,
      NULL,
      2,
      2.543594,
      ' 6- 7-1996',
      65,
      ' 7- 9-1991',
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      4,
      0,
      0.344866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.979051,
      NULL,
      3,
      3.180361,
      2.077259,
      NULL,
      1,
      NULL,
      NULL,
      0.971796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443259,
      0.940684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839089,
      0,
      0,
      1,
      1,
      NULL,
      1.900578,
      2.299272,
      31.545172,
      3.595599,
      1.148051,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.968186,
      3,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      16.481937,
      7,
      0,
      2.246381,
      NULL,
      5,
      NULL,
      1.675101,
      0,
      0.267509,
      1,
      1,
      1,
      0.571143,
      0,
      NULL,
      5,
      1.381877,
      10.370276,
      NULL,
      NULL,
      1,
      3.052677,
      2,
      NULL,
      2,
      5,
      1,
      0.511750,
      2.468248,
      52.355470,
      2,
      0.820366,
      NULL,
      78,
      20,
      NULL,
      1,
      NULL,
      3.534945,
      '34331',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.689350,
      '',
      '',
      '',
      1.070252,
      NULL,
      94.607505,
      27,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.618393,
      0.135691,
      0.488733,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.515278,
      1,
      NULL,
      NULL,
      1,
      0,
      0.461387,
      NULL,
      1.489067,
      NULL,
      NULL,
      NULL,
      3,
      2.728673,
      3.810246,
      2.388747,
      1.503706,
      NULL,
      NULL,
      3.248172,
      3.781100,
      2.605805,
      2,
      NULL,
      3.509520,
      4.726103,
      6.264502,
      4.489552,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.129147,
      1.852446,
      1,
      1.640842,
      NULL,
      NULL,
      0.360289,
      0.468454,
      1.204934,
      NULL,
      0,
      1.295995,
      3.106304,
      0,
      NULL,
      0.775653,
      1.833439,
      1.621179,
      0,
      2.448132,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.333119,
      2.870514,
      1,
      1,
      NULL,
      NULL,
      1.764806,
      3,
      0,
      5.119444,
      3,
      3.286487,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.092235,
      NULL,
      NULL,
      3,
      NULL,
      1.483566,
      1.536639,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.268651,
      1.264470,
      0.078459,
      3,
      0.570039,
      0,
      NULL,
      NULL,
      NULL,
      4.415211,
      1.550464,
      5.523659,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.048136,
      NULL,
      NULL,
      1.593617,
      NULL,
      NULL,
      0.852480,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.681603,
      3.201545,
      8.100241,
      6,
      2,
      5.138202,
      3.416044,
      0,
      3.891813,
      NULL,
      NULL,
      NULL,
      1,
      1.360964,
      3.139796,
      2,
      0,
      1,
      3,
      0,
      3.446025,
      2,
      1.276881,
      2.435777,
      1,
      0,
      0,
      0,
      NULL,
      1.904559,
      0,
      0,
      0.411427,
      NULL,
      NULL,
      3.719730,
      NULL,
      NULL,
      1,
      NULL,
      2.651090,
      0.641997,
      1,
      0,
      0.050140,
      0.516204,
      1,
      0,
      1.370665,
      NULL,
      NULL,
      NULL,
      0.924686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161059,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.532723,
      NULL,
      NULL,
      2.116274,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354400,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.950692,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.565180,
      NULL,
      NULL,
      1626,
      NULL,
      NULL,
      NULL,
      3,
      2.273662,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.697632,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.074902,
      0.935986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.405692,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.449141,
      1.695053,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.883726,
      NULL,
      NULL,
      NULL,
      1.694425,
      NULL,
      NULL,
      NULL,
      2.921854,
      0.496049,
      NULL,
      NULL,
      4.123342,
      0.464127,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      2.755451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.662524,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      19417,
      619.276462,
      0,
      NULL,
      1.039801,
      0.106653,
      1.279350,
      0.647250,
      0,
      1,
      1,
      NULL,
      0.142084,
      NULL,
      1.728941,
      0.211406,
      1,
      0.700427,
      0,
      0.723005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.421924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.414194,
      NULL,
      NULL,
      NULL,
      1.196688,
      NULL,
      0.496247,
      NULL,
      0,
      NULL,
      NULL,
      0.343492,
      1.244726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647095,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.819264,
      NULL,
      1.749084,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      7.681007,
      1,
      3,
      2,
      NULL,
      10,
      1.835300,
      1.963767,
      3.967421,
      1,
      NULL,
      1,
      2.571343,
      0,
      0.773436,
      0,
      2,
      NULL,
      0,
      3.287351,
      2,
      3.795811,
      NULL,
      3.763344,
      NULL,
      1.310210,
      3.917676,
      NULL,
      1.692254,
      1,
      1.524451,
      0.141382,
      1,
      1,
      0,
      NULL,
      NULL,
      3.202470,
      NULL,
      NULL,
      1,
      1.817241,
      3.308140,
      NULL,
      0.208375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      1,
      NULL,
      1,
      1.888279,
      1.889279,
      0,
      NULL,
      0,
      1.200891,
      0.514668,
      2.754902,
      NULL,
      2,
      2,
      NULL,
      0,
      0.934793,
      NULL,
      1.553518,
      NULL,
      0,
      1.616050,
      3,
      0.733014,
      NULL,
      0.755644,
      NULL,
      0.143063,
      0,
      1.867633,
      0.790333,
      1.933897,
      0,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      44,
      140,
      2,
      1.295742,
      NULL,
      '03321',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


