set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '4303420',
      2.832988,
      1.110329,
      5,
      3,
      '0020',
      3,
      0.074771,
      NULL,
      NULL,
      ' 8-16-1980',
      NULL,
      NULL,
      2,
      0.721307,
      7,
      ' 9- 7-1976',
      NULL,
      1.451918,
      91,
      144.772741,
      2,
      ' 4-15-1974',
      ' 8-10-2000',
      ' 9-19-2003',
      2,
      3,
      2,
      NULL,
      0.920795,
      1.903000,
      2,
      2,
      NULL,
      NULL,
      NULL,
      6.212099,
      0,
      157.550760,
      4,
      NULL,
      3,
      0,
      2,
      4,
      1,
      1,
      NULL,
      1.901715,
      1,
      0,
      1.525172,
      0,
      NULL,
      1.663073,
      0,
      2,
      2,
      1,
      1,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      4,
      0,
      0,
      1,
      4,
      2,
      NULL,
      0,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      1.806749,
      NULL,
      NULL,
      NULL,
      0,
      2.648403,
      0,
      0.372382,
      1.290082,
      1.094039,
      NULL,
      0.896971,
      0,
      0,
      1.446753,
      NULL,
      NULL,
      1.209259,
      1,
      3,
      1.673213,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1.449549,
      NULL,
      NULL,
      NULL,
      1.846717,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      4,
      4,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1.090011,
      NULL,
      1.608400,
      2,
      1,
      1,
      2,
      NULL,
      0,
      3,
      1,
      1,
      5,
      1,
      0,
      5,
      3,
      NULL,
      3,
      2,
      5,
      0,
      0,
      2,
      NULL,
      3,
      NULL,
      3,
      6.785816,
      3,
      NULL,
      393,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      1,
      4,
      0,
      0.644442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.534898,
      NULL,
      0.044654,
      0,
      0.559675,
      5.353769,
      1,
      2.261677,
      0.189008,
      NULL,
      NULL,
      1.095311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.727032,
      NULL,
      1.267163,
      1,
      1.954228,
      NULL,
      NULL,
      1.038071,
      28.038485,
      3.610809,
      0.975326,
      NULL,
      NULL,
      NULL,
      1,
      1.552633,
      0.040820,
      2,
      0,
      1,
      2,
      2,
      NULL,
      3,
      2,
      3,
      0,
      0,
      NULL,
      12.526480,
      6.192761,
      3,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.218014,
      0,
      1,
      0.605448,
      0,
      1.706051,
      NULL,
      NULL,
      5.454719,
      0,
      0.312431,
      1,
      NULL,
      6,
      2,
      1,
      2,
      1,
      1,
      3,
      30,
      1,
      NULL,
      NULL,
      62,
      29,
      NULL,
      4,
      0.686421,
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      0.741961,
      '',
      '',
      '',
      3.532885,
      2.415050,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.455834,
      0,
      NULL,
      NULL,
      0.964329,
      1,
      3.110007,
      1,
      NULL,
      NULL,
      3,
      3.547137,
      1.249043,
      2.116759,
      2,
      1.639893,
      0.909030,
      NULL,
      3.510823,
      3.939476,
      2,
      2,
      1.698921,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.632113,
      NULL,
      6.060600,
      7.855236,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.977761,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.672432,
      NULL,
      NULL,
      2.335178,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      2,
      1.250490,
      NULL,
      NULL,
      1.411140,
      NULL,
      1.390096,
      0.406518,
      1.123828,
      1,
      NULL,
      NULL,
      0.892395,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      5.315619,
      6,
      3,
      1,
      1.389760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190251,
      NULL,
      NULL,
      NULL,
      0.230206,
      0,
      1.796221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      1.050757,
      NULL,
      NULL,
      6,
      NULL,
      5.036891,
      0.221103,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.951033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004854,
      NULL,
      NULL,
      NULL,
      3.365050,
      3.151135,
      3,
      NULL,
      0.989208,
      3,
      1.420529,
      NULL,
      5,
      0.104807,
      2,
      2.461896,
      NULL,
      NULL,
      1.669118,
      NULL,
      1,
      NULL,
      1,
      1,
      2,
      2.607535,
      0.880571,
      1,
      2,
      0.768130,
      1,
      0,
      0.103595,
      1,
      3,
      1.723974,
      1.743668,
      2.914297,
      1,
      2.341750,
      NULL,
      0.340631,
      NULL,
      3,
      2,
      0.571174,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      0.627915,
      0.957035,
      1.635730,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222616,
      NULL,
      NULL,
      0.551841,
      NULL,
      NULL,
      1.833209,
      NULL,
      NULL,
      0.077352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379262,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.212430,
      NULL,
      0,
      1,
      1,
      2.047360,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.335208,
      NULL,
      NULL,
      2.273249,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464340,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310033,
      NULL,
      NULL,
      2.574247,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.789764,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      0.766237,
      NULL,
      NULL,
      3.917968,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222777,
      22.185267,
      NULL,
      3.929149,
      NULL,
      1.507620,
      0.585958,
      NULL,
      NULL,
      0.026477,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      676.376531,
      287,
      0.865701,
      1,
      1,
      1.638360,
      1,
      1.728621,
      1,
      0.741626,
      1,
      0,
      1.442049,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1.805130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.342441,
      0.211957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.910308,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.571694,
      NULL,
      NULL,
      1.267214,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.299508,
      NULL,
      0.622551,
      NULL,
      0.189865,
      NULL,
      NULL,
      NULL,
      1.473065,
      NULL,
      1.209724,
      NULL,
      1.930680,
      1,
      1.536730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2,
      13.362861,
      0.024417,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.194179,
      NULL,
      2,
      0,
      1,
      2.795113,
      NULL,
      3,
      0,
      0.345979,
      3,
      3.564495,
      0,
      0.399960,
      0,
      2,
      3,
      2,
      1.548337,
      NULL,
      NULL,
      1.767002,
      0.976559,
      1,
      0.920943,
      2,
      1,
      NULL,
      1.040041,
      2,
      NULL,
      3,
      0.657731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.960308,
      3,
      NULL,
      NULL,
      3.509959,
      NULL,
      0,
      NULL,
      0,
      1.917587,
      0.199084,
      NULL,
      2,
      3.353902,
      1,
      0.090454,
      0,
      1.168363,
      NULL,
      0,
      2,
      1.620564,
      NULL,
      0,
      1,
      22.736509,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.853224,
      1.877932,
      NULL,
      0,
      0,
      5,
      0.825286,
      NULL,
      NULL,
      17.982496,
      85.086930,
      NULL,
      0.751259,
      NULL,
      '20041',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.236517,
      '',
      '',
      '');
commit;
end;
/


