set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      0,
      '3311',
      3.026893,
      1.405985,
      NULL,
      NULL,
      '11-16-1986',
      NULL,
      NULL,
      4,
      0,
      5,
      ' 0-18-2003',
      3,
      2,
      NULL,
      111.429588,
      NULL,
      '11-26-1979',
      ' 8- 9-1992',
      ' 5-23-1985',
      NULL,
      1,
      NULL,
      1.600347,
      NULL,
      3.416331,
      2,
      2.536267,
      NULL,
      NULL,
      NULL,
      3.337116,
      2,
      NULL,
      NULL,
      0,
      5.984514,
      5,
      0,
      9,
      NULL,
      0,
      0,
      1.625502,
      2,
      1.983831,
      1,
      0.834613,
      1,
      0,
      1.163524,
      3,
      2,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.437017,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.455762,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.876763,
      NULL,
      1,
      NULL,
      1.470823,
      NULL,
      0,
      1,
      0.488875,
      1.213211,
      0.449121,
      0,
      1,
      0,
      0,
      5,
      0,
      2,
      0.822201,
      1.169725,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0.392021,
      NULL,
      0,
      2,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      4,
      NULL,
      1,
      0,
      0,
      0,
      1,
      3,
      3,
      0,
      5,
      1.789878,
      2,
      ' 6- 8-1992',
      0.168231,
      ' 9- 6-2001',
      0,
      0,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.710892,
      NULL,
      NULL,
      NULL,
      0,
      0.230680,
      NULL,
      1,
      NULL,
      0,
      1.473473,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.947306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.982630,
      NULL,
      1,
      NULL,
      1.609070,
      NULL,
      NULL,
      1.344635,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.417075,
      3.866636,
      0,
      1,
      2,
      0,
      2,
      2,
      NULL,
      2,
      0,
      3,
      1,
      10.069783,
      NULL,
      7.265399,
      3.314625,
      0.003783,
      0.781638,
      1.733689,
      NULL,
      1.227175,
      1.137810,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1.401062,
      0.928629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      44,
      60,
      71,
      NULL,
      1,
      2.675861,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.250850,
      2,
      27.017483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.619773,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.594875,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      2,
      0.135001,
      NULL,
      2.977290,
      3.401181,
      0.193129,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513490,
      2,
      2,
      3.116569,
      NULL,
      0.789547,
      2.787938,
      0.074268,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.835256,
      NULL,
      NULL,
      NULL,
      3.213361,
      2.536265,
      0.444860,
      1.628761,
      NULL,
      NULL,
      3,
      2.928299,
      NULL,
      NULL,
      NULL,
      1.283929,
      1,
      2.758003,
      0,
      1,
      NULL,
      1,
      0.530843,
      NULL,
      1,
      1,
      2,
      0.604326,
      1.398255,
      NULL,
      3.930939,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      0.597324,
      4,
      6.737523,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.870155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.933309,
      2.569059,
      1.812872,
      1.700029,
      0.099206,
      NULL,
      NULL,
      0.440384,
      2.658116,
      NULL,
      1.385955,
      NULL,
      NULL,
      1.303911,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.200433,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      5.038487,
      1.237866,
      2,
      2,
      2.296920,
      1.508602,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114499,
      2.873098,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      3.467957,
      1,
      NULL,
      3,
      0.934587,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      3.782263,
      0,
      1.648472,
      5,
      NULL,
      5.569264,
      1.083591,
      NULL,
      NULL,
      0.600333,
      3,
      2,
      0.212757,
      0,
      0.383777,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.152379,
      NULL,
      NULL,
      0.401871,
      NULL,
      NULL,
      0.038252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.264992,
      NULL,
      NULL,
      1.368084,
      0,
      NULL,
      1.272665,
      0.735643,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.236842,
      NULL,
      NULL,
      NULL,
      2.927643,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.265011,
      1,
      NULL,
      NULL,
      1,
      1.846493,
      NULL,
      NULL,
      NULL,
      1.903856,
      NULL,
      NULL,
      0.948490,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.062928,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.115948,
      27.102740,
      NULL,
      1,
      0,
      NULL,
      0.992473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.348789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.749669,
      NULL,
      1,
      6576.696792,
      938.739963,
      NULL,
      1,
      1.714812,
      1.086707,
      0.953164,
      1,
      0.654732,
      1.949380,
      1.904358,
      0,
      1.945437,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0.222766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.765791,
      NULL,
      0.098557,
      1,
      NULL,
      3,
      1.137517,
      3,
      1.612270,
      0,
      3,
      1.466187,
      0.022501,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.371889,
      NULL,
      NULL,
      1.406355,
      0,
      1,
      NULL,
      0.532698,
      NULL,
      1,
      1.609380,
      1,
      1.612221,
      NULL,
      0.557174,
      1,
      1,
      0,
      3.013128,
      0.782991,
      NULL,
      2,
      1,
      NULL,
      0.842434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978463,
      0,
      1.245184,
      NULL,
      1.525532,
      NULL,
      NULL,
      NULL,
      0.482395,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.330799,
      NULL,
      2,
      NULL,
      2.729675,
      NULL,
      0,
      NULL,
      0.441631,
      28,
      1.217810,
      1091,
      0.080200,
      1,
      0.456969,
      0.595361,
      NULL,
      NULL,
      2,
      1,
      0,
      1.711926,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.196108,
      2.839561,
      '40003',
      '',
      '',
      1,
      '',
      '',
      '',
      0.422765,
      '',
      '',
      '');
commit;
end;
/


