set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812738';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      1,
      0.746985,
      NULL,
      NULL,
      ' 4-16-2003',
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 9- 5-2000',
      10,
      1,
      173,
      81,
      4,
      NULL,
      NULL,
      ' 5-10-2002',
      NULL,
      1.939235,
      2.761449,
      0.429538,
      0.011440,
      2.081063,
      0,
      0,
      NULL,
      45,
      NULL,
      NULL,
      NULL,
      108,
      19,
      0,
      6,
      1,
      2,
      4,
      0,
      0,
      NULL,
      0.165699,
      3.180404,
      2,
      0,
      NULL,
      0.586150,
      1,
      NULL,
      1,
      0,
      3,
      2.284806,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.723828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0.512939,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      4,
      4,
      0,
      NULL,
      2,
      0,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      3,
      0.442000,
      ' 9-28-1997',
      55,
      ' 3-19-1991',
      62.820099,
      3.548412,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.521897,
      0.059393,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1.658293,
      1,
      NULL,
      0.157891,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.617787,
      1,
      6.325018,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      0.313303,
      NULL,
      NULL,
      NULL,
      2,
      0,
      53,
      NULL,
      NULL,
      NULL,
      3,
      1.256727,
      0,
      '32221',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      3.393711,
      46.173065,
      8,
      NULL,
      3,
      13,
      5,
      11.212413,
      NULL,
      0.923175,
      NULL,
      0.657423,
      0,
      NULL,
      NULL,
      0.843340,
      NULL,
      NULL,
      NULL,
      1.198936,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.853312,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.437681,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.549322,
      NULL,
      0.533107,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.635865,
      NULL,
      NULL,
      0.955121,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.424394,
      NULL,
      NULL,
      1.696513,
      4.118598,
      3,
      0.714387,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.018614,
      NULL,
      NULL,
      0.421189,
      NULL,
      NULL,
      1.712136,
      NULL,
      NULL,
      1.025279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.184866,
      3,
      0.462722,
      NULL,
      NULL,
      7.495292,
      5.540181,
      2.405658,
      NULL,
      9.087508,
      8,
      0,
      8.425215,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.542046,
      0.053406,
      8,
      0.902319,
      0,
      3,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.427901,
      0,
      1.862483,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.867218,
      0.655488,
      1.639617,
      NULL,
      NULL,
      1.339299,
      NULL,
      NULL,
      0.960234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426659,
      NULL,
      NULL,
      0.910209,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.859444,
      1.667468,
      1,
      0.472081,
      1.762380,
      1.406885,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.270264,
      NULL,
      NULL,
      NULL,
      1.323743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      18,
      0,
      13.123316,
      2,
      0.994651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.801595,
      NULL,
      NULL,
      NULL,
      1656.687973,
      1967.535005,
      0,
      NULL,
      NULL,
      11776.465057,
      867,
      0.862924,
      NULL,
      NULL,
      NULL,
      0.672044,
      1.931739,
      1.211404,
      0,
      0,
      1.376690,
      0,
      1,
      0,
      1.938038,
      1,
      1,
      NULL,
      1.048829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770952,
      NULL,
      6.840001,
      NULL,
      18.860640,
      14.639010,
      NULL,
      9,
      8.277445,
      NULL,
      13,
      6.439201,
      NULL,
      14.232110,
      9,
      NULL,
      18,
      6,
      NULL,
      6,
      18,
      NULL,
      15.203882,
      0.722273,
      NULL,
      7.973014,
      17.452342,
      NULL,
      11.080761,
      8,
      NULL,
      8.728145,
      4.519899,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490689,
      NULL,
      0,
      NULL,
      2,
      0,
      5,
      NULL,
      1,
      0.720201,
      0.975350,
      29,
      5,
      1,
      3.702181,
      '00022',
      '',
      '',
      0.590425,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


