set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220693';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      '33',
      9.735349,
      51,
      NULL,
      3.443176,
      NULL,
      6,
      2,
      '4224',
      NULL,
      0,
      NULL,
      NULL,
      ' 0- 3-1974',
      47.628527,
      1.780253,
      NULL,
      0.767628,
      NULL,
      ' 0-29-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10- 5-1983',
      ' 3- 1-1982',
      ' 4-18-1999',
      3.194960,
      0.057927,
      3,
      2,
      1,
      0.413413,
      3,
      NULL,
      0,
      0,
      NULL,
      5,
      5.954120,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      3.897962,
      4,
      1,
      1,
      1,
      0,
      0,
      4,
      NULL,
      2,
      4,
      2,
      1,
      NULL,
      0,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      6,
      2.377920,
      1.013426,
      0,
      3,
      0.475618,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      2,
      1,
      1.079571,
      1.395980,
      NULL,
      0,
      1,
      0,
      7.202526,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.399760,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      5,
      0,
      5,
      0,
      0,
      NULL,
      1,
      5.456382,
      0,
      1,
      1,
      0,
      0.062995,
      NULL,
      NULL,
      1,
      1,
      3,
      3,
      4,
      5,
      2,
      NULL,
      2,
      4,
      3,
      1,
      NULL,
      1,
      2,
      5,
      2,
      4,
      3,
      4,
      NULL,
      1,
      3,
      5,
      5,
      5,
      2,
      ' 9- 2-1978',
      740.871117,
      ' 3- 0-1992',
      16.708910,
      2.840448,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768740,
      3,
      NULL,
      NULL,
      NULL,
      2.192575,
      NULL,
      4,
      8,
      1,
      NULL,
      3.215272,
      NULL,
      NULL,
      NULL,
      1.338255,
      0.561526,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150941,
      0,
      1.529887,
      1.172595,
      2,
      1.883417,
      0,
      NULL,
      39,
      1,
      0.789546,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.992625,
      0,
      3,
      3,
      3,
      1,
      3,
      3,
      0,
      0,
      NULL,
      3,
      1.605171,
      1,
      2.162239,
      0.493295,
      0.956074,
      1.053573,
      1.023149,
      NULL,
      0,
      1,
      1.057067,
      NULL,
      0.258480,
      NULL,
      3,
      1,
      3,
      0,
      9,
      6.046134,
      6.223934,
      1,
      1.045963,
      2,
      5,
      NULL,
      0,
      1.228185,
      1,
      0.057420,
      3.686814,
      3,
      0.074994,
      56,
      NULL,
      3,
      4.347572,
      NULL,
      0,
      NULL,
      '20233',
      '',
      '',
      1.466590,
      '',
      NULL,
      NULL,
      1.004852,
      '',
      '',
      '',
      0.566954,
      4.730262,
      420,
      1.285877,
      1.057089,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.378793,
      1,
      NULL,
      NULL,
      0.579130,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.889728,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.151560,
      0,
      1.047901,
      0.775215,
      NULL,
      1.991089,
      NULL,
      1.540687,
      1,
      2,
      1,
      1.528876,
      0,
      0,
      1.306550,
      NULL,
      NULL,
      NULL,
      0.091885,
      3.022751,
      2.662310,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107672,
      0,
      1.940427,
      0,
      0,
      NULL,
      2.865359,
      1.732169,
      1,
      3.307968,
      NULL,
      0,
      0.142718,
      1.454522,
      NULL,
      2,
      2,
      1,
      NULL,
      0,
      3,
      0,
      2.000107,
      0.904475,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.721664,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.581198,
      NULL,
      NULL,
      3,
      0.378896,
      0,
      NULL,
      1,
      3.859624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.899976,
      1.481939,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.152412,
      NULL,
      NULL,
      NULL,
      0.940730,
      NULL,
      NULL,
      1.534544,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.614030,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      1.743427,
      1.787176,
      5.433216,
      NULL,
      1.878891,
      0.082209,
      2.259624,
      0,
      NULL,
      NULL,
      NULL,
      0.587990,
      3,
      3,
      3,
      3.346420,
      2.850690,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      2.538867,
      NULL,
      0.157799,
      0.234756,
      1,
      2.872708,
      0,
      0,
      NULL,
      2,
      0.050226,
      7.857780,
      1.676152,
      2,
      1.428734,
      4,
      1.948793,
      0.586650,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.057702,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291457,
      1.856114,
      1.076155,
      1.857781,
      1,
      1.132035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.414803,
      1.823565,
      1.728296,
      1.451519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.183721,
      0.861754,
      1.182959,
      NULL,
      NULL,
      0,
      NULL,
      1.723015,
      23.096153,
      5,
      0.353539,
      3.658057,
      1,
      1,
      0.004305,
      1.966039,
      NULL,
      2.484277,
      1,
      2.290046,
      NULL,
      NULL,
      0.960775,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      270.906191,
      NULL,
      2.097620,
      2,
      44,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.047646,
      NULL,
      2.750096,
      NULL,
      NULL,
      NULL,
      1.985371,
      NULL,
      NULL,
      NULL,
      3.835462,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.962739,
      1.566987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      6.980411,
      NULL,
      5,
      4.270007,
      NULL,
      NULL,
      0.567073,
      0,
      1,
      1.493958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.030249,
      0.649069,
      NULL,
      1.838629,
      1.699566,
      NULL,
      0,
      0.138709,
      NULL,
      1.093666,
      0,
      NULL,
      2,
      3.989893,
      NULL,
      3.891558,
      NULL,
      NULL,
      1.655400,
      1,
      1.941699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538907,
      NULL,
      NULL,
      NULL,
      3,
      4,
      6,
      2,
      0,
      2,
      NULL,
      81,
      NULL,
      5.380769,
      2.969586,
      '14104',
      '23411',
      NULL,
      1,
      '',
      NULL,
      NULL,
      1.438178,
      '',
      '',
      '');
commit;
end;
/


