set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813900';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0230113',
      2.748464,
      0,
      0,
      NULL,
      '2321',
      2,
      0,
      NULL,
      29.374737,
      '10-28-1988',
      NULL,
      NULL,
      5,
      2.436679,
      0,
      NULL,
      NULL,
      1.369814,
      NULL,
      159,
      0,
      NULL,
      NULL,
      ' 7-26-1979',
      NULL,
      1.871277,
      0,
      1.778044,
      0.147709,
      2.371663,
      0,
      1,
      1,
      154.313452,
      7,
      13,
      4,
      19.888859,
      18.164162,
      3,
      12.003647,
      0,
      2,
      7,
      0,
      1,
      1,
      NULL,
      1,
      1.227803,
      1,
      NULL,
      1.726347,
      1,
      168,
      4,
      3,
      0,
      2,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      0,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0.272463,
      NULL,
      NULL,
      3,
      NULL,
      1.685983,
      0,
      NULL,
      NULL,
      0.862172,
      NULL,
      3.138714,
      1,
      0,
      NULL,
      NULL,
      1.171923,
      1.007513,
      1.151837,
      1,
      3,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      5,
      1,
      NULL,
      0,
      0,
      0,
      1,
      3,
      3,
      0,
      4,
      0,
      NULL,
      1,
      1,
      1,
      2,
      5,
      3,
      2,
      2.975979,
      0.199051,
      NULL,
      1121,
      '10-23-2002',
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.325683,
      1.895145,
      1,
      3.149611,
      1.227561,
      0.676235,
      3.221490,
      0.129909,
      1.033750,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.324502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      2.610522,
      NULL,
      0.756345,
      0.723916,
      374.270921,
      1.053741,
      1.123399,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      2,
      2,
      0,
      NULL,
      2,
      0,
      3,
      0,
      1,
      5,
      1,
      NULL,
      2.605886,
      0,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      1.603716,
      0.869003,
      1,
      1.271513,
      NULL,
      13.533005,
      NULL,
      0.690086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411347,
      25,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      '23231',
      '',
      '',
      1.864749,
      '',
      '',
      '',
      1.392972,
      '',
      '',
      '',
      0.389802,
      14,
      211.242424,
      20.204113,
      NULL,
      26,
      13,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.546421,
      NULL,
      NULL,
      0.861153,
      1.473351,
      0.046280,
      0.444223,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.351564,
      2,
      0,
      0.355699,
      3.637286,
      1,
      NULL,
      NULL,
      5.532209,
      3.342847,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.728254,
      1,
      3.735586,
      0,
      1.673084,
      2.906173,
      0.255916,
      NULL,
      NULL,
      2.538926,
      1.767770,
      1.588157,
      1,
      0,
      1.703319,
      3,
      NULL,
      1.982558,
      NULL,
      1,
      1.200013,
      NULL,
      3,
      0.614572,
      1,
      NULL,
      2.552933,
      3,
      1,
      NULL,
      0.399590,
      NULL,
      1.002116,
      0,
      3.298458,
      1.960044,
      1.793495,
      4.860464,
      8.062530,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.473878,
      1.018560,
      2,
      2,
      1.276124,
      NULL,
      NULL,
      3.579188,
      1,
      0,
      2,
      2.172435,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      0,
      3,
      NULL,
      0,
      7.185685,
      4,
      1.116453,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.432846,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      2.407450,
      0.274020,
      0.506217,
      0.730535,
      NULL,
      NULL,
      4,
      4,
      1.160210,
      0.825528,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3.550116,
      0.028311,
      1,
      5,
      5.382709,
      NULL,
      2.652286,
      1,
      2,
      2,
      1.760249,
      0.151917,
      1.455916,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.482118,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.271523,
      NULL,
      NULL,
      NULL,
      0,
      2.683507,
      1.844134,
      1,
      NULL,
      0.972226,
      NULL,
      1,
      5.903216,
      NULL,
      NULL,
      1998.980800,
      NULL,
      NULL,
      NULL,
      0.173863,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.202208,
      0.356851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.380905,
      NULL,
      NULL,
      1.455189,
      1.437685,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.349937,
      0,
      NULL,
      NULL,
      2,
      3.871390,
      NULL,
      NULL,
      0.388710,
      0.747525,
      NULL,
      NULL,
      3.661260,
      1.633285,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.466058,
      3.899593,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.861452,
      4,
      NULL,
      NULL,
      2.938509,
      3,
      1,
      6,
      1,
      1,
      282,
      307.840442,
      0,
      366.172121,
      664.625427,
      1.466745,
      NULL,
      NULL,
      3.158541,
      1173.686213,
      436,
      0.157351,
      1331,
      620.605996,
      0.938732,
      264,
      498.328424,
      3,
      17.010870,
      NULL,
      NULL,
      1030.651049,
      0.880335,
      0,
      1.451005,
      NULL,
      1,
      3,
      1.054683,
      0.028245,
      NULL,
      NULL,
      NULL,
      0.827953,
      0,
      3,
      0.865268,
      0,
      NULL,
      3.313594,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2.782378,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      137.902796,
      NULL,
      NULL,
      24.678386,
      NULL,
      0,
      1.637018,
      4,
      NULL,
      2.234487,
      NULL,
      NULL,
      NULL,
      1.078984,
      NULL,
      1.553496,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3.113740,
      NULL,
      NULL,
      NULL,
      3.433575,
      NULL,
      2,
      NULL,
      0.263316,
      NULL,
      NULL,
      NULL,
      0.669257,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156602,
      0.260607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.839912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.624238,
      NULL,
      2,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.235293,
      1,
      0.294785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712444,
      3.595574,
      17,
      NULL,
      0.527800,
      NULL,
      3.268915,
      1.386153,
      3,
      4,
      NULL,
      17,
      1.935032,
      NULL,
      NULL,
      2,
      10,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1.787993,
      NULL,
      0.498792,
      0,
      NULL,
      3.182291,
      NULL,
      NULL,
      1.451436,
      0.504717,
      NULL,
      3.498016,
      3,
      NULL,
      1.161603,
      1,
      NULL,
      0,
      1.542428,
      NULL,
      NULL,
      0.805498,
      NULL,
      0,
      1.855069,
      NULL,
      1,
      0,
      3,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.768770,
      NULL,
      3.945886,
      NULL,
      NULL,
      NULL,
      0.202566,
      NULL,
      0.460602,
      NULL,
      3.719814,
      NULL,
      2.371609,
      NULL,
      1,
      NULL,
      127.200258,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.299786,
      NULL,
      0.859997,
      NULL,
      1,
      2,
      2,
      1,
      1.711180,
      2.036458,
      40.785576,
      32,
      5,
      1.067815,
      2.272620,
      '00221',
      '32103',
      '13301',
      0,
      '',
      '',
      '',
      0.308229,
      '',
      '',
      '');
commit;
end;
/


