set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7700718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3014414',
      3,
      1,
      NULL,
      0,
      '1312',
      0.166739,
      1.610903,
      NULL,
      NULL,
      ' 8-17-1978',
      30,
      NULL,
      5,
      2.588600,
      NULL,
      '10- 0-1989',
      16.001594,
      NULL,
      336.327301,
      9,
      1,
      ' 9-13-1983',
      NULL,
      ' 7-20-1975',
      0.631471,
      NULL,
      NULL,
      2.891177,
      1.042665,
      0,
      3,
      1.441870,
      0,
      NULL,
      7,
      8.158809,
      5.065843,
      19,
      0,
      NULL,
      9,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.175947,
      0.035635,
      1.467862,
      1,
      4,
      0.608097,
      1,
      1.695915,
      2,
      1,
      0,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      2,
      1,
      0,
      0,
      1,
      0,
      6.185835,
      0,
      2,
      1,
      NULL,
      1.899324,
      NULL,
      NULL,
      1.909222,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.534945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      2,
      4,
      3,
      1,
      4,
      NULL,
      3,
      0,
      0,
      4.008468,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      4,
      NULL,
      1,
      4,
      1,
      5,
      3,
      1,
      3,
      0,
      0,
      3,
      4,
      5,
      NULL,
      3,
      1,
      3,
      4,
      3,
      2,
      4,
      4,
      0.307144,
      NULL,
      11,
      '10- 6-1985',
      1.037623,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      2.418519,
      2.541136,
      1,
      2,
      5.448887,
      6.751104,
      1.627297,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      0.794184,
      2.113848,
      0.404959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.485601,
      1,
      0,
      2.182916,
      0.606195,
      0,
      0.013269,
      2,
      2.332367,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.245258,
      3,
      0,
      0,
      1,
      1,
      NULL,
      2,
      3,
      3,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1.502290,
      1.992325,
      NULL,
      0.796965,
      NULL,
      0.259703,
      0,
      0,
      0.485680,
      NULL,
      NULL,
      0.319605,
      1.431783,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725045,
      NULL,
      42,
      31,
      NULL,
      5,
      1.932414,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.709397,
      NULL,
      NULL,
      '',
      3.017243,
      9,
      15,
      1,
      NULL,
      27,
      NULL,
      1,
      2,
      1.453700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793056,
      NULL,
      NULL,
      0.510506,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.309210,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.752794,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.967100,
      NULL,
      NULL,
      NULL,
      2.057593,
      1.134913,
      0,
      0.572151,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.992622,
      NULL,
      NULL,
      1.253027,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066241,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.220139,
      5.726799,
      3.947384,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.126922,
      NULL,
      NULL,
      1,
      0.762441,
      NULL,
      NULL,
      0.024013,
      6,
      NULL,
      NULL,
      1,
      NULL,
      1.410726,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761263,
      NULL,
      NULL,
      1.414584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.219343,
      0,
      1,
      1.772867,
      NULL,
      NULL,
      5,
      2,
      0.639824,
      5.429844,
      6.933851,
      0,
      1,
      NULL,
      NULL,
      0.612954,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095304,
      NULL,
      NULL,
      0.301209,
      NULL,
      NULL,
      1.978580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655779,
      NULL,
      NULL,
      3.820382,
      NULL,
      NULL,
      3.049891,
      1,
      3,
      0,
      1.748015,
      NULL,
      NULL,
      NULL,
      3.140778,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.541184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868881,
      1,
      0.871549,
      1.957498,
      0.631802,
      NULL,
      0,
      NULL,
      NULL,
      1.751675,
      0.194403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941172,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213277,
      1.939552,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.481361,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.250902,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1.799342,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      0.388622,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.908187,
      NULL,
      NULL,
      0.636838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.416085,
      1.525621,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      68,
      NULL,
      NULL,
      1.130160,
      1.288045,
      0,
      1,
      NULL,
      1.164662,
      0.765260,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.027926,
      0.990729,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.008827,
      NULL,
      NULL,
      NULL,
      0.698784,
      NULL,
      1.155585,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      8,
      NULL,
      1,
      2,
      2,
      4.782288,
      3.382981,
      3.714525,
      NULL,
      NULL,
      0,
      0.792487,
      NULL,
      1.222731,
      NULL,
      NULL,
      NULL,
      0.634936,
      1.108166,
      1.067453,
      1,
      1,
      1,
      1.684162,
      NULL,
      NULL,
      0.456268,
      0,
      1,
      0.800726,
      1.516271,
      1,
      1,
      0,
      1,
      1.284509,
      1.772608,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097891,
      0,
      1.787168,
      0,
      1.391276,
      1,
      5,
      6,
      0.022470,
      NULL,
      NULL,
      52.639794,
      71.732568,
      NULL,
      NULL,
      3,
      '12112',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


