set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7700718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1232330',
      0,
      0.681988,
      2,
      2,
      '3344',
      3.240600,
      1,
      NULL,
      NULL,
      '11-25-1975',
      22,
      NULL,
      3,
      0,
      1.643177,
      NULL,
      4,
      2.035967,
      NULL,
      54,
      NULL,
      ' 8- 5-1984',
      ' 0-27-2003',
      NULL,
      0.295831,
      1,
      0.007279,
      1.432223,
      1,
      1.037276,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      13,
      2.894623,
      5,
      0,
      0,
      NULL,
      2.547238,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.038935,
      NULL,
      NULL,
      0.300169,
      0.692393,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1.761614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.932305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.701578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      4,
      5,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      3,
      3,
      1,
      4,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.773066,
      1,
      ' 6-11-1981',
      5.968884,
      ' 7-15-1990',
      8.599172,
      NULL,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.397671,
      0.063292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896512,
      1.767493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347012,
      NULL,
      1.238906,
      1.742358,
      0,
      1,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      3,
      3,
      2,
      2,
      2,
      3,
      2,
      3,
      0,
      2,
      2,
      5.509875,
      1.338436,
      0,
      0.620144,
      NULL,
      1.647270,
      1,
      1.208036,
      0.780065,
      0,
      1,
      1.061574,
      NULL,
      1.345258,
      1.833172,
      NULL,
      8,
      5.588994,
      6.161201,
      2.674281,
      0.288624,
      2.152267,
      1,
      1.999056,
      6.519920,
      NULL,
      2.721480,
      0.276469,
      46.785700,
      2,
      1.494446,
      NULL,
      49,
      NULL,
      47.466828,
      5,
      0.956403,
      NULL,
      '31403',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      2.932867,
      NULL,
      4,
      34.325002,
      0,
      1.578344,
      2.726275,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.467766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.209490,
      NULL,
      NULL,
      0.368154,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.795883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.443211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.048517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.479004,
      NULL,
      NULL,
      0,
      3.181456,
      1,
      3.067849,
      NULL,
      NULL,
      1.874038,
      NULL,
      NULL,
      0.699934,
      2.220805,
      NULL,
      3.559599,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      5,
      NULL,
      0,
      NULL,
      NULL,
      1.218573,
      NULL,
      NULL,
      1.714028,
      NULL,
      NULL,
      1.485201,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315418,
      NULL,
      NULL,
      0.107068,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.512090,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759213,
      NULL,
      NULL,
      2.209848,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.300833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519172,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.264518,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.024907,
      NULL,
      NULL,
      0.042967,
      NULL,
      NULL,
      0.840343,
      NULL,
      NULL,
      1,
      1.927252,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.749545,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894378,
      1.802092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760168,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.180286,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.344145,
      NULL,
      NULL,
      NULL,
      1,
      1.653094,
      NULL,
      NULL,
      0,
      0.404138,
      NULL,
      NULL,
      1.540898,
      0,
      NULL,
      NULL,
      3.674548,
      NULL,
      NULL,
      NULL,
      1.522162,
      0,
      NULL,
      NULL,
      0.797578,
      NULL,
      NULL,
      NULL,
      0.405338,
      1.827517,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5.859086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062384,
      NULL,
      NULL,
      0.113339,
      0,
      NULL,
      1.470665,
      NULL,
      NULL,
      1,
      NULL,
      1,
      25.486437,
      0.678918,
      NULL,
      0.070417,
      0.895873,
      0.442155,
      NULL,
      NULL,
      NULL,
      0.766473,
      1.366142,
      1,
      0,
      1,
      NULL,
      0.352941,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.043482,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.898480,
      NULL,
      0.612569,
      NULL,
      1.554294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      2,
      0,
      1,
      3,
      0,
      4.319529,
      1.434224,
      2.278433,
      2.322921,
      0,
      1.735918,
      0.828585,
      0,
      0,
      1.534561,
      0,
      NULL,
      1.006462,
      0.453702,
      1.591417,
      1,
      1.784955,
      1.113586,
      1.830486,
      NULL,
      2.260991,
      NULL,
      1,
      0.496448,
      0.944203,
      0,
      0.230602,
      NULL,
      1,
      0.785971,
      1,
      1,
      2,
      0,
      NULL,
      1.610225,
      0.482884,
      1.369278,
      NULL,
      0.807804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558931,
      NULL,
      1,
      0.357602,
      1,
      0.507275,
      3,
      2,
      3,
      1,
      NULL,
      NULL,
      38,
      47,
      0,
      1,
      2.555293,
      '02122',
      '',
      '',
      0.401842,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


