set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      24,
      '1101211',
      3,
      0,
      1,
      NULL,
      '1103',
      4.829751,
      NULL,
      NULL,
      NULL,
      ' 0-25-1996',
      24,
      1,
      NULL,
      0,
      0.117104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8- 3-1983',
      ' 4-29-2003',
      ' 8-11-1982',
      3.658569,
      0.166134,
      0,
      0,
      0.854822,
      0,
      3,
      NULL,
      NULL,
      NULL,
      5,
      10.478071,
      7.266150,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      1.530087,
      0,
      1.726013,
      0,
      0,
      NULL,
      2,
      2,
      NULL,
      0,
      1,
      1,
      5,
      1,
      5,
      4,
      3,
      NULL,
      4,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      2,
      0.208829,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      4.797375,
      0,
      1.086771,
      3.859355,
      1,
      2.810095,
      3.678688,
      0,
      NULL,
      NULL,
      3,
      1,
      0.449643,
      NULL,
      NULL,
      0,
      3.389203,
      3,
      NULL,
      NULL,
      10.375543,
      1,
      2,
      2.628023,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1.128589,
      NULL,
      2,
      2,
      1,
      3,
      2,
      0,
      1,
      4,
      3,
      2,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      3,
      5,
      1,
      NULL,
      4,
      1,
      3,
      1.085917,
      ' 7-21-1979',
      855.262202,
      ' 3-26-2001',
      805.714806,
      0,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      3,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.456241,
      0.073458,
      2,
      1,
      1.416263,
      0,
      0,
      2,
      11.086721,
      3,
      1,
      3,
      2.946295,
      0.699676,
      1,
      NULL,
      0,
      6,
      1.811986,
      0,
      7.964862,
      1,
      NULL,
      NULL,
      NULL,
      1.014920,
      7,
      0.048184,
      0,
      0,
      3,
      4.603286,
      ' 1-25-2003',
      3.608301,
      ' 1-12-1999',
      NULL,
      1,
      2,
      1,
      1.713150,
      NULL,
      0,
      3.439716,
      1,
      NULL,
      0,
      1.802779,
      24,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.508842,
      1.547528,
      NULL,
      3,
      1,
      1,
      2,
      1,
      NULL,
      1,
      2,
      2,
      0.346112,
      2,
      NULL,
      3.073245,
      0.910665,
      1,
      1,
      0,
      1.916486,
      1.984700,
      1,
      0.893967,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      5.439288,
      5.867990,
      0.373610,
      3.572894,
      5,
      3.703170,
      3,
      2.615107,
      3.267960,
      2.010794,
      0,
      NULL,
      5.391434,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      42.618535,
      1,
      2.871629,
      0.911613,
      '41033',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      154,
      18.982485,
      1.927069,
      30.467389,
      13,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.380892,
      NULL,
      NULL,
      0.872926,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      NULL,
      0,
      2,
      3,
      0,
      1,
      NULL,
      NULL,
      0.493320,
      NULL,
      NULL,
      NULL,
      1.060968,
      0.935286,
      3.663927,
      0.579669,
      1,
      1,
      NULL,
      NULL,
      7.898911,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.443630,
      0,
      3.473434,
      3,
      3,
      0,
      3,
      1.725504,
      NULL,
      NULL,
      3.250511,
      1,
      2,
      NULL,
      1,
      NULL,
      3.418955,
      1.131301,
      2.553927,
      0,
      NULL,
      2,
      0.285679,
      NULL,
      1.887930,
      3,
      1,
      2.126373,
      0.211755,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0.252117,
      0,
      1.844975,
      8.693770,
      2.439792,
      7,
      1,
      0.596004,
      NULL,
      NULL,
      NULL,
      3.569280,
      NULL,
      2.763023,
      0,
      1,
      NULL,
      NULL,
      1.457058,
      2,
      1.248826,
      NULL,
      1.616554,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.464852,
      NULL,
      NULL,
      4,
      0,
      0,
      0.864429,
      NULL,
      1.618327,
      1,
      NULL,
      NULL,
      0.121648,
      NULL,
      NULL,
      1.573649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891769,
      5,
      1.330936,
      NULL,
      0.423057,
      0.148697,
      3,
      2.127077,
      0.298230,
      2,
      0.819691,
      3.529451,
      3,
      NULL,
      0.623231,
      7.959641,
      2.797418,
      0,
      0.542810,
      0,
      0,
      0,
      2.717224,
      NULL,
      0,
      1.935950,
      NULL,
      2,
      2,
      0.831785,
      3.112505,
      2,
      0,
      0.458516,
      2,
      NULL,
      2,
      1.380433,
      2.454536,
      NULL,
      2,
      2.246824,
      8,
      4,
      7.215009,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      0.646872,
      NULL,
      0,
      1,
      2.776706,
      NULL,
      NULL,
      1.388930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.966043,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.983291,
      NULL,
      NULL,
      3.249661,
      1.400179,
      1.955155,
      0,
      2.670996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169321,
      1.463953,
      NULL,
      NULL,
      3.787025,
      0.149302,
      NULL,
      NULL,
      3.953013,
      1,
      NULL,
      NULL,
      1.248142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.111929,
      1,
      NULL,
      NULL,
      1,
      1.267506,
      NULL,
      NULL,
      1.086650,
      1,
      NULL,
      NULL,
      NULL,
      1.022363,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      3.711401,
      NULL,
      NULL,
      0.570339,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.906045,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.119000,
      1.028106,
      NULL,
      NULL,
      NULL,
      NULL,
      41.922364,
      285567.316109,
      0.042348,
      102,
      3091,
      1,
      NULL,
      NULL,
      0,
      63.461806,
      10863,
      0,
      23.513298,
      967.881767,
      1,
      11.835613,
      8490.386727,
      0,
      NULL,
      0.043212,
      919.020117,
      2360.063581,
      0,
      NULL,
      0.083069,
      NULL,
      1.982430,
      0.151747,
      1.073067,
      1.196109,
      1.372646,
      0,
      1.942469,
      1,
      NULL,
      0,
      NULL,
      0.291259,
      1,
      1.749417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      5,
      2,
      3,
      NULL,
      2,
      0.995604,
      1.334773,
      3,
      NULL,
      NULL,
      1.436608,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.652752,
      0.337070,
      NULL,
      0.607729,
      1.740938,
      NULL,
      NULL,
      1.199232,
      NULL,
      0,
      1.887666,
      NULL,
      1.556840,
      NULL,
      NULL,
      1,
      0.518077,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.233811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.758244,
      NULL,
      0.436938,
      NULL,
      0,
      0,
      NULL,
      0.370895,
      0,
      0,
      58.278438,
      59,
      0,
      2.318775,
      1,
      '31132',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


