set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '0033003',
      3,
      NULL,
      6,
      1,
      '1231',
      0.287666,
      1.030556,
      NULL,
      NULL,
      ' 4-12-1993',
      29.002192,
      NULL,
      2,
      1.632557,
      NULL,
      ' 8-22-1991',
      29.828538,
      2,
      188,
      123,
      3,
      '10- 5-1994',
      NULL,
      ' 5-15-1978',
      0.444610,
      3.533142,
      3,
      3.917055,
      1,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      5,
      9,
      3,
      10.843988,
      3,
      10.414818,
      NULL,
      NULL,
      9.925802,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      0.560578,
      5,
      1,
      0,
      0,
      0,
      0,
      0,
      3,
      2,
      1,
      0,
      0,
      3.987931,
      0,
      2,
      1,
      NULL,
      1.720833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1.168049,
      1.581092,
      NULL,
      3.896083,
      3.994201,
      3.776117,
      1.526223,
      NULL,
      0,
      1,
      1.124985,
      3,
      1.323636,
      1.599600,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      4,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      1,
      3,
      3,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5,
      0,
      4,
      1,
      NULL,
      4,
      NULL,
      2.208310,
      ' 7-20-2003',
      40.051958,
      NULL,
      175,
      1.228958,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.061510,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.940228,
      1.316797,
      1.064475,
      3,
      5,
      1.985402,
      2,
      3.924528,
      NULL,
      1,
      2,
      NULL,
      1.351179,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.767385,
      1,
      1,
      0,
      1.437734,
      1,
      0.967766,
      1.844727,
      31.740350,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.741421,
      0.331450,
      2,
      1,
      NULL,
      NULL,
      3,
      2,
      3,
      2,
      3,
      1,
      NULL,
      2,
      NULL,
      1.422049,
      1,
      0.211549,
      5,
      0,
      NULL,
      0,
      1.513723,
      1,
      1.452487,
      1,
      1,
      1,
      1.471421,
      16,
      1.309802,
      3,
      0,
      NULL,
      0.109780,
      8,
      4.434911,
      0,
      NULL,
      1,
      1,
      3,
      1,
      45,
      3,
      3.130488,
      NULL,
      36,
      23,
      11,
      4,
      3.657333,
      NULL,
      '24430',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.072984,
      NULL,
      91,
      NULL,
      NULL,
      31.613125,
      0.177727,
      0.534514,
      0,
      NULL,
      0,
      1.915834,
      NULL,
      NULL,
      NULL,
      3.248352,
      0,
      1.101858,
      0.644094,
      NULL,
      NULL,
      0.961080,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.685451,
      0.350799,
      NULL,
      NULL,
      0.608164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317665,
      NULL,
      NULL,
      11,
      8,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      3,
      2,
      3,
      1,
      NULL,
      NULL,
      2.674566,
      NULL,
      1.091863,
      0.758360,
      0.323437,
      3.089208,
      3,
      2.370314,
      1,
      1.046791,
      2,
      1.746654,
      0.905357,
      2.710471,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.212342,
      NULL,
      NULL,
      0.884148,
      NULL,
      NULL,
      3,
      9,
      5.686665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.946215,
      3.316038,
      1,
      1,
      NULL,
      NULL,
      3.103174,
      NULL,
      0,
      1.315092,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.038710,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.136939,
      NULL,
      NULL,
      1.000176,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.014483,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.866181,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.357924,
      3.037892,
      1,
      1.019817,
      2,
      5,
      7,
      0.106401,
      2,
      1,
      NULL,
      0.599772,
      0.430365,
      3.221614,
      1,
      1,
      2,
      3,
      3.378235,
      3,
      6,
      1.416545,
      4,
      NULL,
      5,
      NULL,
      2.880866,
      2,
      NULL,
      0.738003,
      0,
      0.656852,
      0.479203,
      0,
      NULL,
      NULL,
      NULL,
      5.930410,
      NULL,
      NULL,
      1.211543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.216539,
      NULL,
      NULL,
      0.456960,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.911242,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.234858,
      NULL,
      0,
      0,
      0,
      3,
      0.348543,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.883278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445732,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.417966,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298339,
      NULL,
      NULL,
      NULL,
      2.403338,
      NULL,
      NULL,
      NULL,
      0.208434,
      NULL,
      NULL,
      NULL,
      13.992699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854272,
      12,
      2,
      2,
      NULL,
      1.244371,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.192683,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0,
      0.143811,
      1,
      1,
      0.352475,
      0,
      1,
      0.001403,
      NULL,
      1.618480,
      0.436290,
      NULL,
      1,
      0,
      0.337829,
      NULL,
      1.201457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.598831,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.987472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.421055,
      NULL,
      0.922340,
      NULL,
      NULL,
      NULL,
      0.028332,
      NULL,
      1.685322,
      1,
      3.648843,
      1.561314,
      0.288432,
      NULL,
      NULL,
      1.636571,
      1.170568,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      9.524879,
      NULL,
      5,
      1.254532,
      NULL,
      4,
      NULL,
      1.999339,
      1,
      NULL,
      1.407059,
      NULL,
      0,
      1,
      NULL,
      1.798075,
      1,
      NULL,
      1.112861,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.564755,
      NULL,
      NULL,
      0.782673,
      NULL,
      NULL,
      0.056561,
      NULL,
      0,
      0,
      NULL,
      3.545806,
      1.596666,
      NULL,
      NULL,
      1.536571,
      NULL,
      2.591666,
      1.138630,
      0.325071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.375302,
      NULL,
      2,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      98,
      3,
      4,
      0,
      '11340',
      '',
      '',
      0.072757,
      '',
      '',
      NULL,
      1.317248,
      NULL,
      '',
      '');
commit;
end;
/


