set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8030435';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '3323242',
      2.434975,
      0.681016,
      1,
      NULL,
      '4313',
      2,
      1,
      NULL,
      NULL,
      ' 2- 3-1975',
      NULL,
      NULL,
      NULL,
      1.620013,
      1.803422,
      NULL,
      75,
      2.844001,
      88,
      38,
      NULL,
      ' 2- 1-1975',
      ' 2-17-1999',
      ' 9-29-1999',
      2.525735,
      2,
      NULL,
      0.282548,
      1,
      1,
      0,
      NULL,
      1.341353,
      97.014258,
      3,
      16,
      1.677647,
      11.669647,
      0,
      1,
      29,
      0,
      1,
      6,
      0,
      1,
      0,
      NULL,
      0.308603,
      1.428875,
      1.337271,
      1,
      NULL,
      NULL,
      1.589896,
      1,
      2,
      6,
      NULL,
      4,
      1,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      4.030944,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.403889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      1,
      2,
      NULL,
      1.432172,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1.701839,
      NULL,
      0.323371,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      3,
      NULL,
      NULL,
      4,
      0,
      2,
      0,
      4,
      2,
      5,
      NULL,
      5,
      3,
      5,
      0,
      5,
      NULL,
      2,
      5.717322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0.658578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.276003,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.070689,
      3.018391,
      NULL,
      NULL,
      1.547190,
      NULL,
      1.573198,
      7.641159,
      5.826811,
      0.163360,
      0.177378,
      NULL,
      NULL,
      NULL,
      NULL,
      2.680515,
      4.447017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.968957,
      NULL,
      0,
      0,
      NULL,
      1.539794,
      1.556085,
      30.662436,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.946456,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      3,
      3,
      NULL,
      1,
      1,
      1.445572,
      0,
      1.707414,
      NULL,
      1.955620,
      1,
      1.770308,
      0.438310,
      NULL,
      0.434843,
      0.434432,
      1,
      1,
      3.599797,
      NULL,
      NULL,
      1,
      NULL,
      9.585633,
      NULL,
      0,
      1.894069,
      2.718055,
      0,
      3.498971,
      3.252186,
      NULL,
      13,
      0,
      1,
      NULL,
      60,
      80,
      86,
      1,
      NULL,
      NULL,
      '20212',
      '22303',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      27.295405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.259707,
      2.306458,
      2.939782,
      1.768063,
      NULL,
      NULL,
      2.565887,
      3.132083,
      1.148252,
      NULL,
      NULL,
      NULL,
      2.594470,
      NULL,
      1,
      0,
      0.101927,
      1,
      0.635567,
      1,
      1,
      0.652907,
      NULL,
      NULL,
      1.844050,
      1,
      1,
      0.424155,
      NULL,
      NULL,
      1.691815,
      NULL,
      NULL,
      0.595145,
      NULL,
      NULL,
      8,
      1,
      4.180234,
      3,
      0.019509,
      NULL,
      NULL,
      NULL,
      1.493403,
      1,
      2.226935,
      2.815717,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      1.737233,
      0,
      0,
      0.218420,
      0.095862,
      0.016065,
      1.949341,
      0.561537,
      2.093963,
      0.243513,
      2,
      NULL,
      2,
      1.955343,
      0,
      2.277162,
      0.780998,
      0,
      NULL,
      3.633900,
      NULL,
      1.321441,
      1.814798,
      NULL,
      NULL,
      1.802957,
      1.637019,
      1,
      8,
      0.689742,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.005331,
      NULL,
      2.621588,
      0.858855,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.005264,
      NULL,
      NULL,
      0,
      NULL,
      1.263488,
      1.226274,
      NULL,
      1.496775,
      NULL,
      NULL,
      NULL,
      4,
      1.778132,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.638708,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464198,
      NULL,
      0.066083,
      0,
      2.055111,
      NULL,
      0.928999,
      4.815764,
      4,
      0.186896,
      1.697473,
      NULL,
      NULL,
      1.955248,
      0,
      0,
      1,
      1.845665,
      NULL,
      1.314553,
      NULL,
      0,
      0,
      5.226443,
      4.788633,
      3.169388,
      1,
      2,
      3.749760,
      3,
      0,
      1.360466,
      3.543543,
      2.725155,
      NULL,
      0.850267,
      2.887215,
      7.548724,
      0.528533,
      NULL,
      7.837114,
      5,
      5.541953,
      3.058053,
      1,
      NULL,
      1.563860,
      1.688962,
      1.979954,
      0.255493,
      1.039740,
      2.596066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.364417,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.602126,
      NULL,
      NULL,
      1.313059,
      NULL,
      NULL,
      0.095866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404975,
      NULL,
      NULL,
      1,
      2.021360,
      3,
      1,
      0,
      0,
      1,
      7,
      NULL,
      NULL,
      1.326204,
      NULL,
      3.884518,
      NULL,
      NULL,
      2,
      0.403537,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.688386,
      1.652545,
      NULL,
      1.658419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.694853,
      3.043209,
      NULL,
      0,
      0.172569,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.119607,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      1,
      1.622005,
      NULL,
      0,
      0,
      1.694435,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.809437,
      2.154166,
      2.149689,
      NULL,
      1.308438,
      2,
      2,
      NULL,
      NULL,
      2.537825,
      2,
      NULL,
      NULL,
      3.247669,
      12,
      NULL,
      5.971827,
      3,
      7.204691,
      NULL,
      2.923112,
      9,
      0,
      3.303614,
      25,
      17.353068,
      1.534385,
      15.091635,
      11,
      1.781834,
      NULL,
      NULL,
      NULL,
      2,
      0.872484,
      NULL,
      3.620535,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.919861,
      3.978737,
      1.471129,
      NULL,
      1,
      NULL,
      1.372358,
      0,
      1.837640,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      0.913622,
      0.008807,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.935397,
      NULL,
      1,
      NULL,
      3,
      NULL,
      164.167838,
      NULL,
      1,
      NULL,
      58.274691,
      NULL,
      0.297834,
      1.307403,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.463193,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.850029,
      NULL,
      1.467050,
      NULL,
      1.880245,
      NULL,
      0,
      NULL,
      1.833155,
      NULL,
      1.031352,
      NULL,
      1,
      NULL,
      1.734930,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036382,
      0.792896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396978,
      0.899447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.582578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153622,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.505896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.426922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      11,
      0,
      4.215309,
      4,
      NULL,
      NULL,
      0.076661,
      1,
      0.646083,
      1.021685,
      1,
      0.892260,
      0.476377,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.611859,
      1,
      0.139225,
      NULL,
      2.330978,
      0.380087,
      1.158474,
      0.177407,
      1,
      NULL,
      NULL,
      2,
      1,
      0.966175,
      0.090699,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0.076344,
      3.295309,
      3.232956,
      1.824488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.144080,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.639075,
      NULL,
      1.757054,
      NULL,
      2.176823,
      NULL,
      1.039120,
      NULL,
      3.715181,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.750628,
      NULL,
      NULL,
      NULL,
      1,
      22.098858,
      2.100388,
      NULL,
      1.370327,
      0.862650,
      1.343560,
      1.887955,
      1.253885,
      NULL,
      3,
      3,
      3,
      0,
      NULL,
      NULL,
      137.030497,
      68,
      NULL,
      1,
      1.783798,
      '41422',
      '23313',
      '',
      1.698907,
      NULL,
      '',
      '',
      0.255634,
      '',
      '',
      '');
commit;
end;
/


