set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '4030332',
      2,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      ' 8-19-2003',
      23.018308,
      NULL,
      3,
      NULL,
      1.852439,
      ' 1- 2-2000',
      23,
      2,
      291.559386,
      NULL,
      0,
      ' 6-15-1988',
      ' 5-11-1996',
      ' 6-10-1986',
      NULL,
      2.544429,
      1.045720,
      1.585870,
      1.662243,
      1,
      1,
      0.753806,
      1,
      12.059347,
      7,
      15.169661,
      7,
      6,
      5,
      4,
      14.831589,
      0,
      3,
      5.422423,
      2.870849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      5,
      1,
      4,
      0,
      NULL,
      1,
      0,
      0,
      5,
      0,
      0,
      1,
      1,
      0,
      7.320604,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.089156,
      1.642888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.753252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      2.269872,
      0,
      1,
      1,
      0,
      1.137958,
      NULL,
      0,
      3,
      2,
      NULL,
      3,
      1,
      4,
      4,
      2,
      5,
      NULL,
      1,
      3,
      3,
      NULL,
      0,
      NULL,
      4,
      5,
      NULL,
      5,
      0,
      4,
      1,
      5,
      1,
      5.261106,
      2,
      ' 8- 0-2000',
      330.783519,
      ' 4-21-1987',
      31.323779,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.294119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.601595,
      1.947203,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.249870,
      3,
      1.100751,
      NULL,
      NULL,
      NULL,
      1,
      2.236912,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305169,
      0.962508,
      1.475784,
      NULL,
      0,
      1,
      0,
      NULL,
      31.600708,
      1.682507,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659938,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      3,
      5,
      NULL,
      NULL,
      1.867684,
      1.914572,
      0.195395,
      1.988269,
      NULL,
      0.458249,
      NULL,
      1.779913,
      NULL,
      0,
      0.317384,
      1,
      0.138662,
      NULL,
      0,
      3.355587,
      1,
      NULL,
      7.719564,
      2,
      1.645346,
      0.147837,
      1,
      7,
      1,
      2.929563,
      2,
      38.556410,
      0,
      2.669327,
      NULL,
      17,
      13,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0.691026,
      NULL,
      '',
      '',
      3.101085,
      31,
      31,
      4,
      NULL,
      17.359943,
      5.647090,
      3,
      4,
      0.288260,
      2,
      0,
      0.459388,
      NULL,
      NULL,
      1,
      3.361579,
      3.149130,
      0.190824,
      NULL,
      NULL,
      0.658755,
      NULL,
      NULL,
      0.186228,
      NULL,
      NULL,
      3.604661,
      2.395255,
      NULL,
      1.885498,
      NULL,
      NULL,
      1.152875,
      NULL,
      NULL,
      0.794735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      2,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.275969,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.201640,
      NULL,
      NULL,
      0.654559,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.125841,
      NULL,
      NULL,
      1,
      4,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392072,
      NULL,
      NULL,
      3,
      0.050704,
      0.721360,
      NULL,
      3.304835,
      1.716472,
      0,
      NULL,
      NULL,
      4,
      4.389629,
      1.229852,
      0.331901,
      NULL,
      NULL,
      0.564555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.879111,
      NULL,
      NULL,
      0.172587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.911254,
      NULL,
      NULL,
      NULL,
      2.831068,
      NULL,
      0,
      2,
      3,
      6,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.572026,
      NULL,
      NULL,
      0.160798,
      3,
      0.787808,
      3,
      1,
      0,
      5.756961,
      7.269794,
      1,
      1,
      2.397668,
      3,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      3.868662,
      1.086332,
      1,
      3,
      NULL,
      5,
      1,
      2,
      5,
      3.200302,
      NULL,
      0,
      1.737078,
      1.225897,
      0.620699,
      0.567916,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.370467,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.199048,
      1.197261,
      0,
      1.306586,
      0.231015,
      1,
      3.371353,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.741145,
      NULL,
      NULL,
      NULL,
      0.166155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.466783,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2.318827,
      2.775562,
      NULL,
      NULL,
      0,
      0.083833,
      NULL,
      NULL,
      NULL,
      3.307476,
      NULL,
      NULL,
      1.584457,
      1,
      NULL,
      NULL,
      13,
      6.846773,
      NULL,
      NULL,
      0.587591,
      2.187610,
      0,
      4,
      1.206301,
      19,
      1.901088,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1.299927,
      1,
      NULL,
      NULL,
      1.666886,
      NULL,
      NULL,
      1,
      NULL,
      0.448142,
      378,
      35.212072,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.625366,
      NULL,
      0.071250,
      0,
      0.099112,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.193336,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.337087,
      NULL,
      2.344424,
      NULL,
      NULL,
      NULL,
      3.889688,
      14.408276,
      19,
      0,
      2,
      1.783411,
      NULL,
      1.767954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885145,
      NULL,
      NULL,
      NULL,
      3.013722,
      NULL,
      1.988412,
      NULL,
      2.603144,
      NULL,
      0,
      NULL,
      1.519905,
      NULL,
      0.484782,
      NULL,
      1,
      NULL,
      0.405749,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.044513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.615120,
      NULL,
      11.918390,
      NULL,
      1.936043,
      NULL,
      0.681062,
      NULL,
      0,
      1,
      NULL,
      11.376831,
      0,
      0.363631,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      0,
      0.648126,
      1.352832,
      1,
      0.695203,
      3,
      3.839162,
      0,
      NULL,
      0,
      1.369132,
      0.815775,
      NULL,
      1.604291,
      NULL,
      0,
      2.595433,
      0.040041,
      NULL,
      1.356533,
      0,
      NULL,
      NULL,
      0.016993,
      1.461547,
      1,
      1,
      1,
      1.598652,
      NULL,
      NULL,
      1,
      1,
      1.290257,
      1,
      0,
      0,
      2,
      0,
      NULL,
      1.372481,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771031,
      0,
      1.274529,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.681881,
      NULL,
      0.984673,
      NULL,
      3,
      NULL,
      0.897499,
      NULL,
      1,
      NULL,
      1.506789,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.840969,
      0.617442,
      1.777029,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.348486,
      NULL,
      NULL,
      NULL,
      39,
      0,
      0,
      NULL,
      NULL,
      NULL,
      '',
      0.585651,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


