set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      2,
      0,
      4,
      1,
      '2003',
      3.355479,
      0,
      NULL,
      NULL,
      ' 0-13-1978',
      9,
      NULL,
      3,
      0.456083,
      3,
      NULL,
      NULL,
      0.032550,
      127.279244,
      119.165688,
      1,
      ' 8-12-1985',
      ' 7-28-2000',
      ' 7- 6-1998',
      3,
      NULL,
      2.287096,
      NULL,
      1,
      2,
      2,
      0.533206,
      1.302159,
      10,
      7,
      13.697351,
      1.722702,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1.396023,
      0,
      1,
      0,
      NULL,
      1,
      0.194782,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      4,
      1.570314,
      1,
      0,
      2,
      0,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1.988342,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      3.600469,
      3,
      NULL,
      0,
      0,
      0.863191,
      1,
      NULL,
      NULL,
      1.884570,
      1.471260,
      NULL,
      3.151508,
      1,
      2.584319,
      NULL,
      1.408110,
      0,
      0,
      0,
      4,
      1,
      0,
      1,
      0.988866,
      NULL,
      NULL,
      1.512471,
      0,
      NULL,
      1,
      0,
      4,
      1,
      4,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      0.674618,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0.054680,
      NULL,
      0,
      0,
      5,
      1,
      4,
      3,
      NULL,
      5,
      NULL,
      NULL,
      3,
      3,
      0,
      1,
      3,
      2,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      3.030891,
      1,
      '11- 5-1991',
      NULL,
      ' 0-17-1974',
      30,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      5,
      3.204294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.599103,
      NULL,
      4.048796,
      0.795504,
      1,
      6.129936,
      8,
      NULL,
      1,
      NULL,
      3,
      6,
      3.655834,
      0,
      5,
      NULL,
      5.643405,
      ' 8-28-1996',
      30.239303,
      ' 9- 5-1994',
      NULL,
      1,
      NULL,
      0,
      3.846695,
      2.224692,
      3.391408,
      1,
      1.552524,
      NULL,
      0.791228,
      NULL,
      24,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.321116,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      0.950131,
      1.653930,
      0,
      4.743323,
      1.369927,
      NULL,
      NULL,
      0,
      1.444748,
      1.539908,
      0,
      NULL,
      NULL,
      NULL,
      0.908060,
      0,
      0.099033,
      2.287064,
      0,
      11.635146,
      10,
      3.046535,
      6,
      10,
      0.775697,
      0.532119,
      3.343754,
      NULL,
      1.688589,
      NULL,
      1.956732,
      15.374122,
      2,
      0.815176,
      NULL,
      30,
      39,
      46,
      3,
      NULL,
      2,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      22,
      65,
      3.454563,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.069918,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.230383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.817817,
      NULL,
      NULL,
      0,
      0,
      3,
      1.180968,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.319049,
      NULL,
      NULL,
      0.474334,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.999573,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.490478,
      1,
      0.450323,
      0.061089,
      NULL,
      NULL,
      1.706352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141482,
      NULL,
      NULL,
      0.594988,
      NULL,
      NULL,
      1.927635,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.176732,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.931400,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.719537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197350,
      NULL,
      NULL,
      1.504574,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.397577,
      0,
      0.061483,
      NULL,
      NULL,
      0,
      0,
      4,
      NULL,
      3.860617,
      3.315565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.351142,
      2.140644,
      0,
      6,
      7,
      0.973273,
      0,
      NULL,
      3.769799,
      NULL,
      0.047866,
      2,
      NULL,
      3.381897,
      1,
      NULL,
      3.469931,
      1,
      8.124186,
      NULL,
      1.309084,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      0.285110,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.220321,
      0,
      2.818615,
      0,
      NULL,
      NULL,
      1.648304,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.997914,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.570656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.226441,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.308503,
      0.451202,
      NULL,
      3,
      4,
      2,
      NULL,
      NULL,
      0.450936,
      2,
      0.188482,
      2.718184,
      2,
      1,
      0.858193,
      5.746389,
      1.258771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552366,
      NULL,
      0.051717,
      13,
      0.637645,
      1,
      NULL,
      0,
      NULL,
      0.744640,
      1,
      1.521875,
      1.131520,
      1,
      NULL,
      NULL,
      1.656763,
      NULL,
      1,
      0,
      NULL,
      1,
      0.398576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      NULL,
      3,
      2.415642,
      2,
      4.887566,
      NULL,
      NULL,
      0.384779,
      2,
      2,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.418788,
      0,
      NULL,
      3,
      3.094223,
      NULL,
      2,
      NULL,
      NULL,
      0.612804,
      NULL,
      NULL,
      1.064432,
      0,
      NULL,
      0,
      0,
      NULL,
      0.495445,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.183725,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0.679526,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.476307,
      97.465392,
      5,
      1,
      0.292352,
      '11002',
      NULL,
      '',
      0.646679,
      '',
      '',
      '',
      1.327775,
      '',
      '',
      NULL);
commit;
end;
/


