set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '0021432',
      2.249732,
      NULL,
      3,
      NULL,
      '0411',
      NULL,
      0.152186,
      NULL,
      NULL,
      ' 7-15-1975',
      18.620962,
      NULL,
      5,
      1.136651,
      NULL,
      ' 5- 5-1986',
      46.381512,
      2.444983,
      75.526954,
      183.305339,
      1,
      ' 2-26-1999',
      '10-25-1994',
      NULL,
      NULL,
      1.760869,
      0,
      NULL,
      1,
      0.227719,
      0,
      0,
      0,
      2.367003,
      7,
      12.306512,
      NULL,
      NULL,
      13.801275,
      4,
      33,
      NULL,
      2,
      4.220517,
      3.549307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      2.136399,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      3,
      2,
      NULL,
      4,
      2,
      NULL,
      8,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.534400,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      0,
      1,
      0.395968,
      NULL,
      2,
      1.289102,
      3,
      1.231114,
      1.435364,
      NULL,
      0.886364,
      0.547788,
      NULL,
      1,
      0,
      0,
      0,
      1,
      4.896377,
      0,
      1,
      NULL,
      0.744298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      3,
      1,
      1,
      4,
      4,
      3,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      4,
      5,
      2,
      2,
      5,
      1,
      2,
      2,
      1.908614,
      3,
      NULL,
      408,
      '11-25-1994',
      NULL,
      1.348496,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      1,
      1,
      1,
      0,
      3.759341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.425171,
      0.823276,
      NULL,
      1.131413,
      1161.287594,
      4,
      1,
      3.761690,
      0.148951,
      1.071389,
      0.607412,
      0.945973,
      1.232307,
      4.274130,
      0.374003,
      6.255488,
      2.596550,
      6.242965,
      0,
      NULL,
      NULL,
      1.305989,
      5.874584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657260,
      NULL,
      1.684296,
      NULL,
      2,
      0.087137,
      NULL,
      2,
      5.439400,
      1,
      1.760163,
      NULL,
      NULL,
      NULL,
      2,
      0.822966,
      2.284073,
      2,
      NULL,
      3,
      2,
      0,
      0,
      3,
      1,
      0,
      0,
      1,
      1.964297,
      2.252503,
      0.507860,
      NULL,
      0,
      NULL,
      1.979515,
      1,
      0.851640,
      NULL,
      1,
      0,
      NULL,
      0.021230,
      1,
      3,
      2,
      0.998983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      32,
      57.581048,
      5,
      0.520618,
      3,
      '40342',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.330361,
      4,
      117,
      32.479811,
      0.820752,
      5.229064,
      1.564625,
      1,
      1,
      0,
      NULL,
      0.155446,
      1.692431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736918,
      NULL,
      NULL,
      1.793065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.466396,
      NULL,
      NULL,
      1.828553,
      NULL,
      NULL,
      1.977587,
      0,
      1.880731,
      1.884737,
      0.872174,
      0.874527,
      0,
      NULL,
      NULL,
      0.288511,
      NULL,
      NULL,
      7.757587,
      0.192383,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.302716,
      0.819478,
      3,
      0,
      NULL,
      NULL,
      0.768170,
      NULL,
      NULL,
      1,
      1,
      0,
      1.152609,
      1,
      3.989648,
      NULL,
      0.058719,
      NULL,
      NULL,
      1.158080,
      0.178329,
      0,
      1.451289,
      0.083222,
      NULL,
      1.213853,
      NULL,
      NULL,
      0.393976,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      0,
      1,
      1.657197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.029076,
      0,
      NULL,
      NULL,
      1.953709,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.697698,
      10.081752,
      1,
      NULL,
      NULL,
      0.024545,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.248305,
      NULL,
      NULL,
      NULL,
      1.008032,
      NULL,
      NULL,
      1.703906,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.790752,
      3.568329,
      5.921997,
      1,
      9.694110,
      NULL,
      1.918886,
      3,
      NULL,
      NULL,
      1.167943,
      1,
      0.731989,
      2,
      NULL,
      0.932554,
      0,
      NULL,
      NULL,
      NULL,
      2.509857,
      5,
      1,
      3.409655,
      NULL,
      1.070698,
      2,
      0.742802,
      2,
      NULL,
      NULL,
      1.899469,
      0,
      NULL,
      9,
      6.718230,
      7.678831,
      9.395005,
      2,
      0,
      0,
      3,
      0,
      3.490944,
      0.199438,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      2.767783,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1.583907,
      NULL,
      NULL,
      2.501118,
      NULL,
      NULL,
      1.591819,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500713,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.455555,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.868944,
      0.864934,
      3.766373,
      0.871629,
      NULL,
      NULL,
      4.996738,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.373768,
      NULL,
      NULL,
      NULL,
      0.978676,
      NULL,
      NULL,
      NULL,
      1.158692,
      NULL,
      NULL,
      NULL,
      2.867221,
      NULL,
      NULL,
      NULL,
      1.717325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233677,
      NULL,
      NULL,
      NULL,
      1.614720,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.671099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.029950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514685,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0,
      5.228234,
      NULL,
      0,
      NULL,
      NULL,
      2.088418,
      1,
      NULL,
      0,
      5.985970,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531051,
      NULL,
      1,
      0.376340,
      0.533506,
      NULL,
      0.482740,
      1.920891,
      NULL,
      1.435244,
      1.510681,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      0.568056,
      1.587766,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773776,
      0.727225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678548,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.068592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.322049,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.593264,
      12,
      35.947815,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.917530,
      2,
      NULL,
      NULL,
      3,
      0.737287,
      1,
      0.947047,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841162,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.585333,
      NULL,
      NULL,
      0.540490,
      0.917351,
      NULL,
      1.938117,
      0.735147,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616728,
      0,
      NULL,
      0.232670,
      NULL,
      NULL,
      2,
      0.569236,
      1.281580,
      0.701514,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.039490,
      NULL,
      0,
      NULL,
      0.701764,
      NULL,
      1.763947,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.034091,
      NULL,
      31,
      1.773638,
      NULL,
      0.425532,
      1,
      NULL,
      12.332167,
      NULL,
      2.880890,
      NULL,
      0.257590,
      NULL,
      2.349846,
      NULL,
      15,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      16,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      '33343',
      '34121',
      '',
      NULL,
      '',
      '',
      '',
      0.700070,
      NULL,
      '',
      NULL);
commit;
end;
/


