set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '4130',
      NULL,
      0,
      NULL,
      NULL,
      ' 5- 3-1993',
      17.802389,
      NULL,
      1,
      NULL,
      1,
      ' 3-27-1995',
      20,
      0.733855,
      158.113511,
      9.488088,
      3,
      ' 5- 3-1993',
      ' 2- 5-1988',
      NULL,
      3.307028,
      3,
      0.618795,
      0.786342,
      1.482301,
      0,
      0,
      0,
      0.959291,
      3.600377,
      3,
      19,
      0,
      25.971263,
      19,
      4,
      30.326315,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      0,
      0,
      0.654941,
      2,
      0,
      2,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      5,
      0.229004,
      2,
      0,
      NULL,
      2,
      0,
      0.187666,
      3,
      1.363140,
      0,
      NULL,
      0,
      1.021361,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      0,
      9,
      NULL,
      2,
      3,
      NULL,
      0.431023,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      2,
      0,
      4,
      3,
      0,
      1,
      NULL,
      5,
      4,
      3,
      0,
      2.915733,
      0,
      1,
      1,
      1,
      0.710339,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4,
      0,
      4,
      5,
      0,
      0,
      4,
      3,
      1,
      2,
      5,
      NULL,
      3,
      3,
      NULL,
      0,
      4,
      3,
      5,
      NULL,
      NULL,
      NULL,
      2.293360,
      0.673224,
      ' 4-20-2000',
      64.332683,
      ' 4- 8-1990',
      NULL,
      2,
      2,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      4,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      1.703673,
      NULL,
      ' 6- 1-1989',
      27,
      ' 8-12-1981',
      6,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.555854,
      NULL,
      0.738092,
      2.431001,
      0.877703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.188195,
      0,
      0,
      0.563438,
      1.589429,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.545197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.235308,
      1.959857,
      3.665961,
      NULL,
      0.252195,
      NULL,
      0.421233,
      13,
      0.818005,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      0,
      3,
      0,
      0,
      NULL,
      2,
      3,
      3,
      1,
      2.180303,
      1,
      3.279703,
      0,
      0,
      1.049796,
      4.761144,
      1,
      1.766700,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      7.140039,
      7.406263,
      0,
      NULL,
      NULL,
      NULL,
      3.251706,
      7,
      1,
      3,
      NULL,
      61,
      1,
      0.652326,
      NULL,
      6,
      17,
      40.617270,
      5,
      0,
      2,
      '03303',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      1.275315,
      '',
      '',
      '',
      2.717331,
      NULL,
      123.556468,
      26,
      3.904548,
      NULL,
      0.070351,
      3,
      NULL,
      NULL,
      2.013842,
      0.458546,
      0,
      NULL,
      NULL,
      3,
      0.985435,
      1,
      1.453697,
      1,
      1.002412,
      NULL,
      NULL,
      NULL,
      1,
      1.005843,
      NULL,
      0,
      NULL,
      0.939769,
      0.618399,
      NULL,
      NULL,
      0.287792,
      NULL,
      NULL,
      NULL,
      0.713973,
      0,
      1,
      NULL,
      NULL,
      0.175183,
      NULL,
      NULL,
      9,
      5,
      0.410432,
      0,
      NULL,
      3.523177,
      NULL,
      1.812618,
      2.765514,
      2,
      NULL,
      2,
      1,
      1.427862,
      1.381002,
      3,
      0.318880,
      1,
      2,
      0,
      0,
      NULL,
      1.158495,
      0,
      2.834037,
      0,
      0.858647,
      NULL,
      0,
      NULL,
      1.815378,
      0,
      1.958995,
      1.313667,
      NULL,
      0,
      NULL,
      1.418091,
      1.322978,
      0,
      2,
      0.879088,
      0,
      NULL,
      NULL,
      NULL,
      5.509725,
      1.413281,
      0.563740,
      3,
      3.420884,
      1.318283,
      1.942668,
      1,
      3.489515,
      1,
      0.546979,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2.403380,
      NULL,
      2.906927,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4,
      0,
      0.686291,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.988214,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.623918,
      NULL,
      NULL,
      1.212597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400944,
      NULL,
      NULL,
      1.524820,
      0.492985,
      0,
      NULL,
      1.285182,
      1,
      4.079312,
      0.123999,
      0.601149,
      NULL,
      NULL,
      1.345058,
      0.813391,
      NULL,
      1,
      3,
      0.292364,
      0.875010,
      0,
      1,
      0,
      2.417867,
      1,
      1,
      3,
      1.279596,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.953954,
      NULL,
      NULL,
      NULL,
      4.125184,
      NULL,
      57,
      34,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.243669,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0.955643,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131002,
      NULL,
      4.029703,
      0,
      NULL,
      0,
      3.676683,
      1,
      2,
      0.453264,
      3,
      2.704200,
      NULL,
      NULL,
      8.090558,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.924999,
      0,
      1.091238,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.230377,
      0.094859,
      NULL,
      NULL,
      1.247646,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.805384,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.555104,
      1,
      NULL,
      NULL,
      0,
      2.917743,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0.157136,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.086832,
      1,
      0.691792,
      NULL,
      NULL,
      1.105415,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      11.889708,
      NULL,
      0,
      NULL,
      0,
      0.675995,
      NULL,
      NULL,
      NULL,
      0.860626,
      1.216277,
      2,
      1.000006,
      0,
      2.503282,
      1.185499,
      NULL,
      NULL,
      NULL,
      0.889452,
      1.514840,
      2,
      4,
      3,
      NULL,
      NULL,
      NULL,
      1.595682,
      NULL,
      0.374286,
      90,
      NULL,
      1,
      0,
      NULL,
      0.997079,
      1,
      NULL,
      NULL,
      1.779516,
      NULL,
      1.401621,
      1,
      1,
      1,
      1,
      1.684925,
      1,
      0.130349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.174927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.913499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921191,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566899,
      0.409086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614870,
      0,
      NULL,
      0.408715,
      NULL,
      1.807343,
      NULL,
      NULL,
      NULL,
      1.314034,
      1.171764,
      0.499597,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.360255,
      NULL,
      1.968216,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      2,
      3.732960,
      2,
      0,
      0,
      13,
      NULL,
      2.065272,
      2,
      0,
      1.437066,
      0.111071,
      1.983532,
      3.089781,
      NULL,
      1,
      0.509911,
      1,
      0,
      0.576902,
      1.046425,
      1,
      1.292092,
      0,
      NULL,
      0.342962,
      0.317143,
      1,
      1.057719,
      0,
      1.442446,
      1.579412,
      0.966206,
      1,
      NULL,
      1,
      1,
      0,
      0.734634,
      0,
      1.110879,
      1,
      1,
      2,
      0.704308,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.846723,
      NULL,
      0.671014,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.790031,
      NULL,
      1.252950,
      NULL,
      3,
      NULL,
      0.151956,
      NULL,
      0.334378,
      NULL,
      1,
      34,
      1.381131,
      2,
      NULL,
      1,
      2.913696,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.615717,
      NULL,
      0.997502,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.316642,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      31.351975,
      NULL,
      NULL,
      1.592166,
      1.233909,
      0.237309,
      NULL,
      0,
      1.870280,
      NULL,
      5,
      4,
      1.691861,
      NULL,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      2.493316,
      '20303',
      '',
      NULL,
      0.059083,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


