set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '4031024',
      1,
      1,
      2,
      NULL,
      '3230',
      2.876353,
      0,
      NULL,
      NULL,
      ' 6-13-1998',
      30,
      NULL,
      NULL,
      1,
      3.485447,
      ' 3-24-2002',
      NULL,
      NULL,
      NULL,
      137,
      1,
      NULL,
      NULL,
      '11-29-1979',
      2,
      1.471384,
      NULL,
      3.285424,
      0.548638,
      3,
      0,
      NULL,
      0,
      4.013205,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      1,
      11,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      4,
      3.246816,
      1.692743,
      1.232113,
      2,
      1,
      NULL,
      3.963154,
      2,
      0.366338,
      0.236236,
      2,
      1,
      2,
      3.995017,
      2,
      1.367547,
      3,
      1,
      0,
      4,
      0,
      0,
      NULL,
      1.538772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      2,
      4,
      0,
      NULL,
      NULL,
      5,
      4,
      1,
      0,
      3,
      0,
      0,
      5,
      0,
      1,
      3,
      5,
      1,
      5,
      3,
      3,
      5,
      2.459631,
      ' 7- 7-1989',
      NULL,
      ' 8- 0-1986',
      5.706684,
      2,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.602196,
      1,
      NULL,
      1,
      1.614341,
      NULL,
      0,
      2.172586,
      573.211474,
      NULL,
      0,
      0,
      2,
      0.626105,
      1,
      NULL,
      0,
      7.798142,
      5,
      2,
      2.802077,
      4,
      0,
      NULL,
      NULL,
      1.441208,
      6.346466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.798023,
      1.589944,
      1.958920,
      1.071219,
      0.136570,
      0,
      1.959506,
      51.215036,
      2,
      0.629650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.539169,
      1,
      3,
      0,
      3,
      3,
      2,
      2,
      0,
      2,
      0,
      3.480991,
      0,
      3.558071,
      0.704093,
      0,
      1.469142,
      4,
      1.747315,
      0,
      0,
      1.596397,
      1,
      1,
      1.812200,
      0.845500,
      0,
      1.048042,
      0.485475,
      NULL,
      3,
      8.158169,
      0,
      NULL,
      4.157904,
      5,
      5.279656,
      1,
      6,
      2,
      0,
      3.278073,
      25.810165,
      0,
      3,
      NULL,
      56,
      35,
      56,
      3,
      1,
      1.215023,
      '31212',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      3.587243,
      44,
      32,
      37,
      3.033408,
      NULL,
      4.563938,
      NULL,
      5,
      1.778519,
      NULL,
      3.377736,
      0,
      NULL,
      NULL,
      0,
      0.955129,
      1.974437,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.420241,
      2.949167,
      1,
      0.443042,
      1,
      NULL,
      NULL,
      3,
      0,
      1.988107,
      1,
      1.493908,
      0.973654,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.702496,
      0.274992,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912991,
      NULL,
      NULL,
      NULL,
      0.756136,
      NULL,
      3,
      2.960885,
      0.752430,
      0.147698,
      NULL,
      NULL,
      NULL,
      3.160891,
      1,
      1.128871,
      0.549845,
      1.613676,
      0.588394,
      0,
      3,
      1.623683,
      0,
      2.421539,
      1.618936,
      NULL,
      1.194033,
      3.137057,
      NULL,
      1,
      NULL,
      NULL,
      0.353745,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.658136,
      4,
      1.243473,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.590944,
      3,
      1.736264,
      0,
      NULL,
      1.480675,
      1,
      NULL,
      NULL,
      6.240325,
      NULL,
      1,
      3.127518,
      NULL,
      0.747831,
      1.141443,
      NULL,
      NULL,
      1.516516,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.472897,
      NULL,
      NULL,
      0.421204,
      NULL,
      NULL,
      1.873418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.126065,
      NULL,
      NULL,
      3.029994,
      2,
      NULL,
      1.511287,
      4,
      0,
      NULL,
      NULL,
      1,
      0.629563,
      NULL,
      NULL,
      2.133280,
      2.791261,
      1.181225,
      2.128982,
      3.292178,
      1,
      0,
      NULL,
      NULL,
      3.561467,
      2.201050,
      4.786717,
      0.473397,
      NULL,
      NULL,
      1.841216,
      0,
      NULL,
      NULL,
      1.199107,
      NULL,
      2.962436,
      3.149468,
      NULL,
      NULL,
      3.998486,
      NULL,
      9.538728,
      6,
      1,
      2.699799,
      0,
      2,
      1,
      NULL,
      1,
      1.393214,
      0,
      0,
      NULL,
      NULL,
      6.831183,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      0.226660,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.800748,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.299775,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      12.850774,
      NULL,
      NULL,
      1.370950,
      NULL,
      NULL,
      1.836251,
      NULL,
      NULL,
      0.720541,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5.659766,
      NULL,
      NULL,
      0.819611,
      2,
      NULL,
      1.041165,
      NULL,
      2.756872,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      8.981366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160502,
      NULL,
      NULL,
      NULL,
      2.006006,
      NULL,
      NULL,
      NULL,
      1.758539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854520,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.463752,
      NULL,
      NULL,
      NULL,
      0.700473,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.082884,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.745118,
      NULL,
      NULL,
      NULL,
      3.402884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5.914980,
      1,
      3.313530,
      4,
      4,
      0.957834,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      10.893940,
      0.847472,
      0.105453,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833005,
      0.528774,
      1,
      1,
      NULL,
      0.782798,
      1,
      1,
      0.262277,
      1.508000,
      0.628452,
      1,
      0.596823,
      0,
      1.167014,
      0,
      0,
      0,
      NULL,
      0.357413,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569141,
      0.320525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173222,
      1.256619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059235,
      0.275467,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      103.283792,
      NULL,
      1.223108,
      NULL,
      1.731918,
      NULL,
      0,
      0.852126,
      3,
      6.436365,
      26.920116,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      0,
      NULL,
      2.248393,
      3,
      2.471455,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.946492,
      0.373119,
      NULL,
      0.611355,
      1.526518,
      NULL,
      1,
      0,
      NULL,
      1.819163,
      1.409844,
      NULL,
      1.732608,
      0.218532,
      NULL,
      1.301327,
      1.910521,
      NULL,
      0.016504,
      0.932870,
      NULL,
      0,
      3.928425,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.100676,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.702036,
      NULL,
      0.789816,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      0,
      NULL,
      1,
      3,
      NULL,
      13.172360,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3,
      NULL,
      4,
      NULL,
      3,
      NULL,
      0.033371,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.317126,
      NULL,
      1.871043,
      NULL,
      10.460713,
      NULL,
      12,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5,
      1,
      NULL,
      NULL,
      13.002512,
      NULL,
      5,
      1,
      6.440425,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


