set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '3103141',
      1.356775,
      NULL,
      1,
      1,
      '0332',
      2.824486,
      1,
      NULL,
      NULL,
      NULL,
      26.673427,
      NULL,
      NULL,
      3,
      1,
      '11-28-1979',
      43.372526,
      0.373849,
      NULL,
      NULL,
      3,
      ' 3-16-2000',
      ' 6-23-1986',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963211,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      23.996047,
      24,
      3,
      NULL,
      0,
      3,
      2.611673,
      1.574885,
      NULL,
      1,
      0.706133,
      0.153945,
      1.495303,
      1,
      1.904348,
      0.455365,
      NULL,
      NULL,
      1,
      3,
      1,
      0.066636,
      0,
      0,
      0,
      1,
      1,
      1,
      5,
      0,
      NULL,
      2,
      1,
      NULL,
      5.927336,
      1,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      0.141949,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3,
      1.988921,
      0,
      1.022713,
      0.363987,
      1,
      2.807110,
      1.460046,
      1.736366,
      NULL,
      NULL,
      1.908171,
      0.617492,
      0,
      0.717178,
      2.676640,
      0,
      0,
      NULL,
      0,
      0,
      2,
      0,
      0.963355,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      0,
      1,
      3,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      5,
      1,
      1.981029,
      1,
      0,
      1,
      1,
      1.048421,
      NULL,
      1.452832,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      1,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.454933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.138119,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.573783,
      0.776099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.736916,
      1,
      1.492726,
      0.752749,
      NULL,
      1,
      1,
      NULL,
      6.133350,
      1.716862,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509153,
      NULL,
      2,
      3,
      2,
      1,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      0.015692,
      3,
      3.361907,
      0.704332,
      NULL,
      0.088435,
      3.278034,
      0.763484,
      NULL,
      1,
      1,
      1,
      1.725653,
      1,
      0.166173,
      0,
      0.127276,
      2.593588,
      1.450402,
      NULL,
      9,
      1,
      7,
      NULL,
      6.103435,
      4,
      2.307989,
      3,
      1.941616,
      NULL,
      1.445593,
      10,
      2,
      2.035097,
      NULL,
      18,
      37,
      4,
      NULL,
      0,
      NULL,
      '02311',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      4.438047,
      NULL,
      '0314',
      '',
      0,
      19,
      94,
      1,
      NULL,
      15,
      6,
      32,
      0,
      0,
      NULL,
      NULL,
      0.123918,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.191506,
      0,
      1,
      0,
      1.893721,
      1.794906,
      1,
      1,
      1.691946,
      2.007700,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.163125,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908862,
      NULL,
      NULL,
      8.515331,
      1.698510,
      NULL,
      1,
      1.286025,
      NULL,
      NULL,
      NULL,
      0.713028,
      NULL,
      NULL,
      NULL,
      3.718708,
      NULL,
      0,
      1.828579,
      NULL,
      NULL,
      1.280837,
      NULL,
      NULL,
      0.310233,
      1.642925,
      0,
      3,
      0,
      1,
      2,
      0.481544,
      0.189755,
      1,
      0.218305,
      1.650618,
      1.298569,
      1,
      0.852306,
      2,
      17,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      NULL,
      4.796805,
      NULL,
      1.477708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.927620,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4.757746,
      1.775487,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.905827,
      1.066125,
      NULL,
      1.651140,
      2,
      1,
      NULL,
      NULL,
      1.068408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.593176,
      NULL,
      NULL,
      2,
      3.212524,
      NULL,
      1,
      NULL,
      NULL,
      1.127525,
      NULL,
      1,
      2.588263,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2.597284,
      3.552310,
      0.518507,
      1,
      1,
      NULL,
      1.967794,
      NULL,
      NULL,
      2.159525,
      0,
      4,
      2.470947,
      1,
      1,
      1,
      2.405633,
      0,
      1.723739,
      NULL,
      NULL,
      0.364793,
      NULL,
      NULL,
      3.907995,
      NULL,
      0,
      4,
      4.337299,
      4.451665,
      NULL,
      1,
      NULL,
      0,
      1.594143,
      0,
      1.319751,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.178547,
      NULL,
      NULL,
      0.059864,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.134834,
      1,
      0.990046,
      0,
      5.991209,
      NULL,
      2,
      1,
      9.201066,
      NULL,
      NULL,
      NULL,
      2.705708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.466060,
      NULL,
      3,
      0.906819,
      NULL,
      NULL,
      0.131931,
      NULL,
      NULL,
      NULL,
      2.265710,
      NULL,
      0,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      0.066094,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.373578,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.347499,
      NULL,
      1,
      NULL,
      0,
      1.075006,
      NULL,
      NULL,
      1,
      0,
      1.692957,
      NULL,
      0,
      0.664508,
      3.506125,
      NULL,
      0.959059,
      1,
      2.329229,
      NULL,
      2.404736,
      1.880583,
      NULL,
      NULL,
      3.183552,
      NULL,
      13,
      NULL,
      7,
      2.122251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      13.061168,
      NULL,
      1.533895,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.392970,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10.492182,
      NULL,
      0,
      1.113271,
      1,
      1,
      1.460145,
      0.203150,
      NULL,
      2.621750,
      0.037841,
      2,
      1,
      0,
      1.198128,
      0.546954,
      0.720807,
      NULL,
      1,
      1.997007,
      NULL,
      0.469701,
      NULL,
      0.706642,
      NULL,
      0.623200,
      NULL,
      3.057718,
      NULL,
      NULL,
      NULL,
      0.974773,
      NULL,
      NULL,
      NULL,
      3.537056,
      0.129410,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.113614,
      NULL,
      1,
      NULL,
      1.933682,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.803753,
      NULL,
      1,
      NULL,
      1.886868,
      NULL,
      1.707383,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      NULL,
      3.837346,
      0,
      NULL,
      2,
      3.957156,
      0.319518,
      0,
      NULL,
      0.879741,
      NULL,
      NULL,
      1.083223,
      NULL,
      NULL,
      NULL,
      0.988556,
      1.721766,
      2,
      0,
      1.306450,
      2.525418,
      2,
      0.443935,
      1,
      1,
      0.940506,
      1.546469,
      1,
      1.608943,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      3,
      1.081291,
      NULL,
      0.540640,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684188,
      1.485985,
      1,
      0,
      0.696218,
      1.201936,
      3,
      4,
      NULL,
      0.468524,
      NULL,
      NULL,
      95,
      90,
      2,
      0,
      0,
      NULL,
      '02322',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '4110',
      NULL,
      '');
commit;
end;
/


