set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3140111',
      2,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0.688597,
      NULL,
      NULL,
      ' 4-29-1984',
      26,
      NULL,
      1,
      NULL,
      1.370286,
      NULL,
      40,
      1,
      311.581164,
      90.354035,
      1,
      NULL,
      ' 7-15-1997',
      ' 1- 6-1983',
      0,
      0,
      1.171000,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.993170,
      NULL,
      NULL,
      6.771528,
      3,
      18.667599,
      2,
      1,
      3.779907,
      NULL,
      2,
      1,
      1,
      1.915233,
      1,
      0.856131,
      1,
      1,
      1,
      0.188257,
      2,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      5,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1.389947,
      0,
      0,
      1,
      NULL,
      1.769316,
      NULL,
      1.062723,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2,
      1,
      4,
      NULL,
      2,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      4.701965,
      3.269382,
      0,
      2,
      2.514011,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      2.521355,
      0.840548,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      1,
      0,
      NULL,
      1,
      3,
      0,
      3,
      2,
      3,
      3,
      1,
      3,
      1,
      0.937671,
      0.540417,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.881974,
      0,
      1.207042,
      0,
      1,
      2.958960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      49,
      77,
      NULL,
      1.213697,
      2,
      '44203',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.659697,
      27.336988,
      57,
      0.950720,
      NULL,
      36,
      3,
      38.438876,
      2,
      1.489626,
      NULL,
      NULL,
      0.424706,
      NULL,
      NULL,
      0.079777,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.312967,
      1.806003,
      0.865374,
      2,
      2.725776,
      0,
      0.979596,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.121264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.293330,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.448717,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.255247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572568,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.812533,
      6,
      0,
      3.099137,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231771,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      1.718300,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3.358169,
      2.022266,
      1.652190,
      1,
      3.156068,
      2,
      5.892328,
      3.926089,
      1,
      NULL,
      NULL,
      NULL,
      1.828355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949659,
      NULL,
      NULL,
      1.165577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.067039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.040406,
      NULL,
      NULL,
      NULL,
      3,
      0.393968,
      NULL,
      3.396893,
      1,
      3.864418,
      3.956337,
      NULL,
      5,
      9.382435,
      2.382962,
      NULL,
      0,
      0,
      0.070040,
      NULL,
      NULL,
      NULL,
      0.935662,
      3.283692,
      NULL,
      2,
      3,
      10,
      11,
      0.512197,
      5,
      6,
      1,
      0,
      NULL,
      0,
      0.122198,
      1.607972,
      3,
      1.536106,
      1,
      0,
      NULL,
      NULL,
      2.259860,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.713715,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.246858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.735157,
      NULL,
      NULL,
      0.145744,
      NULL,
      NULL,
      1.969114,
      NULL,
      NULL,
      4.988251,
      NULL,
      NULL,
      1,
      1.145215,
      1.147066,
      0.593346,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034019,
      1,
      NULL,
      NULL,
      0.481706,
      1.132411,
      NULL,
      NULL,
      3.537600,
      1,
      NULL,
      NULL,
      0.343974,
      1,
      NULL,
      NULL,
      1.900855,
      3.863717,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.214931,
      NULL,
      NULL,
      0,
      2.559639,
      NULL,
      NULL,
      1.086485,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.327897,
      NULL,
      NULL,
      NULL,
      3.997234,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445562,
      NULL,
      NULL,
      3.717671,
      1767,
      NULL,
      NULL,
      1614.625201,
      NULL,
      1,
      NULL,
      NULL,
      1.200967,
      NULL,
      0,
      172.789628,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.788371,
      0,
      1,
      0,
      1.766940,
      NULL,
      1.338189,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      8,
      0,
      2.807864,
      NULL,
      1,
      NULL,
      3.456396,
      1,
      3,
      1,
      1.200729,
      0,
      1,
      0.634539,
      1,
      1.592889,
      1.459908,
      0,
      1.805471,
      0.026143,
      0,
      1,
      1.125676,
      0,
      1,
      0.215084,
      2.516347,
      0.218353,
      1.590706,
      0,
      NULL,
      1.631636,
      1,
      NULL,
      1,
      0.247060,
      1,
      0,
      0.097205,
      NULL,
      0,
      1,
      2,
      3.532637,
      0.314837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460010,
      1,
      0.037413,
      1,
      0.726691,
      1,
      2,
      NULL,
      7,
      1,
      NULL,
      NULL,
      47,
      NULL,
      1,
      1.510287,
      1,
      '03431',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      NULL);
commit;
end;
/


