set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '3330041',
      NULL,
      1.286153,
      4,
      2,
      '2144',
      2,
      0,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      4,
      NULL,
      3.411860,
      NULL,
      33.792789,
      3.447712,
      54,
      93.208834,
      NULL,
      '10- 0-1994',
      ' 7-16-1993',
      NULL,
      3.965946,
      3,
      2.085678,
      3,
      1.999831,
      1.611674,
      3,
      1.456365,
      NULL,
      NULL,
      NULL,
      2.207122,
      2,
      NULL,
      33,
      3,
      13,
      0,
      3,
      7.061682,
      1.947037,
      3,
      0,
      NULL,
      0.430462,
      1,
      NULL,
      NULL,
      1.899603,
      0.665299,
      0.374890,
      3,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      2,
      1,
      NULL,
      1.830319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.676942,
      1.682869,
      1.728832,
      NULL,
      1.841431,
      NULL,
      1,
      0,
      1.680547,
      0.612739,
      1,
      0.208581,
      NULL,
      0,
      NULL,
      1.805723,
      2.028174,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1.852143,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.307790,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      1,
      0,
      0,
      5,
      5,
      1,
      NULL,
      1,
      1.588686,
      0.429291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.037581,
      NULL,
      1,
      NULL,
      0.770274,
      1.724291,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.439096,
      0.375470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1.287034,
      0.292676,
      1,
      9,
      3,
      1.158341,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      3,
      3,
      0,
      2,
      2,
      3,
      0,
      NULL,
      2,
      0,
      1,
      0.589450,
      1.628460,
      0,
      NULL,
      NULL,
      NULL,
      1.656159,
      1,
      1.850477,
      1.234484,
      0,
      1.933849,
      0,
      1.407003,
      0,
      0,
      5.045497,
      0,
      11,
      4.591911,
      3,
      2.573833,
      5.567624,
      NULL,
      4.023391,
      2,
      7.490378,
      2,
      2.065936,
      2,
      46,
      0,
      3.405950,
      NULL,
      48,
      32,
      1.194461,
      3,
      NULL,
      1,
      '22141',
      '42100',
      '',
      NULL,
      '',
      '',
      '',
      0.542861,
      '4214',
      NULL,
      '',
      2,
      19,
      NULL,
      0.155214,
      0,
      10,
      2.132467,
      40.231064,
      2,
      0.584616,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.498380,
      NULL,
      NULL,
      NULL,
      1.840506,
      NULL,
      NULL,
      0,
      1.701894,
      NULL,
      2,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2.647156,
      3.408981,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11,
      7.445056,
      NULL,
      1,
      1.355180,
      NULL,
      NULL,
      NULL,
      1.119007,
      NULL,
      NULL,
      NULL,
      2,
      0.200429,
      2.312012,
      1,
      NULL,
      NULL,
      0.021372,
      NULL,
      NULL,
      3,
      3,
      NULL,
      2,
      1.274307,
      0.876922,
      NULL,
      NULL,
      1,
      1.763925,
      0,
      1.991238,
      NULL,
      NULL,
      1,
      1.489990,
      0,
      NULL,
      NULL,
      1.041435,
      NULL,
      NULL,
      2.064144,
      2.812569,
      1.956710,
      5.931880,
      5.739965,
      4.940765,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.200984,
      NULL,
      NULL,
      NULL,
      0.229469,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.927906,
      2,
      0.512621,
      NULL,
      NULL,
      0,
      4,
      0.264098,
      1.613254,
      2,
      2,
      0.788388,
      0,
      NULL,
      4.194242,
      6,
      NULL,
      0.631328,
      NULL,
      NULL,
      1.850429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094803,
      0,
      1.631121,
      0,
      NULL,
      NULL,
      7.257839,
      1,
      0,
      NULL,
      2,
      4,
      1,
      NULL,
      NULL,
      2.863699,
      NULL,
      0,
      1,
      3.766740,
      3,
      3,
      1.488680,
      0,
      5.337445,
      3,
      NULL,
      3.919236,
      2.878188,
      2.260410,
      0,
      NULL,
      NULL,
      2.224933,
      0,
      1,
      0.482305,
      0.003735,
      NULL,
      4,
      7.181570,
      4.666254,
      6.386509,
      5.118745,
      2,
      3,
      NULL,
      NULL,
      0,
      1,
      0.857535,
      NULL,
      0,
      3.778232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110951,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.135504,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      12.343486,
      NULL,
      NULL,
      1.383672,
      0,
      1,
      0.356478,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.927822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.888205,
      NULL,
      NULL,
      NULL,
      1.726455,
      1.735208,
      NULL,
      NULL,
      0,
      1.962138,
      NULL,
      NULL,
      1.040943,
      1.809102,
      NULL,
      NULL,
      0.314135,
      2.015639,
      NULL,
      NULL,
      3.857293,
      1,
      NULL,
      NULL,
      1.418608,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.587444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107061,
      2.424068,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.192244,
      6.918563,
      13,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571735,
      NULL,
      NULL,
      1.777621,
      NULL,
      0.369037,
      1378.553593,
      NULL,
      1.435813,
      NULL,
      1.591113,
      0,
      1.666421,
      0.195023,
      NULL,
      0,
      2,
      1.497483,
      2.365023,
      1.029182,
      0.497993,
      NULL,
      NULL,
      1,
      0.538749,
      1.486436,
      1,
      NULL,
      2.561022,
      NULL,
      1.647464,
      NULL,
      NULL,
      NULL,
      3.517653,
      NULL,
      8.789564,
      NULL,
      0.455107,
      NULL,
      2.737767,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.398354,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.832598,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.140743,
      NULL,
      1.859863,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      10,
      NULL,
      0.861949,
      0.023295,
      2,
      11,
      3.791805,
      3,
      2.396588,
      NULL,
      1.835628,
      1.126992,
      NULL,
      1,
      2,
      1,
      1,
      0,
      0.025497,
      0.400158,
      NULL,
      3.252005,
      2.323309,
      0,
      0,
      0.367418,
      1,
      0,
      1,
      0,
      1,
      NULL,
      2,
      0.519273,
      1.737086,
      1.180486,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      0.921372,
      1.668367,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132112,
      NULL,
      1.929193,
      0,
      1.783327,
      0,
      0,
      NULL,
      3,
      1.285971,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '24311',
      '03411',
      '',
      0.077935,
      '',
      '',
      '',
      5.352751,
      '0343',
      '3323',
      '');
commit;
end;
/


