set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7531456';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '0241304',
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 4- 5-1984',
      54.080669,
      NULL,
      5,
      2,
      0,
      ' 2- 9-1984',
      37,
      0.816231,
      276,
      140.175602,
      NULL,
      '10-18-1981',
      NULL,
      ' 3-20-1995',
      3.016075,
      1.296184,
      3,
      1.441970,
      1.959196,
      NULL,
      0,
      0,
      NULL,
      83,
      1,
      2.007149,
      4.322904,
      15,
      0,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      1,
      0,
      NULL,
      0.238533,
      1.950400,
      0,
      NULL,
      1.994828,
      NULL,
      24,
      1,
      4,
      5,
      0,
      3,
      0,
      1,
      1,
      1,
      4,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      4.797685,
      0,
      1,
      NULL,
      1,
      1.266243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.458220,
      1,
      0,
      1.980164,
      1.782113,
      1,
      NULL,
      0.714261,
      0.163224,
      1.939045,
      1,
      0,
      2,
      1.873985,
      1.254604,
      2,
      0,
      2,
      3.030456,
      0,
      2,
      NULL,
      0.678767,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      2,
      0,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.298207,
      1,
      5,
      NULL,
      NULL,
      0,
      NULL,
      5,
      2,
      3,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      4,
      4,
      3,
      1,
      2,
      1,
      0,
      2,
      3.254367,
      2,
      NULL,
      1053.108676,
      '11-29-1999',
      785,
      3.271286,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269134,
      2.158657,
      1.910063,
      4.720876,
      1,
      3.346628,
      NULL,
      0,
      NULL,
      NULL,
      0.892958,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455852,
      1,
      0,
      1,
      1,
      NULL,
      1.631040,
      0.018099,
      4300.399000,
      1.699367,
      1.741644,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      3,
      0,
      1,
      1,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      16.713365,
      2.416915,
      0,
      NULL,
      1.826119,
      0.018675,
      0,
      0.052883,
      1.655142,
      1,
      1,
      1.451064,
      0.768973,
      1,
      1.392896,
      NULL,
      NULL,
      4.594601,
      5.792509,
      3.205549,
      1.979949,
      0.649850,
      6.854351,
      2.454078,
      3.208337,
      6.268214,
      0.825008,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      13,
      39,
      37.706524,
      2,
      0,
      1.368022,
      '02012',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.655148,
      '0002',
      '0420',
      '0204',
      1.907987,
      NULL,
      NULL,
      10.766984,
      2.500521,
      30,
      0.008242,
      4.552429,
      NULL,
      0.787960,
      1.188629,
      3,
      0.735404,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.483703,
      NULL,
      NULL,
      2,
      1.159990,
      0,
      0,
      NULL,
      NULL,
      1.775004,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.134721,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.035273,
      NULL,
      2,
      NULL,
      0.853860,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.751218,
      1.811253,
      3,
      1.410975,
      NULL,
      NULL,
      1.871546,
      NULL,
      NULL,
      1.758587,
      0.089967,
      NULL,
      3.652582,
      0.624131,
      1,
      3,
      2.598740,
      0.344990,
      3.043439,
      1,
      2.809503,
      1,
      3,
      1,
      NULL,
      3.488029,
      NULL,
      0.129129,
      1.378723,
      NULL,
      NULL,
      0.818506,
      NULL,
      NULL,
      5.791007,
      7,
      1.875300,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.342026,
      1,
      NULL,
      3,
      1,
      0.058882,
      NULL,
      NULL,
      2,
      1.250442,
      1.774325,
      0.597958,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110959,
      NULL,
      NULL,
      1.410898,
      NULL,
      NULL,
      3.808588,
      1.131215,
      NULL,
      3.397211,
      3.886556,
      3,
      2,
      NULL,
      4,
      8.866623,
      4,
      3,
      1,
      3.501925,
      1,
      2.433522,
      NULL,
      3,
      0,
      0.328898,
      1.197298,
      1.453107,
      3.507694,
      NULL,
      3.152665,
      3,
      NULL,
      3,
      3,
      NULL,
      0.269468,
      2,
      1,
      1,
      2.899639,
      2,
      3.211004,
      1,
      0,
      NULL,
      4,
      2.374720,
      NULL,
      6.563204,
      7.409439,
      NULL,
      0,
      1,
      0.988908,
      1.963727,
      NULL,
      1,
      0,
      1.367593,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654323,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.985803,
      NULL,
      NULL,
      1.703495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.317851,
      1.345286,
      0.261857,
      0,
      0,
      1.250421,
      1.902106,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.348306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646696,
      NULL,
      NULL,
      NULL,
      1.987965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      2,
      5.238220,
      1,
      6,
      1.400921,
      222,
      69,
      1.085662,
      NULL,
      NULL,
      0.889676,
      NULL,
      NULL,
      NULL,
      36,
      14.398434,
      1.769087,
      NULL,
      NULL,
      0.712120,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      35,
      NULL,
      1.061289,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.172017,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0.103652,
      1.021037,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      2.319983,
      5,
      NULL,
      14,
      NULL,
      1.083332,
      1.498848,
      1.711598,
      0,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.213402,
      NULL,
      2.501880,
      NULL,
      NULL,
      1.956395,
      0.314852,
      NULL,
      1,
      1,
      NULL,
      2.230516,
      1.351946,
      NULL,
      0,
      3.159116,
      NULL,
      3.087975,
      0.012024,
      NULL,
      NULL,
      0,
      NULL,
      2.021587,
      1.756431,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946346,
      1,
      NULL,
      0.728659,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.024013,
      NULL,
      2.128352,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      15,
      1,
      NULL,
      0,
      NULL,
      1.556310,
      NULL,
      NULL,
      0,
      5,
      1.415226,
      1.797880,
      2,
      52.943133,
      52.426939,
      NULL,
      1.729221,
      NULL,
      '12402',
      '',
      '',
      3.326249,
      '33002',
      '',
      NULL,
      0,
      '2344',
      NULL,
      '3113');
commit;
end;
/


