set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9851628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7,
      2.110796,
      2,
      NULL,
      1.126941,
      1,
      2,
      3.185937,
      NULL,
      '03431314',
      17,
      NULL,
      '4312401',
      NULL,
      0,
      1,
      2,
      '2301',
      4,
      1.303502,
      NULL,
      NULL,
      ' 9-29-1994',
      92.975926,
      NULL,
      NULL,
      1.175592,
      3.213909,
      ' 0-29-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '10- 9-1978',
      '10-11-1991',
      ' 7-18-1991',
      1.725254,
      0.974892,
      2.144665,
      0.090574,
      1.963954,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      0.848422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      3,
      4,
      NULL,
      NULL,
      0,
      0,
      2,
      5,
      NULL,
      2,
      0,
      2,
      1,
      NULL,
      0,
      0,
      2,
      2,
      1.317301,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      4,
      3.619756,
      2.197876,
      NULL,
      NULL,
      0.417419,
      0,
      3,
      0.020218,
      3.696611,
      3,
      1,
      0,
      1,
      NULL,
      2.003948,
      3,
      0,
      NULL,
      3,
      3,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.055324,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      5.385390,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.348994,
      0,
      2,
      4,
      3,
      0,
      1,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      3,
      2,
      4,
      1,
      2,
      2,
      NULL,
      2,
      NULL,
      3,
      3,
      4,
      4.559965,
      3.418947,
      ' 4-27-1986',
      443.785581,
      ' 4-24-1994',
      26,
      3.963618,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.474058,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509651,
      4,
      0.924875,
      4.174477,
      1.157175,
      2,
      NULL,
      1.411152,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.985385,
      1.033292,
      1.724289,
      0.836049,
      0,
      1,
      1,
      17,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      1.623963,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      1.674462,
      0.169299,
      0,
      0.289140,
      0,
      0,
      0,
      1,
      2,
      0.172419,
      10,
      10,
      6,
      9,
      4,
      7.956383,
      4,
      3.841599,
      1.734065,
      2,
      NULL,
      1.140245,
      NULL,
      3,
      1.091694,
      NULL,
      NULL,
      NULL,
      27,
      4,
      2,
      4,
      '00024',
      '03321',
      '',
      1,
      '',
      '',
      '',
      0.691266,
      '',
      NULL,
      '',
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      28.173083,
      0.505568,
      0,
      0,
      3.516224,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.396888,
      NULL,
      NULL,
      NULL,
      2.907835,
      3,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.374374,
      0.314013,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.271540,
      NULL,
      NULL,
      1.726946,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      4,
      0,
      0.070086,
      NULL,
      NULL,
      NULL,
      1.462245,
      NULL,
      NULL,
      NULL,
      3.110574,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.399088,
      NULL,
      0.856450,
      2,
      3.315296,
      0.787545,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.783759,
      1,
      NULL,
      1,
      NULL,
      1.719786,
      NULL,
      NULL,
      0.286466,
      NULL,
      NULL,
      0.377265,
      0,
      0.720921,
      5.030270,
      0.356541,
      0.017146,
      0,
      0.593220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555484,
      NULL,
      NULL,
      1.682096,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.782684,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.264438,
      NULL,
      NULL,
      1.338575,
      NULL,
      NULL,
      1.683651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.922744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.254393,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.583140,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.943503,
      2.031233,
      2,
      1,
      1.035168,
      1,
      1.591097,
      NULL,
      NULL,
      3.849784,
      1,
      1,
      0,
      0,
      0,
      1,
      3,
      0.708712,
      0,
      NULL,
      NULL,
      1,
      2.639646,
      NULL,
      2.553190,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.654074,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.598235,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.953027,
      NULL,
      NULL,
      1.108229,
      NULL,
      1.402151,
      NULL,
      NULL,
      1.694938,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      NULL,
      NULL,
      2.281327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260761,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.230240,
      NULL,
      NULL,
      NULL,
      2.961388,
      NULL,
      NULL,
      NULL,
      7.120292,
      NULL,
      NULL,
      NULL,
      1.651650,
      0.157349,
      0,
      0,
      0,
      1,
      1.516184,
      0.110116,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.286857,
      NULL,
      NULL,
      0.028647,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.233207,
      NULL,
      NULL,
      1.924178,
      NULL,
      1,
      3,
      1,
      NULL,
      1.378601,
      1,
      1,
      0.861245,
      0.888052,
      1.464891,
      0.052913,
      0.809510,
      0.836452,
      NULL,
      0.481239,
      0.662399,
      1,
      0.533772,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.625459,
      NULL,
      0,
      NULL,
      3.124598,
      NULL,
      NULL,
      NULL,
      0,
      16.496141,
      49,
      1,
      1.342031,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.067166,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397886,
      0,
      0.647553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.798167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.912208,
      NULL,
      0.962863,
      NULL,
      NULL,
      NULL,
      1.678034,
      NULL,
      1.018268,
      NULL,
      0.554065,
      0,
      0.087515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      5,
      2.462766,
      0,
      0,
      2,
      6,
      3,
      0,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0.217445,
      0.473860,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.428962,
      NULL,
      1.276532,
      1,
      NULL,
      3,
      1.937478,
      NULL,
      1.504894,
      1.516921,
      NULL,
      0,
      0.057107,
      NULL,
      NULL,
      3,
      NULL,
      0.627491,
      NULL,
      NULL,
      NULL,
      0.911026,
      1.595459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622509,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      4,
      2,
      1,
      NULL,
      NULL,
      69.850520,
      NULL,
      3,
      NULL,
      2.159545,
      '34342',
      '13443',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


