set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      0.774498,
      0,
      5,
      1,
      '3042',
      3.704681,
      0.505083,
      NULL,
      NULL,
      ' 2-11-1983',
      NULL,
      NULL,
      1,
      1.265342,
      0,
      ' 1-23-1993',
      22.398205,
      1,
      NULL,
      81,
      2,
      NULL,
      ' 5-23-1992',
      NULL,
      2.852865,
      NULL,
      0.891076,
      0,
      0,
      NULL,
      3,
      0,
      1.128926,
      NULL,
      6,
      7.613748,
      6.709171,
      2.958977,
      NULL,
      3,
      NULL,
      NULL,
      0,
      5.932103,
      0.005929,
      3,
      1,
      1,
      NULL,
      0,
      1,
      2,
      1.681859,
      1,
      1.538824,
      3,
      1,
      1,
      1.756649,
      NULL,
      NULL,
      1,
      4,
      0,
      5,
      4,
      4,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.674163,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      1.443655,
      1.382529,
      2,
      1,
      1,
      0.699187,
      1,
      NULL,
      1,
      1.337468,
      0,
      1,
      0,
      NULL,
      0.426800,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0.787808,
      1.111477,
      NULL,
      NULL,
      1.328059,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      5,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1.921280,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      6,
      0,
      2,
      4,
      5,
      1,
      2,
      3,
      1,
      0,
      5,
      5,
      NULL,
      1,
      5,
      NULL,
      NULL,
      1,
      3,
      5,
      1,
      2,
      0,
      2,
      1,
      1,
      5,
      0.434444,
      ' 4-27-1980',
      13,
      ' 7-26-2001',
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      5,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      1.139921,
      2.848361,
      1,
      1,
      6.020014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      3,
      3.244464,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.345319,
      1.156385,
      NULL,
      1.940477,
      NULL,
      99,
      0.620904,
      1.022325,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.736864,
      2,
      2,
      1,
      2,
      3,
      0,
      NULL,
      3,
      0,
      3,
      NULL,
      4,
      6,
      1.212539,
      1,
      0,
      NULL,
      0.822740,
      1,
      0.007119,
      NULL,
      0,
      0.980211,
      0.333973,
      1.669149,
      0,
      1,
      1,
      1,
      3,
      4.309525,
      6.503192,
      4,
      8.308245,
      0,
      NULL,
      3.943912,
      0,
      2.525129,
      3.730587,
      0,
      41,
      0,
      2,
      NULL,
      34,
      NULL,
      42,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '1411',
      '',
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      14,
      NULL,
      2.468033,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.200545,
      0,
      2.633265,
      1.225592,
      1.476543,
      1,
      NULL,
      NULL,
      0,
      2.507030,
      3.520308,
      0,
      NULL,
      0,
      1.438322,
      1.335587,
      2.669283,
      0,
      0.204105,
      1,
      NULL,
      NULL,
      NULL,
      1.849172,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7.466867,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393693,
      NULL,
      NULL,
      NULL,
      2,
      2.741601,
      0.452433,
      0,
      NULL,
      NULL,
      1.100245,
      NULL,
      NULL,
      2.301356,
      NULL,
      NULL,
      3,
      0.016893,
      0,
      2,
      1,
      1.158765,
      NULL,
      1,
      1.401942,
      3.535466,
      0,
      0.628418,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.026166,
      NULL,
      NULL,
      0.660469,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.712359,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.243934,
      NULL,
      0.023805,
      1,
      0.876532,
      NULL,
      NULL,
      0.711570,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      1,
      1.521583,
      NULL,
      NULL,
      6.440364,
      2,
      1.951583,
      1,
      NULL,
      NULL,
      1.922745,
      NULL,
      NULL,
      1.006192,
      NULL,
      NULL,
      0.151507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789999,
      NULL,
      NULL,
      3,
      1,
      1.506869,
      1,
      0.175761,
      0.004985,
      NULL,
      NULL,
      7.039287,
      4,
      5.539468,
      2,
      2.071300,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.834923,
      3.271884,
      3.695977,
      2,
      2,
      0.774486,
      7.392948,
      NULL,
      6.831081,
      NULL,
      2,
      3.869379,
      0.214950,
      3,
      0.689938,
      1.885903,
      NULL,
      2.353638,
      NULL,
      2,
      0.506078,
      9,
      NULL,
      2,
      2.176586,
      NULL,
      3.825376,
      1,
      1,
      0,
      1,
      0.912072,
      1,
      NULL,
      1.151824,
      1.928338,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.238976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057460,
      NULL,
      NULL,
      0.112547,
      NULL,
      NULL,
      3.007141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452983,
      NULL,
      2.951607,
      1.630828,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.244048,
      NULL,
      NULL,
      NULL,
      0.079766,
      NULL,
      NULL,
      NULL,
      4.110464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.306181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.422168,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      8.615320,
      NULL,
      NULL,
      NULL,
      1.913937,
      NULL,
      NULL,
      NULL,
      16.277792,
      NULL,
      NULL,
      NULL,
      1.239410,
      NULL,
      NULL,
      NULL,
      4.877839,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      1.323203,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.555445,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.235953,
      NULL,
      NULL,
      0.431399,
      NULL,
      1.747174,
      15,
      NULL,
      NULL,
      2.208773,
      1,
      1.667379,
      1.587541,
      1,
      1.040498,
      0,
      1.469581,
      1.778183,
      1.076539,
      1.220590,
      1,
      1.184316,
      0.514355,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      7,
      6.321774,
      0.767297,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.112839,
      0.356447,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.939941,
      NULL,
      1,
      0.400766,
      NULL,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.708998,
      1,
      NULL,
      0,
      0,
      NULL,
      1.358107,
      1.069098,
      NULL,
      NULL,
      0,
      NULL,
      3.953676,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      6,
      NULL,
      1.444884,
      1.308556,
      1.034875,
      31,
      29.324181,
      0,
      NULL,
      3,
      '30213',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2,
      '4232',
      '',
      '');
commit;
end;
/


