set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919196';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1983-8-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '3322220',
      2.488815,
      0,
      0,
      2,
      '3034',
      NULL,
      0.551521,
      NULL,
      NULL,
      '10-15-2000',
      23,
      NULL,
      2,
      0,
      0,
      ' 0-11-1997',
      17,
      0,
      325,
      3.739534,
      3,
      ' 6-21-2003',
      ' 2-10-2003',
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.132201,
      2.474411,
      1,
      NULL,
      1.457131,
      25,
      2,
      NULL,
      1,
      20.833606,
      24.122658,
      3,
      16,
      0,
      5,
      5.682419,
      0.778589,
      0,
      0,
      1.658010,
      0.444820,
      1.497068,
      0.408059,
      0.131675,
      1.762492,
      0,
      1,
      NULL,
      3,
      5,
      0.526671,
      0,
      0,
      0,
      0,
      2,
      1,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      1.208750,
      NULL,
      NULL,
      1.570397,
      NULL,
      NULL,
      5,
      1,
      5,
      NULL,
      1,
      1.763217,
      0.201186,
      2.571483,
      2,
      0.029420,
      1.042056,
      3.150069,
      1.519081,
      3,
      0.462375,
      0,
      3.301393,
      2,
      2,
      2,
      1,
      1,
      0.664154,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1.582654,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      3,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1.859501,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      4,
      NULL,
      2,
      4,
      0,
      2,
      1,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      2,
      ' 6-13-1988',
      159.502923,
      ' 1-26-1974',
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.138526,
      NULL,
      1.952995,
      4.039519,
      1.396818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.571576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267886,
      1,
      1,
      0,
      0,
      1.332816,
      1.546944,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.256819,
      1,
      NULL,
      2,
      1,
      0,
      1,
      1,
      0,
      1,
      2,
      NULL,
      1.721294,
      NULL,
      2,
      0,
      1,
      1.661968,
      0.124663,
      0,
      0.598163,
      NULL,
      0,
      1,
      1,
      0.309272,
      NULL,
      0,
      1.999012,
      1,
      NULL,
      2,
      8.239176,
      1.289395,
      0,
      6,
      7.749312,
      NULL,
      0,
      3,
      2,
      NULL,
      0.652153,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      3,
      1.786351,
      NULL,
      NULL,
      '24302',
      '',
      0,
      '',
      '',
      '',
      0.396677,
      '',
      '',
      '',
      NULL,
      24.507136,
      19,
      17.795430,
      3,
      12,
      NULL,
      2.100918,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.775303,
      1.385018,
      NULL,
      NULL,
      NULL,
      0.387047,
      NULL,
      NULL,
      NULL,
      3,
      3.861037,
      0.526930,
      NULL,
      NULL,
      NULL,
      3.479074,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.036800,
      NULL,
      NULL,
      8.191925,
      7,
      4.868281,
      NULL,
      1.354260,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.011339,
      NULL,
      0.941803,
      0.652860,
      3,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      0.597248,
      NULL,
      1,
      2.673588,
      2,
      2,
      1,
      1.862916,
      0,
      0,
      1.868041,
      2.445683,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.355034,
      3,
      NULL,
      8,
      8,
      7,
      3,
      1.639949,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.835916,
      NULL,
      NULL,
      1.800145,
      NULL,
      NULL,
      1.433306,
      2.957831,
      1,
      0,
      NULL,
      NULL,
      4.251921,
      3,
      1.786634,
      0.196993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511477,
      NULL,
      0.550354,
      1,
      NULL,
      NULL,
      0,
      2.668464,
      0.216271,
      3.572021,
      3,
      NULL,
      2.566904,
      NULL,
      4.577339,
      1,
      NULL,
      NULL,
      2.096177,
      2.419730,
      2,
      1,
      0,
      1.186113,
      7.676291,
      5.604814,
      0.732542,
      1,
      0,
      NULL,
      1.680669,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.084921,
      1,
      5.865659,
      5,
      3,
      2,
      NULL,
      4,
      0.966156,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0.950177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.591221,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      1.372924,
      1,
      0,
      NULL,
      0,
      1.205000,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.368193,
      NULL,
      NULL,
      NULL,
      3.412346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.575160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421322,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.972632,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.992530,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.282121,
      0.350490,
      1.384149,
      2,
      19.717183,
      3.773412,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.269308,
      42.317934,
      6.710770,
      1.858277,
      0,
      NULL,
      0.082399,
      1,
      0,
      0.533529,
      0,
      1,
      2.733042,
      1.982259,
      0.395716,
      1.515998,
      1,
      1.357450,
      1.960380,
      0,
      3.786003,
      NULL,
      1.993403,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.441439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.193645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.079362,
      2.368995,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.811409,
      NULL,
      0.825269,
      NULL,
      0.592597,
      NULL,
      1.981310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.500896,
      NULL,
      1.905657,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.558607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.817045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278543,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      197.381589,
      NULL,
      1,
      NULL,
      1.045370,
      NULL,
      1,
      NULL,
      2,
      28.108677,
      12.118978,
      1.784274,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.509832,
      0,
      1,
      4,
      0,
      5,
      1.693633,
      NULL,
      0.765542,
      0,
      1.170893,
      NULL,
      1.012249,
      0.898281,
      NULL,
      0.982003,
      1,
      NULL,
      1,
      1.682540,
      NULL,
      0,
      0.733181,
      NULL,
      NULL,
      0,
      NULL,
      0.994720,
      1,
      NULL,
      1.071603,
      0.619676,
      NULL,
      0.247026,
      0,
      NULL,
      1,
      0.790385,
      NULL,
      0,
      0.113686,
      NULL,
      1.228978,
      0.073017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438966,
      NULL,
      1,
      NULL,
      0.788962,
      NULL,
      NULL,
      NULL,
      3,
      0.669360,
      NULL,
      NULL,
      52,
      97.417380,
      1,
      NULL,
      0.092255,
      '01241',
      '44431',
      '',
      NULL,
      '',
      '',
      '',
      1.676002,
      NULL,
      NULL,
      '');
commit;
end;
/


