set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919196';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '1311220',
      3.403426,
      0.917246,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 4-20-1994',
      29.218092,
      NULL,
      NULL,
      NULL,
      1,
      ' 2- 8-1987',
      NULL,
      NULL,
      124.316432,
      104,
      1,
      ' 1-12-1998',
      ' 4-23-1983',
      ' 9-11-1976',
      1,
      0,
      NULL,
      NULL,
      1.148051,
      2,
      1,
      1,
      NULL,
      9.664281,
      2,
      4,
      3,
      7.156136,
      7.252978,
      NULL,
      22,
      NULL,
      2,
      0.855831,
      1,
      2,
      0,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0.110235,
      1.476132,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      5,
      0,
      NULL,
      2,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.021848,
      NULL,
      NULL,
      4,
      NULL,
      1.758880,
      NULL,
      NULL,
      1.718711,
      NULL,
      0,
      2,
      1,
      NULL,
      3,
      NULL,
      0.075991,
      1,
      1,
      0,
      0,
      1.222607,
      1,
      0,
      NULL,
      0.206916,
      1,
      2,
      1,
      0.354885,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      0,
      0,
      1,
      NULL,
      3,
      0,
      3.797697,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      3,
      2,
      3,
      4,
      1,
      5,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      2,
      0,
      4,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0,
      5,
      NULL,
      2.989354,
      ' 8-23-2002',
      NULL,
      ' 1-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      4,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.203694,
      0.601761,
      1,
      2.843755,
      4,
      NULL,
      1,
      1,
      1.545010,
      1,
      1,
      8.512926,
      0,
      NULL,
      4.538909,
      1.098861,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.321134,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      0.522984,
      33,
      2,
      1.536204,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      0,
      1,
      1,
      0,
      1,
      0,
      3,
      2,
      3,
      3.743014,
      1.435599,
      0.441071,
      3.182587,
      NULL,
      1,
      0,
      0.662186,
      1,
      1,
      1,
      0,
      1.262481,
      NULL,
      0,
      NULL,
      1.951676,
      2.157669,
      1.514139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85.666647,
      NULL,
      1.741418,
      1,
      '23043',
      '',
      NULL,
      0.095415,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      13.699514,
      31.106702,
      0,
      1,
      NULL,
      NULL,
      2.111096,
      3,
      NULL,
      NULL,
      NULL,
      0.865520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.585437,
      0,
      1.744391,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.752204,
      0.678785,
      NULL,
      NULL,
      2,
      3.463957,
      2,
      1.366829,
      NULL,
      NULL,
      1.626217,
      NULL,
      NULL,
      1.337514,
      NULL,
      NULL,
      3,
      8,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.359220,
      3.553906,
      0.425360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.884262,
      0,
      3.641942,
      3,
      3.260564,
      3.485090,
      NULL,
      3,
      NULL,
      3,
      1.645777,
      1.399610,
      0,
      NULL,
      1.518013,
      NULL,
      NULL,
      NULL,
      1.552100,
      NULL,
      NULL,
      1.858537,
      NULL,
      NULL,
      1.862747,
      9,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846610,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.948347,
      NULL,
      NULL,
      NULL,
      6.040616,
      1.187545,
      3,
      1.594229,
      NULL,
      0,
      NULL,
      NULL,
      5,
      5,
      NULL,
      3,
      3,
      3.263225,
      1.332415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.837612,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.829604,
      7,
      NULL,
      NULL,
      0,
      1,
      1.541071,
      NULL,
      NULL,
      NULL,
      4.814295,
      NULL,
      NULL,
      9.244198,
      1.875780,
      3.401409,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.135325,
      2,
      2,
      0.954657,
      5,
      8.080793,
      0.591574,
      1,
      3,
      2.919613,
      0,
      2.532506,
      1.607961,
      1.331522,
      2,
      1.483393,
      0.825012,
      0.892598,
      1.599155,
      1.697204,
      0,
      NULL,
      5.245263,
      1.988226,
      0.986177,
      0,
      NULL,
      NULL,
      1.510978,
      1.605743,
      0,
      1,
      0.359236,
      2.542247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.244280,
      NULL,
      NULL,
      0.055438,
      NULL,
      NULL,
      1.824694,
      NULL,
      NULL,
      1.432689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0,
      0.077894,
      NULL,
      1.084846,
      1,
      1,
      NULL,
      NULL,
      0.108592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.634021,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.908175,
      NULL,
      NULL,
      NULL,
      1.512682,
      NULL,
      NULL,
      NULL,
      2.698310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.484804,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.334488,
      17,
      2,
      0.332742,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.256000,
      0,
      0.055343,
      0.994414,
      NULL,
      2.816857,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      NULL,
      1.323870,
      0.955297,
      1,
      NULL,
      NULL,
      1,
      0.761927,
      0,
      NULL,
      1.857448,
      NULL,
      0,
      0.888004,
      0.893512,
      0.580046,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651284,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.919354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655313,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.874530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.821145,
      NULL,
      2,
      NULL,
      0.091128,
      NULL,
      NULL,
      NULL,
      0.571854,
      NULL,
      0,
      NULL,
      0,
      1.107899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1.840611,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.023870,
      NULL,
      NULL,
      0,
      1.891231,
      NULL,
      0.183634,
      1.827575,
      NULL,
      0,
      1.281125,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1.626287,
      0,
      NULL,
      0,
      1.381157,
      NULL,
      0.520151,
      1.671500,
      NULL,
      NULL,
      0,
      NULL,
      1.636735,
      0,
      0.225033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715750,
      NULL,
      1.695996,
      NULL,
      3,
      5,
      2,
      NULL,
      NULL,
      NULL,
      7,
      20.711492,
      1,
      1,
      2,
      '20132',
      '',
      '',
      1,
      '',
      '',
      '',
      0.079082,
      NULL,
      NULL,
      '');
commit;
end;
/


