set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919196';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '0011003',
      2,
      1,
      NULL,
      3,
      '1032',
      2.969397,
      1.607523,
      NULL,
      NULL,
      '11-20-1995',
      39,
      NULL,
      3,
      3,
      NULL,
      ' 6- 0-1979',
      21.057766,
      3.202587,
      125,
      41,
      0,
      ' 6-18-2001',
      ' 0-26-1978',
      '10- 0-1980',
      0,
      3,
      3,
      NULL,
      1.468901,
      3,
      1,
      1,
      1.103888,
      NULL,
      0,
      18,
      2,
      17.610194,
      12,
      4,
      16,
      4,
      1,
      4,
      NULL,
      0,
      NULL,
      0.869727,
      0.890630,
      1.467536,
      0.981354,
      1,
      NULL,
      1,
      0,
      NULL,
      3,
      5,
      NULL,
      0,
      1,
      1,
      4,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0.122492,
      NULL,
      NULL,
      1.647670,
      NULL,
      NULL,
      3,
      5,
      0,
      3.190898,
      1,
      NULL,
      0,
      1,
      2.616611,
      2,
      1,
      NULL,
      2.874920,
      2.071435,
      1,
      0,
      NULL,
      0.034522,
      2.619379,
      3,
      0,
      4,
      4.741911,
      2,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0.946777,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      1,
      4,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      5,
      NULL,
      2,
      1,
      2,
      2,
      3,
      1,
      4,
      1,
      2,
      1,
      2,
      NULL,
      ' 9-14-1981',
      NULL,
      ' 8- 3-1990',
      98.881895,
      1.204867,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.539771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.604947,
      1.778296,
      NULL,
      NULL,
      1,
      3.402322,
      1,
      NULL,
      2,
      0,
      1.517343,
      2.057117,
      3,
      2.539169,
      2,
      1,
      6.676590,
      6,
      1.640952,
      1,
      0.826801,
      NULL,
      NULL,
      NULL,
      1,
      9.814975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841204,
      1,
      NULL,
      1.038892,
      NULL,
      0,
      1.130017,
      2,
      28,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      2,
      2,
      1,
      2,
      1,
      NULL,
      0,
      3,
      3,
      1.120751,
      NULL,
      1,
      0,
      1.568384,
      0,
      1.351212,
      0.079618,
      1.878847,
      1,
      0.223699,
      0,
      1,
      0,
      0.919113,
      0,
      0.219413,
      0,
      NULL,
      0.629772,
      4.708937,
      5.041232,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      2.656747,
      0,
      3,
      0.226729,
      0,
      1.060848,
      NULL,
      68,
      91,
      0,
      NULL,
      0,
      4.496171,
      '31243',
      '13003',
      '',
      NULL,
      '',
      '',
      '',
      0.469594,
      '',
      '',
      '',
      2,
      7,
      NULL,
      1.515886,
      2.300875,
      1.827775,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.192501,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.175286,
      1.028715,
      0,
      0,
      2.700805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      2.941778,
      0,
      NULL,
      NULL,
      NULL,
      1.387984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.810250,
      NULL,
      2.603424,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107714,
      NULL,
      NULL,
      NULL,
      1.413504,
      0.207256,
      1,
      0,
      NULL,
      3,
      0,
      2.177077,
      1.818854,
      1.984809,
      2.512966,
      NULL,
      NULL,
      0,
      3,
      2,
      0.433227,
      3.347684,
      3.387491,
      1.322768,
      0.606444,
      1,
      NULL,
      1.111944,
      1,
      0,
      NULL,
      NULL,
      0.603332,
      NULL,
      NULL,
      2.068809,
      1,
      NULL,
      0.657726,
      1.934043,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.865697,
      0,
      0,
      1.371206,
      1,
      1.049189,
      NULL,
      NULL,
      0,
      1.829385,
      3.589925,
      0.726523,
      1,
      1.250758,
      1.847018,
      3,
      1.080645,
      NULL,
      NULL,
      NULL,
      1.542531,
      NULL,
      NULL,
      1.221509,
      NULL,
      NULL,
      4.733902,
      6.144453,
      1.069004,
      3.660930,
      2,
      1,
      1.588025,
      NULL,
      NULL,
      7.140056,
      NULL,
      0.541387,
      4.682020,
      3.898121,
      NULL,
      4.733771,
      5.571595,
      3.279826,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      1.574530,
      0.699257,
      3,
      2.182187,
      3.162122,
      5.017770,
      1,
      3,
      1,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      2,
      2.694796,
      3,
      9.525793,
      6,
      5,
      1,
      6,
      NULL,
      3.865216,
      2,
      0,
      0.409660,
      NULL,
      1.700135,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.829930,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.094993,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.824339,
      NULL,
      NULL,
      11.405171,
      NULL,
      NULL,
      0.077632,
      1.121420,
      0.511863,
      0,
      NULL,
      2,
      0.670588,
      NULL,
      NULL,
      2.149285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.102482,
      NULL,
      NULL,
      NULL,
      0.644103,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.475710,
      NULL,
      NULL,
      NULL,
      3.404210,
      NULL,
      NULL,
      NULL,
      0.571991,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.032093,
      NULL,
      NULL,
      NULL,
      3.970865,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.561937,
      NULL,
      NULL,
      NULL,
      1.945602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      13.349505,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.447478,
      0.764093,
      NULL,
      2,
      11,
      8,
      0,
      NULL,
      NULL,
      0.418268,
      NULL,
      0,
      165.543919,
      13.291217,
      NULL,
      0.523481,
      0,
      1,
      NULL,
      1.327438,
      0.884030,
      0.318391,
      NULL,
      1.753141,
      NULL,
      1,
      NULL,
      NULL,
      0.179704,
      0.905568,
      1,
      1.404567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.256104,
      NULL,
      NULL,
      NULL,
      0.568480,
      NULL,
      0.931736,
      NULL,
      0.452620,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792855,
      1,
      NULL,
      NULL,
      NULL,
      0.676829,
      NULL,
      NULL,
      NULL,
      0.335793,
      NULL,
      0.146484,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.795761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.818737,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.966765,
      0,
      3,
      22.506021,
      31.451586,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.571678,
      NULL,
      3.371834,
      2,
      3,
      NULL,
      1,
      0,
      0.774142,
      0.621823,
      NULL,
      1,
      NULL,
      NULL,
      1.745978,
      2.258817,
      NULL,
      1.168425,
      0.922924,
      NULL,
      NULL,
      1.272122,
      NULL,
      0,
      0.510491,
      NULL,
      0.152152,
      0.864607,
      NULL,
      0.609843,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.693510,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3.689951,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      0.794701,
      NULL,
      NULL,
      NULL,
      136,
      5,
      0,
      3,
      '11211',
      '43311',
      '',
      1.904106,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


