set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919196';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0,
      2,
      NULL,
      2,
      1.234494,
      3,
      NULL,
      '433',
      NULL,
      1,
      7,
      '3113214',
      3,
      NULL,
      0,
      2,
      '2134',
      NULL,
      1.658111,
      NULL,
      NULL,
      ' 8- 6-1991',
      19,
      174.620845,
      NULL,
      2,
      0.083709,
      ' 2-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0.617858,
      0,
      1,
      0.142219,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      8.064564,
      5.927523,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      5,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2,
      1.611940,
      3.100209,
      0,
      1,
      3.966938,
      2.273535,
      3.241531,
      NULL,
      1.701791,
      1,
      NULL,
      2,
      2.949560,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      2,
      3.134484,
      1.048102,
      NULL,
      NULL,
      0.310858,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      3,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1.192940,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      3,
      0,
      0,
      0,
      1,
      NULL,
      5,
      0,
      4,
      5,
      3,
      1,
      4,
      0,
      0,
      0,
      NULL,
      4,
      NULL,
      4.814009,
      0.572488,
      '11-19-1978',
      615,
      ' 5- 2-1976',
      1522,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408920,
      0.988039,
      4,
      1,
      0,
      1.663518,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.430135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.062443,
      NULL,
      1.429499,
      0.906990,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      3.673805,
      1.383528,
      2,
      2.367354,
      0,
      0.449018,
      1,
      1,
      0.420477,
      1.910861,
      0,
      1,
      1.849117,
      1,
      0.803892,
      0,
      0,
      2,
      1,
      10.134257,
      11.988082,
      NULL,
      0.816407,
      1,
      0,
      3,
      3,
      0.537352,
      1.752868,
      2,
      0,
      40.979492,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '01224',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      NULL,
      '',
      '',
      3.486557,
      25.761721,
      323.064273,
      18,
      NULL,
      34.555446,
      2.785240,
      18.957547,
      4,
      3.209455,
      0.414647,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      1.826208,
      NULL,
      NULL,
      1.788951,
      NULL,
      NULL,
      3.213737,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      0,
      0.963344,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      1.115831,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.639654,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      3,
      1,
      1,
      0.391660,
      NULL,
      3,
      1.470171,
      NULL,
      1,
      0.988680,
      1,
      3,
      1,
      1.533652,
      1,
      1,
      3.645544,
      0.494727,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      5,
      9.661525,
      NULL,
      1,
      0.004345,
      NULL,
      NULL,
      NULL,
      1.060986,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.845636,
      0.667543,
      1.566242,
      NULL,
      NULL,
      0,
      2.141735,
      0.091300,
      3,
      0,
      0,
      3.242274,
      0,
      0.133263,
      1,
      1.264560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1.015732,
      1,
      NULL,
      NULL,
      6.570883,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.170499,
      5.528003,
      0.592812,
      1.024911,
      NULL,
      NULL,
      1,
      NULL,
      3.524380,
      2,
      1,
      2,
      1,
      3.649840,
      1,
      NULL,
      2.537455,
      NULL,
      1.860339,
      0,
      2.259101,
      NULL,
      0,
      1.334145,
      3,
      1,
      NULL,
      4.617780,
      4.928820,
      0,
      NULL,
      1.778678,
      2.278712,
      1,
      0,
      2,
      0.396165,
      NULL,
      1.339342,
      1,
      0,
      1.668193,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.117673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.606397,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.529876,
      0.757642,
      0,
      1,
      NULL,
      NULL,
      1.847638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.003202,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.291984,
      NULL,
      NULL,
      NULL,
      2.219571,
      NULL,
      NULL,
      NULL,
      1.826897,
      NULL,
      NULL,
      NULL,
      0.779350,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.351528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626502,
      99.401112,
      35,
      1,
      NULL,
      12.321815,
      1.215388,
      NULL,
      NULL,
      0.069488,
      1,
      NULL,
      0.673091,
      1.110605,
      0.444705,
      1,
      122.720749,
      33,
      0.136783,
      NULL,
      1,
      10.034090,
      16.647371,
      NULL,
      3,
      0,
      0,
      1.209001,
      0.043287,
      0,
      3.142940,
      NULL,
      NULL,
      0.373141,
      NULL,
      1.144940,
      0.900723,
      1.756929,
      1,
      1.087361,
      3,
      NULL,
      NULL,
      NULL,
      1.066207,
      NULL,
      1.469260,
      NULL,
      0,
      NULL,
      2.786718,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      19.957206,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.490094,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.349685,
      NULL,
      NULL,
      NULL,
      0.755971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.738309,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.389420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.440698,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.415248,
      NULL,
      0,
      NULL,
      0.807322,
      0.199500,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982850,
      0.166838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.381208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.206290,
      NULL,
      3.419321,
      NULL,
      3.944215,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.067918,
      NULL,
      1,
      0,
      NULL,
      18.480509,
      NULL,
      1.137430,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.551957,
      0,
      0.272933,
      1.770060,
      2,
      2.696941,
      2,
      3.931842,
      0,
      1,
      1.398921,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1.807261,
      0.977570,
      NULL,
      1,
      0.898515,
      NULL,
      1.016952,
      NULL,
      NULL,
      1.844115,
      1,
      NULL,
      1.633725,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.932937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735476,
      NULL,
      1.859927,
      NULL,
      0.679863,
      NULL,
      NULL,
      1,
      7,
      0,
      NULL,
      NULL,
      NULL,
      80,
      5,
      1,
      NULL,
      '12040',
      '22203',
      '21230',
      0.891081,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '');
commit;
end;
/


