set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9685662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.045376,
      28.049332,
      '0214241',
      2,
      0,
      0,
      0,
      NULL,
      3.343547,
      0,
      NULL,
      NULL,
      ' 0- 1-1996',
      47,
      2,
      NULL,
      2,
      0,
      ' 7-15-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3-23-1998',
      NULL,
      ' 3- 2-1999',
      0,
      0.572678,
      2,
      1.096247,
      1,
      3.431713,
      3,
      0.003336,
      0,
      150.473270,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      2,
      NULL,
      0,
      0.258067,
      1,
      1.108521,
      0.035133,
      0.022993,
      0.115713,
      0,
      2,
      NULL,
      6,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      4,
      1,
      1,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.599259,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.094036,
      1.423619,
      0.116080,
      1.989263,
      2,
      NULL,
      NULL,
      NULL,
      1.678153,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.699562,
      2,
      0,
      0,
      6.963143,
      0,
      0,
      NULL,
      0.331579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      4,
      2.696974,
      2.745965,
      NULL,
      5,
      1,
      1,
      0,
      NULL,
      5,
      0,
      2,
      5,
      NULL,
      NULL,
      5,
      2,
      0,
      NULL,
      0,
      4,
      2,
      1,
      4,
      NULL,
      2,
      2,
      1,
      4.665736,
      3,
      NULL,
      NULL,
      ' 2-15-1999',
      369,
      3.956522,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210285,
      1,
      7,
      2.561718,
      0.708047,
      1.854671,
      1,
      NULL,
      NULL,
      NULL,
      1.467929,
      3,
      0.025669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.147544,
      NULL,
      1,
      0.617448,
      0.528823,
      1.668309,
      3.392846,
      29,
      1,
      1.211151,
      46.771736,
      27,
      2,
      3,
      NULL,
      1.313155,
      3,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      1.647879,
      4.203422,
      0.500014,
      0.701639,
      0,
      NULL,
      0.955628,
      0.075632,
      0.639051,
      NULL,
      0,
      1,
      0.935299,
      1,
      1,
      3.082268,
      0,
      8.038202,
      4.129227,
      2,
      4.483271,
      6,
      1.046646,
      1.260663,
      1.902883,
      0,
      1,
      1.934445,
      2.012623,
      45,
      1,
      0.040175,
      55,
      NULL,
      30,
      7.063523,
      2,
      0,
      NULL,
      '24311',
      '30104',
      NULL,
      0.533231,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      22.806695,
      NULL,
      50.545577,
      2,
      2.014755,
      NULL,
      3,
      0.346003,
      2.453487,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.065658,
      3,
      2.642853,
      NULL,
      NULL,
      NULL,
      3,
      2.960489,
      2,
      2,
      1.949673,
      NULL,
      0,
      NULL,
      NULL,
      3.806125,
      NULL,
      3,
      0.932393,
      0,
      3.162421,
      7,
      6,
      NULL,
      1,
      1.310741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.447336,
      0,
      NULL,
      NULL,
      NULL,
      1.142071,
      NULL,
      NULL,
      NULL,
      1.135430,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.425762,
      0,
      3,
      NULL,
      1.786547,
      3.783683,
      1.834356,
      2,
      0,
      0,
      2.481428,
      NULL,
      NULL,
      1,
      3,
      0.462073,
      1.350738,
      10.154286,
      4.064734,
      4,
      1,
      0.771493,
      NULL,
      NULL,
      NULL,
      1.597339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.506926,
      0,
      NULL,
      2,
      2.200097,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.844032,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.933647,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.933130,
      NULL,
      NULL,
      1.629118,
      2.864766,
      3,
      5,
      NULL,
      6,
      NULL,
      2.803908,
      0.374407,
      0.390311,
      NULL,
      0,
      8.960860,
      8.603033,
      5.397852,
      7.921566,
      7,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.806132,
      3.254095,
      1.437158,
      1,
      NULL,
      0,
      0.631274,
      0,
      4,
      1.483587,
      NULL,
      NULL,
      NULL,
      2.526750,
      NULL,
      0,
      1.421132,
      1.815511,
      2.849212,
      3,
      3,
      11,
      1,
      3.633356,
      NULL,
      NULL,
      4.638557,
      0,
      2,
      0,
      1.091520,
      1.365474,
      0,
      0,
      1.542887,
      NULL,
      NULL,
      NULL,
      0.763036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.270535,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.098851,
      NULL,
      NULL,
      1.926790,
      NULL,
      NULL,
      3.566985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063471,
      1.052577,
      0,
      0.692056,
      1.809480,
      1,
      1.670149,
      NULL,
      NULL,
      1.106111,
      NULL,
      NULL,
      NULL,
      2.346957,
      NULL,
      NULL,
      NULL,
      1.477107,
      NULL,
      NULL,
      NULL,
      0.565801,
      NULL,
      NULL,
      NULL,
      0.615843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589517,
      NULL,
      NULL,
      NULL,
      0.186195,
      NULL,
      NULL,
      NULL,
      1.539848,
      NULL,
      NULL,
      NULL,
      1.000660,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.079392,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.634517,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.600919,
      55.710036,
      6.847592,
      1.206314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972613,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817926,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0.338758,
      1,
      0.324410,
      0,
      1.261949,
      0,
      NULL,
      NULL,
      1.152690,
      NULL,
      1.454446,
      1,
      NULL,
      0.311743,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.998736,
      0.687657,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.557301,
      NULL,
      1.947147,
      NULL,
      1.288215,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683564,
      NULL,
      0,
      NULL,
      1.542129,
      NULL,
      0.082792,
      3.085721,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.190874,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262554,
      NULL,
      1,
      NULL,
      0.006446,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.093101,
      NULL,
      NULL,
      1.120970,
      NULL,
      459.339738,
      NULL,
      2.086402,
      NULL,
      1.262939,
      NULL,
      0,
      NULL,
      3,
      1.851224,
      29,
      NULL,
      0.312561,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.436423,
      2,
      0,
      4,
      1,
      4.816775,
      2.809558,
      2.092547,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.156308,
      NULL,
      1,
      1,
      NULL,
      1,
      1.484042,
      NULL,
      NULL,
      1.457181,
      NULL,
      0.093281,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.954398,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.987726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.166683,
      NULL,
      0,
      NULL,
      0,
      NULL,
      7,
      1,
      1,
      NULL,
      24.485374,
      63.966429,
      3,
      1.660059,
      3.949144,
      '34243',
      '00043',
      NULL,
      1.665071,
      '',
      NULL,
      '',
      0.744842,
      '',
      '',
      '');
commit;
end;
/


