set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9712044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11',
      '32',
      1,
      30.551862,
      '1321222',
      0.366105,
      1.575149,
      4,
      0,
      '3441',
      1.790531,
      0.670085,
      NULL,
      NULL,
      ' 9-17-1993',
      16.097999,
      NULL,
      NULL,
      NULL,
      1.189545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 1-22-1999',
      NULL,
      0,
      1.638257,
      3,
      NULL,
      3,
      NULL,
      2.521324,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      0.793438,
      NULL,
      NULL,
      0,
      2.353561,
      1.559145,
      0,
      1.200931,
      3,
      NULL,
      3,
      2,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.362716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.908875,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      5,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      2,
      4,
      0,
      NULL,
      NULL,
      5,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1.684027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.954906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.159690,
      1.759538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.098486,
      1.489666,
      0.966582,
      1,
      0,
      1,
      1,
      NULL,
      2.405269,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.555730,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      NULL,
      3.370370,
      1,
      0,
      0,
      NULL,
      1,
      1.619409,
      1.728176,
      0.859309,
      0,
      NULL,
      NULL,
      0,
      1,
      0.186617,
      1,
      0.609560,
      9,
      5,
      NULL,
      8.898845,
      2.544585,
      6.539222,
      3,
      2,
      3.644815,
      1.763113,
      3,
      3.239111,
      68,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '04134',
      '00320',
      NULL,
      1,
      '',
      NULL,
      '',
      1.390979,
      '',
      '',
      '',
      2.051067,
      NULL,
      NULL,
      21.858787,
      3,
      25.941589,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.558980,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.536875,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.822830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.438452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.982158,
      0.070137,
      2.707823,
      2.412579,
      1.784676,
      0.085684,
      1.193270,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1.803769,
      NULL,
      2.502573,
      2.684437,
      0,
      0,
      NULL,
      NULL,
      NULL,
      6.363942,
      1,
      1.052264,
      NULL,
      NULL,
      1.167201,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.658689,
      NULL,
      NULL,
      1.210861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955458,
      3,
      0,
      1,
      3.968707,
      2.280031,
      1,
      9.509318,
      2.240975,
      5,
      9,
      1,
      4,
      4,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      3,
      3,
      0,
      2,
      2,
      NULL,
      6.472554,
      0,
      NULL,
      NULL,
      3,
      2.748830,
      0,
      NULL,
      1,
      NULL,
      2,
      2,
      3,
      0,
      0.708414,
      4,
      4,
      8.936429,
      NULL,
      3.893088,
      2,
      3,
      1.412772,
      0.942377,
      0,
      NULL,
      0.064373,
      3.949029,
      NULL,
      NULL,
      1.600295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.070021,
      NULL,
      NULL,
      1.155614,
      NULL,
      0.844075,
      0,
      0.104707,
      3.039562,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372178,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385886,
      0.697289,
      NULL,
      NULL,
      1,
      3.929118,
      NULL,
      NULL,
      1.757693,
      0.498211,
      NULL,
      NULL,
      0.914359,
      1.399262,
      NULL,
      NULL,
      1.989159,
      0,
      NULL,
      NULL,
      2,
      1.084668,
      NULL,
      NULL,
      1.962881,
      1,
      NULL,
      NULL,
      1.133272,
      0.073970,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.683773,
      7,
      NULL,
      1,
      NULL,
      NULL,
      1.013310,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.103144,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.594759,
      NULL,
      NULL,
      1.729970,
      5.111042,
      1,
      0.909381,
      0.260181,
      0,
      0.239042,
      NULL,
      0.286009,
      1.583586,
      1.623362,
      1.969711,
      NULL,
      0.292075,
      0,
      0,
      1.025891,
      0,
      1.173837,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.037703,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      13.225055,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.010815,
      NULL,
      0,
      NULL,
      0.798561,
      NULL,
      0.840348,
      NULL,
      0,
      NULL,
      1.014048,
      NULL,
      1.901277,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      2.384982,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237220,
      0.144820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.704456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875465,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.131845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.599578,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.995494,
      0,
      NULL,
      29.050114,
      25.633112,
      2.327144,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      1.349058,
      1.902258,
      0,
      0,
      1.253387,
      1.249826,
      0.780211,
      NULL,
      1.442194,
      1.898695,
      0.434734,
      1,
      NULL,
      1,
      0,
      NULL,
      1.629260,
      0,
      0.459201,
      0,
      1.948424,
      1.056244,
      1,
      0,
      0.869692,
      1,
      0.115399,
      0.725794,
      1,
      NULL,
      1.621764,
      0.779181,
      1.927932,
      1,
      0.809138,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1.952896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.948366,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1.002023,
      NULL,
      NULL,
      86,
      NULL,
      NULL,
      NULL,
      NULL,
      '12304',
      '00404',
      '23403',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


