set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0142885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      0,
      NULL,
      NULL,
      7.628588,
      1.598909,
      2.913616,
      3,
      '442',
      '24012314',
      28,
      NULL,
      '0311434',
      NULL,
      0,
      NULL,
      2,
      NULL,
      5.956089,
      0,
      NULL,
      NULL,
      ' 0-26-2002',
      NULL,
      34.921325,
      NULL,
      0.769501,
      2,
      '10- 6-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 4-26-1982',
      0.802180,
      NULL,
      0.703053,
      0.155006,
      1.412187,
      2.559809,
      0,
      0.118959,
      1,
      14.972414,
      3,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.194154,
      2,
      0,
      1.433054,
      1,
      NULL,
      1,
      NULL,
      4,
      1.321424,
      NULL,
      0,
      5,
      2,
      0.241617,
      3,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      2.841451,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0.227403,
      1.252024,
      0,
      3.447884,
      1.071389,
      0.293685,
      3,
      1.873625,
      0,
      0.742111,
      1,
      3.977790,
      0,
      1.281461,
      0.380901,
      1,
      0,
      NULL,
      1,
      2.591330,
      0,
      0,
      0.752689,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      1,
      5,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4,
      0,
      5,
      1,
      1,
      2,
      4,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      5,
      2,
      3,
      4,
      1,
      4,
      0,
      1,
      1,
      NULL,
      '10- 2-1986',
      596.627185,
      NULL,
      423,
      2,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.983688,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4.830913,
      NULL,
      2.439697,
      0,
      3.952642,
      0,
      NULL,
      NULL,
      1,
      6.216289,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319316,
      1.258287,
      0,
      NULL,
      1,
      1.863476,
      1.502108,
      1.790047,
      NULL,
      NULL,
      1.152098,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      3,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      3,
      1.617798,
      NULL,
      NULL,
      1,
      0,
      0.024981,
      5,
      NULL,
      1,
      1.359154,
      1.306969,
      1,
      0,
      1,
      1.940429,
      NULL,
      3,
      3,
      1.481571,
      NULL,
      NULL,
      3,
      NULL,
      5,
      3.970064,
      5,
      1,
      1,
      0.524635,
      2,
      0,
      40,
      0,
      1,
      55,
      NULL,
      NULL,
      NULL,
      2,
      5.587270,
      NULL,
      '12300',
      '',
      '',
      1,
      '24442',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.810158,
      21.708469,
      92.995507,
      22.385891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.525633,
      0,
      1,
      NULL,
      NULL,
      1.923831,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.796439,
      1.289036,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.028305,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.118187,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.089474,
      2.058781,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.470905,
      NULL,
      0.138953,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.461652,
      3,
      3.584780,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.179461,
      0.919703,
      NULL,
      0.289437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813748,
      NULL,
      NULL,
      1.847514,
      NULL,
      NULL,
      1.069216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.411382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.031132,
      2,
      0,
      2,
      6,
      4.501440,
      3,
      0,
      2.809976,
      0,
      3,
      0,
      3,
      3.072638,
      0,
      2,
      2.499091,
      3,
      0,
      NULL,
      3.528098,
      2,
      NULL,
      9.137615,
      1.811449,
      0,
      NULL,
      NULL,
      2,
      3.397705,
      1.808115,
      NULL,
      0,
      2,
      0.400840,
      3,
      NULL,
      9,
      7,
      0,
      NULL,
      1.483302,
      1,
      0,
      2,
      1,
      0,
      1.028547,
      1,
      0.712438,
      1.608036,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862255,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.081461,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.723936,
      NULL,
      NULL,
      1.842194,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153027,
      0.184244,
      1,
      0.534925,
      0.599334,
      1.932230,
      0.584469,
      NULL,
      NULL,
      0.364674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.716719,
      NULL,
      NULL,
      NULL,
      1.554704,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.489734,
      NULL,
      NULL,
      NULL,
      1.778977,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.338656,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.056636,
      NULL,
      NULL,
      1.084025,
      NULL,
      0.473420,
      53,
      0,
      0,
      0,
      0,
      1.280233,
      NULL,
      1,
      1,
      0.288822,
      0.440319,
      1,
      1,
      1.956202,
      0.480657,
      0.596118,
      0.635880,
      0.821000,
      0.220665,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.727113,
      NULL,
      NULL,
      NULL,
      0.550990,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.515518,
      NULL,
      1.002823,
      NULL,
      NULL,
      NULL,
      0.041350,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      7,
      NULL,
      4.852675,
      1.580977,
      2,
      3.832971,
      1.468350,
      3,
      1.011271,
      NULL,
      1,
      NULL,
      0.493853,
      0.138226,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3.659216,
      1.754665,
      NULL,
      0,
      3.148548,
      NULL,
      1.917509,
      2,
      NULL,
      1,
      2,
      NULL,
      1.561692,
      0.094912,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107596,
      NULL,
      0.559362,
      NULL,
      1.143442,
      NULL,
      0,
      2,
      5,
      NULL,
      2,
      2,
      52,
      58.686436,
      5,
      NULL,
      1,
      NULL,
      '',
      NULL,
      0.001343,
      '34033',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


