set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0023344',
      2.923409,
      1.548781,
      1,
      3,
      '3421',
      NULL,
      NULL,
      3.204246,
      5,
      ' 0-12-1998',
      29.711583,
      NULL,
      1,
      1.854720,
      0,
      ' 0-22-1980',
      39,
      4.766025,
      NULL,
      24,
      2,
      NULL,
      NULL,
      ' 8-28-1977',
      0.461264,
      3,
      1,
      1,
      1,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      7,
      3.657835,
      5.117307,
      4.432493,
      3,
      24.980209,
      NULL,
      NULL,
      5.703646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0.163906,
      NULL,
      NULL,
      2.098942,
      1,
      0,
      0,
      0,
      1,
      1.234058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3.940375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      3,
      0,
      0,
      1,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1.226606,
      NULL,
      0,
      0,
      1,
      4,
      4,
      1,
      2,
      3,
      NULL,
      4,
      4,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      1,
      2,
      1,
      2,
      2,
      0,
      0,
      0,
      0.541470,
      NULL,
      554.694687,
      ' 7- 4-1988',
      114.482527,
      0.735649,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      9,
      0,
      1,
      1.402676,
      NULL,
      NULL,
      NULL,
      3,
      2.139458,
      3.935627,
      2.692627,
      4.929557,
      7.108704,
      1,
      NULL,
      NULL,
      NULL,
      3.407863,
      1,
      0.602173,
      1,
      1,
      0,
      2,
      ' 7-19-2000',
      0.247947,
      NULL,
      NULL,
      0,
      1,
      0,
      3.684260,
      3.116408,
      0.439022,
      1,
      2,
      0.544335,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      2,
      2.627558,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0.007190,
      2.923064,
      0,
      8.221341,
      5.474042,
      2.223302,
      NULL,
      9,
      4.859954,
      5.371152,
      1,
      0.261599,
      0,
      0.534469,
      1.322761,
      NULL,
      3,
      1,
      6,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.960544,
      '00130',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1.804851,
      '',
      '',
      NULL,
      2.778251,
      NULL,
      82,
      23,
      NULL,
      13,
      0.631233,
      NULL,
      2,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      0.789629,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.821854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.316957,
      NULL,
      NULL,
      1,
      1.150933,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.869597,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045484,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.266352,
      3.235944,
      0.703434,
      7.161735,
      4,
      0,
      12,
      NULL,
      NULL,
      2,
      3,
      2,
      7.758994,
      0.821958,
      7.592674,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.042160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.137592,
      0.936475,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.487524,
      NULL,
      NULL,
      5.053032,
      NULL,
      NULL,
      NULL,
      NULL,
      3.525273,
      0.486073,
      3,
      0,
      NULL,
      3,
      3.560637,
      2,
      8,
      NULL,
      NULL,
      3.773669,
      1,
      3,
      NULL,
      6,
      NULL,
      0,
      3,
      3.808847,
      0,
      0.231913,
      0,
      NULL,
      7,
      2.928965,
      3,
      2,
      NULL,
      3,
      2,
      1,
      NULL,
      1.934659,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2.926920,
      NULL,
      NULL,
      5.095816,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.149162,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.449302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426697,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      3,
      0.423807,
      1.256122,
      NULL,
      2,
      0.549041,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      56.197475,
      1694,
      NULL,
      NULL,
      2.753355,
      0.781183,
      NULL,
      NULL,
      0,
      2.782946,
      NULL,
      NULL,
      1.599792,
      2.056854,
      NULL,
      NULL,
      10,
      10.759284,
      NULL,
      NULL,
      2,
      1.226008,
      NULL,
      NULL,
      2,
      0.986699,
      NULL,
      NULL,
      3.807328,
      2.666572,
      NULL,
      NULL,
      NULL,
      1.542444,
      NULL,
      NULL,
      1.357866,
      3,
      NULL,
      NULL,
      0.350083,
      6.504620,
      NULL,
      NULL,
      1.274843,
      3,
      NULL,
      NULL,
      0.664527,
      1.251816,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.389727,
      0,
      NULL,
      NULL,
      2,
      0.128632,
      NULL,
      NULL,
      0.143906,
      NULL,
      NULL,
      NULL,
      3,
      1.250592,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.690869,
      NULL,
      NULL,
      3,
      NULL,
      4,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      2.430295,
      1.867178,
      22.712822,
      11,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      19916.319853,
      692,
      1,
      NULL,
      NULL,
      1.953604,
      NULL,
      0,
      0.544332,
      0,
      1,
      1.255664,
      1.864976,
      1,
      0.495240,
      NULL,
      0.571951,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.897818,
      5,
      2,
      0,
      14.192609,
      1,
      1.609346,
      NULL,
      1.706753,
      0,
      NULL,
      1.521528,
      2.844348,
      NULL,
      2,
      2,
      NULL,
      1.183725,
      NULL,
      NULL,
      2,
      0.789085,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3,
      NULL,
      3,
      2.660608,
      NULL,
      1.061208,
      1.591412,
      NULL,
      1.963868,
      1,
      NULL,
      0.932364,
      2,
      NULL,
      3.583316,
      3.960807,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258664,
      0.939112,
      3.529902,
      NULL,
      3.062374,
      1,
      1,
      1.472927,
      1,
      0.538504,
      3,
      1.966294,
      0,
      NULL,
      0,
      2,
      2,
      1.757316,
      1,
      1.249933,
      NULL,
      3.298696,
      1,
      NULL,
      NULL,
      0.421186,
      1.729320,
      40.218222,
      NULL,
      NULL,
      0.275848,
      1,
      1,
      3,
      0,
      0.607346,
      1,
      1,
      6,
      1.009721,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.821388,
      5,
      '24414',
      '24403',
      '',
      NULL,
      '',
      '',
      '',
      1.604734,
      '',
      NULL,
      '');
commit;
end;
/


