set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7821767';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4221112',
      3.569788,
      NULL,
      3,
      2,
      '4432',
      3,
      1,
      5,
      9.735128,
      ' 8-17-1984',
      15.202974,
      NULL,
      0,
      NULL,
      0,
      ' 0-21-1981',
      34.503159,
      4.543786,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.744513,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.416691,
      NULL,
      10,
      15,
      5,
      NULL,
      4,
      2,
      7.887586,
      1.425853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.487830,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0.173782,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      4,
      NULL,
      0,
      0,
      1,
      1,
      2,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      2,
      5,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      0.252507,
      0.423003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.222244,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.646469,
      1,
      1.555920,
      0.133440,
      NULL,
      NULL,
      NULL,
      1.205817,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.742843,
      NULL,
      0.359246,
      1,
      NULL,
      1.526739,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447139,
      3.976513,
      1,
      0,
      2,
      1,
      1,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      3.284462,
      2.189847,
      0,
      1,
      1.442978,
      1,
      1.805550,
      0.389896,
      1.807801,
      1.862497,
      0.369161,
      1,
      1.633186,
      NULL,
      1,
      0,
      NULL,
      0.274502,
      NULL,
      9,
      NULL,
      6,
      NULL,
      6.459784,
      NULL,
      3,
      NULL,
      3.496124,
      3,
      0.837574,
      NULL,
      NULL,
      0,
      81,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.505577,
      NULL,
      '',
      '',
      0.711093,
      '',
      '',
      '',
      1.864061,
      '',
      '',
      '',
      0.292168,
      1.218376,
      43.978200,
      12,
      3.151379,
      NULL,
      3.194781,
      1,
      3,
      0,
      NULL,
      NULL,
      0.836392,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.890519,
      NULL,
      NULL,
      0.927962,
      1.313542,
      0,
      0,
      NULL,
      NULL,
      3.166023,
      0.217619,
      1.604666,
      0.083217,
      NULL,
      NULL,
      0.944208,
      0.861211,
      NULL,
      0,
      NULL,
      NULL,
      3.370197,
      NULL,
      NULL,
      1.578848,
      NULL,
      NULL,
      9.909230,
      1.409922,
      0,
      0,
      1.371100,
      NULL,
      NULL,
      NULL,
      3,
      1.610652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.868544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735505,
      NULL,
      NULL,
      1,
      0.910573,
      1.949223,
      2,
      NULL,
      NULL,
      2,
      1,
      0.662304,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.320504,
      1.343807,
      0,
      0.648755,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.040951,
      NULL,
      NULL,
      0.739502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566575,
      NULL,
      NULL,
      1.762604,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.195823,
      3.965296,
      1.790436,
      NULL,
      7.562250,
      NULL,
      NULL,
      1.699281,
      NULL,
      0.755380,
      3.575418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.375424,
      0.967324,
      1,
      3,
      1,
      3,
      4,
      0.780586,
      0.328986,
      0,
      NULL,
      18,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      4,
      4,
      5,
      1.584615,
      1,
      3.447660,
      3,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1.754424,
      1.996388,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578483,
      NULL,
      NULL,
      0.923509,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4.936790,
      NULL,
      NULL,
      NULL,
      3.997909,
      NULL,
      1,
      NULL,
      NULL,
      0,
      7.170757,
      NULL,
      4,
      2.723492,
      7,
      NULL,
      NULL,
      1610,
      1.346735,
      NULL,
      NULL,
      3.535489,
      0.880469,
      NULL,
      0,
      0,
      3.575695,
      NULL,
      0,
      0.821684,
      0.342628,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.689870,
      NULL,
      3,
      2.275488,
      1,
      NULL,
      0,
      NULL,
      0.076344,
      NULL,
      1,
      0.816289,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      3.105186,
      3.937654,
      NULL,
      NULL,
      1,
      1.902453,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.792561,
      2,
      1.336983,
      NULL,
      2,
      0,
      0,
      NULL,
      0,
      0.204415,
      0,
      NULL,
      3,
      0,
      3.967871,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.890800,
      6.120053,
      0.455941,
      NULL,
      3.120352,
      3,
      NULL,
      3,
      NULL,
      NULL,
      4.907079,
      NULL,
      NULL,
      NULL,
      2.598492,
      4,
      NULL,
      0,
      NULL,
      NULL,
      3.560175,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.412117,
      17,
      0,
      18469,
      NULL,
      NULL,
      1,
      NULL,
      0.334174,
      NULL,
      0.238509,
      0,
      3,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      1.689017,
      0,
      2.293971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.959445,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      1.518067,
      12.768273,
      7,
      3.145080,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.155089,
      NULL,
      0.535904,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.990647,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.055848,
      0.101785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      3,
      0.802106,
      1,
      NULL,
      3,
      8.847609,
      0,
      2.065793,
      0.556243,
      1,
      0.476558,
      0.021581,
      1,
      1.158302,
      NULL,
      3.517594,
      1,
      1.013160,
      0.743589,
      1,
      NULL,
      1,
      1.559422,
      1.257885,
      0,
      0.131810,
      2,
      NULL,
      1,
      1,
      1,
      0.621455,
      0.277319,
      NULL,
      1.687736,
      0,
      1,
      0.432026,
      0,
      NULL,
      1.777929,
      0.240930,
      0.923765,
      NULL,
      0.624489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328563,
      1,
      0,
      NULL,
      0.969153,
      4,
      0,
      NULL,
      0.743771,
      NULL,
      NULL,
      60,
      41,
      4,
      1.863072,
      2.146753,
      '21014',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


