set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602311';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2.855001,
      1.365511,
      0,
      1,
      3,
      3.510129,
      '213',
      '14223212',
      6.202058,
      85.970400,
      '0412324',
      3.358940,
      0,
      3,
      3,
      NULL,
      5,
      0.201632,
      NULL,
      NULL,
      ' 6- 7-2000',
      NULL,
      249.704276,
      NULL,
      0.404864,
      1.627314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 4- 0-1997',
      3.778828,
      1.349203,
      3.072861,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      6,
      2.445504,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.442650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      4,
      0,
      3,
      NULL,
      3,
      1.837139,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.266847,
      NULL,
      NULL,
      1,
      4,
      8,
      2.724442,
      1.625543,
      1,
      0,
      1,
      0.146574,
      3,
      2,
      3.803630,
      3.626396,
      2,
      1.379077,
      0.113667,
      1,
      0,
      1.734337,
      0,
      0,
      0,
      11,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      NULL,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      4,
      1,
      0,
      NULL,
      0,
      0.761901,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2,
      5,
      0,
      0,
      1,
      2,
      5,
      1,
      1,
      1.094751,
      0,
      ' 6-22-1976',
      1833,
      ' 3-18-1990',
      46,
      3.382104,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.430913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.900921,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.353343,
      NULL,
      0.352893,
      1,
      0,
      NULL,
      2,
      NULL,
      1,
      306,
      22,
      3,
      1.652638,
      3,
      0,
      NULL,
      0,
      1,
      3,
      1,
      3,
      0,
      NULL,
      NULL,
      2,
      3,
      0.685412,
      0,
      1,
      1,
      0,
      1.201347,
      0.687869,
      1.944883,
      1,
      0.535393,
      1.321867,
      0,
      1.388201,
      NULL,
      0.111682,
      NULL,
      0,
      10,
      9.698929,
      5,
      3,
      5,
      7.303572,
      NULL,
      1.061108,
      3.470689,
      3.494576,
      NULL,
      3,
      46.309561,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.914924,
      '41410',
      NULL,
      '',
      0,
      NULL,
      NULL,
      '',
      3,
      '0001',
      '',
      NULL,
      3,
      12.962283,
      123.541408,
      NULL,
      1.981535,
      16.295296,
      11,
      2,
      2,
      2,
      0,
      0.452208,
      1.067586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.775343,
      1,
      2.792264,
      1.790038,
      NULL,
      NULL,
      2,
      3,
      0,
      1.496425,
      NULL,
      0,
      2.414484,
      NULL,
      2.746856,
      1,
      3,
      3,
      0,
      1,
      NULL,
      1.204295,
      3.200794,
      NULL,
      1,
      1.908728,
      3.516019,
      NULL,
      NULL,
      4,
      1,
      1.763096,
      NULL,
      NULL,
      NULL,
      0.819986,
      0,
      NULL,
      2,
      NULL,
      1.124981,
      3.859864,
      0.525965,
      3,
      NULL,
      2.681829,
      NULL,
      3.940686,
      1.701194,
      1,
      NULL,
      2,
      2.582290,
      1.552740,
      3,
      NULL,
      0,
      2.409449,
      3.508859,
      1.427782,
      1.033809,
      2.492394,
      NULL,
      0,
      0.794457,
      NULL,
      NULL,
      1.828411,
      NULL,
      NULL,
      1.834338,
      0,
      1,
      0,
      7.792917,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.066698,
      2.853760,
      2,
      1,
      NULL,
      NULL,
      2.000723,
      0.898357,
      0.924548,
      1.170233,
      3.292441,
      1,
      3,
      0,
      0,
      2.275562,
      0.294196,
      2.888857,
      NULL,
      1.042346,
      3.334942,
      3,
      1.330978,
      0,
      4.323114,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.379243,
      NULL,
      NULL,
      1.128351,
      NULL,
      NULL,
      1,
      3,
      2,
      3,
      1.034428,
      4,
      8,
      4,
      3,
      0,
      NULL,
      NULL,
      3.956540,
      1,
      NULL,
      NULL,
      2.931578,
      0.579594,
      1,
      NULL,
      1,
      9.244502,
      8,
      NULL,
      NULL,
      3.191593,
      3.371150,
      2,
      1,
      NULL,
      2.768120,
      2.846437,
      3.265668,
      NULL,
      0,
      NULL,
      10.710571,
      3.460973,
      5.153735,
      0,
      NULL,
      NULL,
      3.346246,
      0,
      3,
      NULL,
      NULL,
      1,
      1.236761,
      1,
      NULL,
      NULL,
      NULL,
      1.156094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.937858,
      NULL,
      NULL,
      3.455313,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.421479,
      2,
      3.096118,
      0,
      0,
      2.135539,
      1,
      NULL,
      8,
      4.932035,
      NULL,
      NULL,
      5,
      1.289311,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.908086,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.595407,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.739805,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.314947,
      NULL,
      NULL,
      1.362678,
      NULL,
      NULL,
      NULL,
      1.083887,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.946398,
      3.530581,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      3.551975,
      NULL,
      3.496610,
      4,
      5,
      0.995352,
      NULL,
      229.665805,
      3,
      NULL,
      33,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143466,
      NULL,
      NULL,
      0.215900,
      25.225247,
      NULL,
      NULL,
      NULL,
      0.649731,
      NULL,
      6,
      0,
      NULL,
      1.034494,
      2.475551,
      0,
      1,
      1.030468,
      3,
      NULL,
      2.470671,
      1,
      0.762679,
      1,
      2.224990,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.276110,
      NULL,
      3.648379,
      NULL,
      1.395350,
      24,
      3,
      0,
      0,
      NULL,
      NULL,
      0.130681,
      NULL,
      NULL,
      NULL,
      1.203944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.158534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833356,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.286427,
      2,
      NULL,
      1.177564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550140,
      NULL,
      3.547479,
      NULL,
      NULL,
      NULL,
      346,
      NULL,
      0.954485,
      NULL,
      1,
      NULL,
      2.444762,
      0,
      0,
      NULL,
      19.542411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.606785,
      2.281663,
      1,
      NULL,
      1,
      3,
      2,
      3,
      2.981448,
      NULL,
      0,
      NULL,
      1.834067,
      1,
      NULL,
      1,
      0.550934,
      NULL,
      1,
      1.117096,
      NULL,
      1.462831,
      1,
      1.216921,
      NULL,
      NULL,
      1,
      NULL,
      1.060697,
      NULL,
      0.081823,
      1,
      3.864846,
      NULL,
      1,
      NULL,
      NULL,
      0.022435,
      1,
      NULL,
      NULL,
      0,
      0.157956,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664744,
      1.931509,
      NULL,
      0,
      0.684160,
      1.614736,
      0,
      2,
      6,
      3.180611,
      0,
      0,
      19,
      72,
      NULL,
      0,
      2.869730,
      '30322',
      '20330',
      '32233',
      0.238485,
      '',
      NULL,
      NULL,
      NULL,
      '1414',
      '',
      '');
commit;
end;
/


