set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7100321';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      2.085896,
      NULL,
      0,
      3,
      NULL,
      2,
      1.319022,
      NULL,
      NULL,
      ' 3-16-2000',
      38.640253,
      NULL,
      4,
      1.601946,
      0,
      '10-18-1976',
      5,
      NULL,
      244.368642,
      20.835053,
      NULL,
      ' 7-14-1974',
      ' 8-15-2002',
      ' 3-17-1994',
      2.336371,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      13.525598,
      6.788313,
      4.569168,
      67.964908,
      NULL,
      12.217516,
      NULL,
      2,
      4,
      3.961858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      4,
      3,
      0,
      1,
      NULL,
      0,
      1,
      9.935144,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.943700,
      NULL,
      NULL,
      1,
      NULL,
      1.228344,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      2,
      0,
      0,
      1,
      1,
      1,
      NULL,
      4.710951,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0.512772,
      3,
      4,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      0,
      3,
      2,
      1,
      4,
      1,
      NULL,
      5,
      1,
      0,
      1,
      0,
      0,
      0,
      0.477182,
      0,
      ' 9-20-1989',
      NULL,
      ' 4-26-1991',
      140.950816,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.294799,
      1,
      1,
      2.894202,
      0,
      NULL,
      NULL,
      NULL,
      0.350982,
      1.177035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655062,
      0,
      1,
      0,
      NULL,
      1,
      3.689984,
      21,
      1,
      1.464636,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      1,
      2,
      NULL,
      2,
      3,
      NULL,
      3,
      1,
      1.048380,
      3,
      0.374725,
      1.316702,
      0,
      0.731102,
      5,
      1.880334,
      1,
      0,
      1,
      1,
      NULL,
      1.147683,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.058913,
      NULL,
      6.064064,
      5.591699,
      1.945647,
      6,
      2.966941,
      0.075944,
      2,
      60,
      1,
      NULL,
      NULL,
      51,
      56,
      15.261582,
      4,
      NULL,
      2,
      '21332',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1.159691,
      '',
      '',
      '',
      2.432118,
      42,
      170.374784,
      58.327061,
      3.634760,
      NULL,
      5.839601,
      5,
      1,
      1.949533,
      NULL,
      3.817809,
      0.816100,
      NULL,
      NULL,
      0.783253,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.274579,
      1.655382,
      1.228028,
      1.466332,
      NULL,
      NULL,
      1.760747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.431682,
      NULL,
      NULL,
      6,
      7,
      7,
      1,
      0.137490,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.759258,
      NULL,
      NULL,
      1.539496,
      NULL,
      NULL,
      1.796333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608905,
      NULL,
      NULL,
      2,
      0.280922,
      1.406827,
      1.650522,
      NULL,
      NULL,
      2.664957,
      4,
      0,
      1.084489,
      0,
      0.090056,
      NULL,
      NULL,
      NULL,
      5.087145,
      3,
      0.084234,
      1,
      NULL,
      NULL,
      0.494631,
      NULL,
      NULL,
      1.601435,
      NULL,
      NULL,
      1.980956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.237231,
      NULL,
      3.630840,
      NULL,
      0,
      6.497163,
      NULL,
      1.667250,
      NULL,
      7,
      3.253259,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      2,
      NULL,
      7.870858,
      NULL,
      5.731966,
      NULL,
      2,
      0.235923,
      NULL,
      3.832957,
      1.189893,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.188492,
      10.246845,
      4.680609,
      0.258749,
      1,
      0.226570,
      0,
      1,
      NULL,
      NULL,
      0.327388,
      1.426154,
      1,
      0.985937,
      1.492417,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140636,
      1.341294,
      0,
      NULL,
      1.240716,
      NULL,
      0,
      NULL,
      NULL,
      0.498854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.772081,
      NULL,
      NULL,
      NULL,
      1.223590,
      NULL,
      NULL,
      NULL,
      1.936982,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.797556,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.403980,
      3.883727,
      9,
      3,
      3.440489,
      192.502252,
      NULL,
      0,
      NULL,
      0.415238,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.082005,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      0,
      0,
      0,
      0.815051,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.646145,
      0,
      0,
      0,
      NULL,
      1.823439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.770236,
      1,
      0.919258,
      4,
      3,
      3,
      0.282723,
      2.151810,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0.560824,
      3,
      NULL,
      1.059862,
      1.203748,
      NULL,
      0,
      1,
      NULL,
      0.029368,
      0.795749,
      NULL,
      1.953188,
      1,
      NULL,
      1,
      3,
      NULL,
      0.234383,
      NULL,
      NULL,
      1.552267,
      2.327924,
      NULL,
      NULL,
      0,
      NULL,
      1.586838,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.927414,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1.331982,
      0.236829,
      43.647213,
      NULL,
      0,
      NULL,
      NULL,
      '23030',
      '',
      '',
      0,
      '',
      '',
      '',
      1.024043,
      '',
      '',
      NULL);
commit;
end;
/


