set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000217';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '1323000',
      2,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.026142,
      3,
      48.392444,
      ' 3-22-2003',
      72.766528,
      NULL,
      3,
      0,
      0.185797,
      ' 0- 8-2002',
      26,
      5.766688,
      123.325243,
      51.160518,
      3,
      NULL,
      NULL,
      '10-11-1975',
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      0.339792,
      200,
      0,
      16,
      1,
      NULL,
      23,
      3,
      18,
      NULL,
      1,
      1.481455,
      0,
      NULL,
      1,
      1,
      0,
      1.346177,
      1,
      0.387441,
      0.467179,
      NULL,
      172,
      8,
      4,
      3,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0.538815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      2,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      2,
      1,
      9.696110,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      4.273657,
      0,
      0,
      1,
      3,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      4,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      4,
      2,
      0,
      5,
      NULL,
      2.658155,
      ' 9-28-1993',
      905.513995,
      NULL,
      522.081718,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      0.822434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.107558,
      NULL,
      0,
      1.824700,
      0,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.839302,
      0,
      NULL,
      1.783784,
      1,
      0.541273,
      0,
      2.392343,
      NULL,
      1,
      1.084337,
      55.726696,
      9.822941,
      95,
      0,
      1.754920,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      0,
      NULL,
      0.925797,
      2,
      0.156032,
      1.488268,
      0.769732,
      2.961920,
      0,
      1,
      173.909686,
      4,
      109.396638,
      0.939400,
      1,
      1,
      0,
      0.696300,
      3,
      NULL,
      1,
      NULL,
      NULL,
      7.703501,
      1,
      1.017074,
      1,
      3.903830,
      0.288018,
      0.455852,
      0.772878,
      3,
      9,
      3,
      1.495457,
      44,
      NULL,
      NULL,
      NULL,
      5,
      1,
      3.866848,
      '32434',
      NULL,
      '',
      1.196603,
      '',
      '',
      '',
      2.612921,
      '32041',
      NULL,
      '1001',
      3,
      26,
      234.944292,
      6.728231,
      3,
      2,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      0.529429,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.247387,
      0.683466,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      1,
      1.158723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.598618,
      0.022684,
      6,
      2,
      0.689992,
      NULL,
      NULL,
      NULL,
      3.442005,
      1.887881,
      NULL,
      3.983907,
      0,
      1.045157,
      14,
      0.333693,
      NULL,
      NULL,
      0.485538,
      NULL,
      NULL,
      3.919282,
      0.407632,
      0.721138,
      0,
      0.711208,
      2,
      0,
      NULL,
      0,
      0,
      0.181221,
      0,
      1.193504,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.173850,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.926995,
      NULL,
      3.916462,
      3.473943,
      NULL,
      NULL,
      3,
      0.901384,
      NULL,
      1.390984,
      0.486535,
      3,
      3,
      0,
      1.262475,
      NULL,
      NULL,
      NULL,
      3.514203,
      0.997067,
      NULL,
      NULL,
      1,
      1,
      2.865059,
      0,
      2.874496,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.973816,
      0,
      0,
      2.909057,
      1.062808,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.288737,
      NULL,
      6.720293,
      1,
      1,
      2,
      0.874373,
      0.454614,
      3,
      1.803506,
      2,
      0.308482,
      0.944164,
      2.280565,
      NULL,
      3,
      11.571148,
      4,
      1.679549,
      NULL,
      1,
      19.205046,
      NULL,
      NULL,
      NULL,
      2.369269,
      NULL,
      1,
      0,
      2,
      8,
      0.485179,
      3.007278,
      7.109524,
      NULL,
      NULL,
      2.635252,
      0,
      NULL,
      0.306226,
      NULL,
      0,
      NULL,
      NULL,
      3.025933,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.476833,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152173,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      1,
      2,
      0,
      7.317298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.456369,
      NULL,
      NULL,
      NULL,
      2.161773,
      NULL,
      1.382926,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.239585,
      NULL,
      0.971662,
      0.619085,
      2,
      NULL,
      NULL,
      NULL,
      2.383154,
      NULL,
      NULL,
      NULL,
      2.283677,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.819337,
      1,
      0.769793,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.342585,
      NULL,
      2.795260,
      NULL,
      NULL,
      NULL,
      1.473387,
      NULL,
      NULL,
      2.242060,
      3.191009,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0.622588,
      0.442264,
      6.075917,
      NULL,
      9.255593,
      8,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.448368,
      223,
      56,
      1,
      4,
      NULL,
      1.982069,
      NULL,
      NULL,
      0.579427,
      NULL,
      1.121702,
      NULL,
      6,
      2,
      1.045918,
      NULL,
      NULL,
      1,
      326.149376,
      0.315453,
      1,
      11,
      1.681644,
      2.255323,
      NULL,
      0,
      0,
      0,
      1,
      2.161967,
      0.254539,
      1.394034,
      1,
      0.459558,
      1.454978,
      0.385855,
      1,
      0.297480,
      1,
      1,
      NULL,
      0.434382,
      NULL,
      1.860517,
      NULL,
      0.209160,
      NULL,
      NULL,
      NULL,
      3.195395,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      30,
      0.257021,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.973994,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.026159,
      NULL,
      NULL,
      NULL,
      1.860726,
      NULL,
      0.809360,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.940711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.661785,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.553711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768787,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328770,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      1,
      NULL,
      2,
      NULL,
      69,
      NULL,
      0.930565,
      NULL,
      1,
      NULL,
      0,
      1.549140,
      2,
      20.999002,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      5.796845,
      3,
      1,
      0.467245,
      2,
      2,
      1,
      0,
      NULL,
      0,
      1.474509,
      1,
      NULL,
      NULL,
      NULL,
      2.907334,
      0.022066,
      0,
      1,
      2,
      3.180871,
      2.925191,
      0.449984,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.117587,
      1,
      1,
      1,
      NULL,
      2,
      1,
      2,
      3.323823,
      0,
      0.838056,
      2.937927,
      1,
      2.917315,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940436,
      1,
      1,
      1.211999,
      0.304826,
      1.688572,
      1,
      5,
      6,
      3.172819,
      0,
      NULL,
      18.363306,
      43,
      0,
      1.050490,
      0.154092,
      '11012',
      '34204',
      '13033',
      1,
      '03011',
      '',
      NULL,
      NULL,
      '1130',
      '3400',
      '');
commit;
end;
/


