set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8111275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      2.719113,
      5.872948,
      0,
      NULL,
      NULL,
      1.150056,
      NULL,
      '204',
      NULL,
      33,
      22,
      '3302142',
      NULL,
      0,
      4,
      1,
      '0123',
      NULL,
      0.374063,
      NULL,
      NULL,
      ' 4-22-1993',
      84.435516,
      41.115638,
      NULL,
      3,
      2.834451,
      ' 4-29-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-21-1974',
      ' 1-28-1978',
      ' 2-26-2001',
      1.323514,
      0,
      1,
      NULL,
      0.054144,
      1,
      2,
      1,
      NULL,
      0.177718,
      NULL,
      16,
      1.568839,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.840141,
      0.359772,
      NULL,
      3,
      NULL,
      0.104316,
      1.437457,
      NULL,
      0,
      5,
      2.876619,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      4,
      NULL,
      3,
      4,
      3,
      1,
      NULL,
      1,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0.428267,
      1.451275,
      0.324326,
      NULL,
      3,
      1,
      1.201788,
      2.696028,
      NULL,
      1.823772,
      1,
      3.967176,
      0.753023,
      0.911699,
      2.685812,
      2,
      1,
      0,
      1,
      0,
      4.242190,
      0,
      2,
      3.798982,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0,
      4,
      NULL,
      2,
      2,
      5,
      NULL,
      NULL,
      0,
      2,
      1,
      2,
      0,
      1,
      0,
      4,
      1,
      NULL,
      5,
      1,
      1.669711,
      0,
      ' 0-10-1976',
      24.831917,
      '11-18-2001',
      37,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038409,
      4.091020,
      1.790900,
      4,
      1.908272,
      NULL,
      NULL,
      1,
      1.943254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1.647173,
      0,
      NULL,
      1.225315,
      2,
      26,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.172018,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      0,
      2,
      2,
      1,
      0,
      0.308521,
      2,
      2.783147,
      1.254827,
      NULL,
      0,
      NULL,
      0.498465,
      NULL,
      0.211845,
      0,
      NULL,
      1,
      NULL,
      0.472004,
      1,
      0,
      0.831441,
      NULL,
      7.621782,
      6.361228,
      6.847905,
      2,
      NULL,
      2,
      5,
      2.692840,
      6,
      2.971730,
      2,
      1.758602,
      45.044559,
      1,
      3,
      27,
      NULL,
      27,
      NULL,
      5,
      NULL,
      1.147328,
      '11001',
      NULL,
      '',
      0.260345,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.538644,
      33,
      NULL,
      0.828846,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.040258,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.571002,
      NULL,
      NULL,
      0.496457,
      NULL,
      NULL,
      3,
      2.090850,
      3.440665,
      1,
      NULL,
      NULL,
      3.474311,
      NULL,
      NULL,
      2.225886,
      2,
      0.308562,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.900716,
      4.403243,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584057,
      0,
      1,
      1.948006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.046585,
      1,
      1.702062,
      0,
      2.005008,
      NULL,
      3,
      0,
      0.180102,
      0,
      0.928431,
      0.597250,
      0.708777,
      2.109940,
      NULL,
      0.805989,
      NULL,
      NULL,
      0.605669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.756986,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.978056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245322,
      NULL,
      NULL,
      3.559541,
      NULL,
      NULL,
      0.908701,
      NULL,
      NULL,
      1.863335,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.169866,
      NULL,
      NULL,
      1.918527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146288,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      3.323036,
      0,
      3,
      4,
      1.141635,
      2.352036,
      3,
      6,
      1.575593,
      NULL,
      NULL,
      NULL,
      2.372122,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      3.212901,
      1.355427,
      1,
      0,
      NULL,
      NULL,
      3.032896,
      2.941767,
      NULL,
      3.847332,
      3.867151,
      0.016013,
      NULL,
      NULL,
      1,
      1.498365,
      4,
      2.140286,
      2.110280,
      NULL,
      NULL,
      0.337424,
      NULL,
      NULL,
      1,
      0,
      0,
      1.684830,
      0.578707,
      2.839955,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416314,
      NULL,
      NULL,
      0.920419,
      NULL,
      NULL,
      1.936331,
      NULL,
      NULL,
      1.065769,
      NULL,
      NULL,
      1.648816,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529534,
      0.455722,
      1.781151,
      1.914950,
      1,
      3,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.801301,
      NULL,
      NULL,
      NULL,
      2.617274,
      NULL,
      NULL,
      NULL,
      0.250027,
      NULL,
      NULL,
      NULL,
      3.490867,
      NULL,
      NULL,
      NULL,
      0.866482,
      NULL,
      NULL,
      NULL,
      3.318278,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794156,
      NULL,
      NULL,
      NULL,
      0.176421,
      NULL,
      NULL,
      NULL,
      1.152934,
      NULL,
      NULL,
      NULL,
      0.873361,
      NULL,
      NULL,
      NULL,
      2.794036,
      NULL,
      NULL,
      NULL,
      2.618237,
      NULL,
      NULL,
      NULL,
      0.959600,
      NULL,
      NULL,
      NULL,
      7.774124,
      NULL,
      NULL,
      NULL,
      1.635653,
      NULL,
      NULL,
      NULL,
      0.366584,
      0,
      0.839581,
      1.985154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331517,
      NULL,
      NULL,
      1.905366,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      86.506511,
      5.177826,
      0.564164,
      0,
      1.525234,
      1,
      0.330298,
      0.148135,
      0.411791,
      0.256030,
      NULL,
      1.768577,
      0,
      0,
      1.886512,
      0.347011,
      NULL,
      1.028634,
      0,
      3.895772,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.759630,
      NULL,
      NULL,
      NULL,
      0.813637,
      NULL,
      4,
      NULL,
      1.682323,
      2.885826,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.044626,
      NULL,
      0,
      NULL,
      1.125312,
      NULL,
      1.293663,
      NULL,
      0.533238,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.568356,
      NULL,
      0,
      NULL,
      0.021935,
      NULL,
      1.084855,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      1.089849,
      1.727349,
      2.981025,
      3,
      10,
      1,
      1,
      1,
      0.818509,
      1.983272,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.041010,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.680525,
      NULL,
      1,
      1.140166,
      NULL,
      0.714860,
      1.229932,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.078368,
      0,
      NULL,
      0,
      1.969007,
      1.529500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.167109,
      NULL,
      NULL,
      NULL,
      2,
      1.286869,
      NULL,
      NULL,
      NULL,
      107.160789,
      1,
      NULL,
      4.793557,
      '02132',
      '30310',
      '',
      1,
      '',
      NULL,
      NULL,
      0.660628,
      '',
      '',
      NULL);
commit;
end;
/


