set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9129808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      3.891208,
      1,
      0,
      2,
      '0411',
      1.779674,
      1.759330,
      NULL,
      NULL,
      ' 4- 8-1995',
      9.938585,
      NULL,
      5,
      0,
      1.670409,
      ' 4- 1-1975',
      NULL,
      1,
      204.784431,
      7.882046,
      1,
      ' 1-20-1985',
      ' 3-10-1976',
      ' 6- 2-2003',
      0.554620,
      1.191000,
      1.510370,
      1.834428,
      1.072741,
      1.192585,
      0,
      1,
      NULL,
      NULL,
      NULL,
      11.021608,
      6.314693,
      12.431802,
      103,
      3,
      0.215244,
      3,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      44.153329,
      NULL,
      5,
      4,
      3.019214,
      5,
      1,
      0,
      2,
      1,
      1,
      4,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      1.133296,
      0,
      1.673895,
      0,
      0.534441,
      0,
      0.587113,
      NULL,
      1,
      1.152257,
      1.522370,
      0.424996,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      1.410053,
      1.710691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      1,
      3,
      1,
      3,
      0,
      NULL,
      0,
      0,
      1,
      7,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      3,
      3,
      1,
      2,
      5,
      0,
      4,
      NULL,
      5,
      4,
      0,
      2,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      1,
      1,
      4,
      2,
      0,
      3,
      0,
      1.504861,
      1,
      '10-13-1993',
      236.337933,
      ' 5-18-1974',
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.492182,
      NULL,
      2.564118,
      5.855241,
      1,
      NULL,
      1.662276,
      NULL,
      NULL,
      NULL,
      3.581017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.069470,
      1,
      0.156804,
      0,
      NULL,
      0.536103,
      19.857037,
      2.985730,
      0.214722,
      101.176184,
      598,
      1125.646157,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      3,
      3,
      2,
      10.820835,
      NULL,
      NULL,
      95,
      116,
      NULL,
      15.552453,
      NULL,
      114.711169,
      141.998196,
      NULL,
      100,
      141,
      NULL,
      0,
      3.622549,
      16.152018,
      1.751108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      23,
      2,
      32,
      1,
      1.999502,
      3.836727,
      '40401',
      '',
      '',
      0,
      '',
      '',
      '',
      0.612026,
      '',
      '',
      '',
      1,
      65.978218,
      NULL,
      NULL,
      NULL,
      7,
      3,
      3,
      2,
      3.218366,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.755281,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.013162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.136459,
      3,
      0.246419,
      NULL,
      NULL,
      NULL,
      1.540479,
      NULL,
      NULL,
      0.289807,
      NULL,
      NULL,
      0.703467,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11.514610,
      5,
      4,
      NULL,
      0.162445,
      NULL,
      NULL,
      NULL,
      1.950008,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480524,
      0.561241,
      1,
      NULL,
      0,
      0.695237,
      1,
      1.119079,
      1,
      NULL,
      NULL,
      0.904076,
      NULL,
      NULL,
      1.003505,
      NULL,
      0,
      NULL,
      NULL,
      1.001784,
      NULL,
      NULL,
      1,
      16.080436,
      NULL,
      0.981498,
      NULL,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829735,
      1.896600,
      0.676592,
      0.054135,
      2.224091,
      2,
      0,
      NULL,
      NULL,
      1,
      7.719977,
      5,
      NULL,
      2,
      1,
      1.711343,
      NULL,
      5,
      NULL,
      6.600318,
      9.172621,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.584854,
      NULL,
      NULL,
      0,
      9.020491,
      7,
      3,
      12.955611,
      0.141599,
      9.478157,
      0.569959,
      NULL,
      0,
      0,
      2,
      0.118358,
      NULL,
      NULL,
      1.404981,
      0.168567,
      NULL,
      3,
      NULL,
      0.301113,
      NULL,
      2,
      NULL,
      NULL,
      5.425387,
      11.203314,
      NULL,
      2,
      2,
      3,
      1,
      2,
      0,
      2.209861,
      1,
      1,
      1,
      2.836626,
      0.232645,
      6.935267,
      3,
      NULL,
      0.771749,
      7.936337,
      2,
      2,
      4,
      1.451799,
      0.305133,
      1,
      1.881352,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.740118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.098252,
      1,
      0,
      0,
      NULL,
      NULL,
      3.016263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.725034,
      NULL,
      1,
      2,
      2.144887,
      NULL,
      90.939451,
      1.236365,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.582252,
      1.127295,
      NULL,
      NULL,
      NULL,
      17.856141,
      NULL,
      5984.734867,
      33.531680,
      1.489519,
      NULL,
      1,
      0,
      0,
      NULL,
      0.055364,
      NULL,
      1,
      1.878214,
      1.407824,
      0,
      0,
      1.319229,
      1.272048,
      NULL,
      0.890796,
      0.268760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341274,
      9.749198,
      1.142226,
      NULL,
      4,
      6,
      NULL,
      7,
      NULL,
      NULL,
      1,
      2.882156,
      NULL,
      10,
      NULL,
      NULL,
      8.473984,
      19.507671,
      NULL,
      8.447904,
      NULL,
      NULL,
      8,
      19,
      NULL,
      7,
      16.244037,
      NULL,
      13,
      6.675482,
      NULL,
      14,
      1,
      NULL,
      2,
      0.447626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563654,
      NULL,
      1.794863,
      NULL,
      1,
      NULL,
      4,
      2,
      7,
      3.248596,
      0.239246,
      3,
      0,
      40,
      3,
      0.789792,
      3.187150,
      '02310',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


