set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8005729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '0103243',
      3.304521,
      1,
      3,
      1,
      NULL,
      2,
      0.015217,
      NULL,
      NULL,
      NULL,
      31.744696,
      NULL,
      NULL,
      0.593979,
      1,
      '10- 5-1985',
      16,
      1,
      79,
      13.378764,
      3,
      NULL,
      ' 5-28-1990',
      NULL,
      3.809178,
      NULL,
      1,
      0.391282,
      0.966574,
      3.071261,
      0,
      0.902985,
      NULL,
      219.467326,
      7,
      19.995514,
      15.532686,
      78,
      NULL,
      5,
      16,
      4,
      2,
      10,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1.520298,
      0,
      0,
      0,
      29.092571,
      8,
      NULL,
      5,
      NULL,
      5,
      NULL,
      1,
      1,
      1,
      1,
      2,
      2,
      1,
      0,
      0,
      NULL,
      9.704688,
      NULL,
      NULL,
      1,
      NULL,
      1.104381,
      NULL,
      NULL,
      0.565317,
      NULL,
      NULL,
      5,
      3,
      2.499043,
      1,
      1.925500,
      1.566422,
      1.498150,
      NULL,
      0,
      0,
      1,
      NULL,
      1.614355,
      1.328967,
      1,
      NULL,
      3,
      1,
      0,
      1,
      1,
      NULL,
      7,
      3,
      2,
      2.519775,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      5,
      1,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1.641651,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      4,
      NULL,
      0,
      4,
      1,
      NULL,
      5,
      1,
      2,
      5,
      0,
      3.497468,
      0,
      ' 2-27-1993',
      1157.556349,
      '11-10-2000',
      732,
      3.186405,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.643741,
      NULL,
      3.950079,
      1.682835,
      NULL,
      NULL,
      NULL,
      0.692829,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.484325,
      1,
      1,
      1.949808,
      0.291671,
      NULL,
      313.554707,
      0,
      1.282404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.588196,
      2,
      1,
      1,
      2,
      2,
      NULL,
      3,
      1,
      NULL,
      2,
      0,
      19.619089,
      15.528808,
      8,
      NULL,
      122.120946,
      NULL,
      NULL,
      161,
      NULL,
      1.330367,
      1,
      NULL,
      1,
      1,
      1,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637558,
      NULL,
      9,
      10,
      28.802980,
      2,
      NULL,
      2.293526,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      173,
      25.608390,
      3.483309,
      6,
      5.085252,
      4,
      0,
      2.148730,
      0,
      3.860534,
      1.463697,
      NULL,
      NULL,
      0.814133,
      NULL,
      NULL,
      0.019028,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.676379,
      2,
      0,
      0.130252,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.063252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.681296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.175238,
      0.602199,
      0.097377,
      1,
      2,
      NULL,
      0.191879,
      2,
      0.951358,
      1.804870,
      1,
      1.735321,
      1,
      NULL,
      0,
      2,
      NULL,
      0.092425,
      0.755476,
      1.430235,
      NULL,
      NULL,
      1.583417,
      NULL,
      NULL,
      2,
      6,
      4.931916,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.129534,
      1,
      0.398283,
      3.368639,
      0,
      NULL,
      NULL,
      10,
      5,
      4,
      0.569303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714629,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.929851,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.570577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140337,
      3.537107,
      3.106184,
      0,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      5,
      6,
      0.098737,
      NULL,
      4.449388,
      1,
      0,
      2.506807,
      0.217678,
      0,
      2.713604,
      1,
      NULL,
      NULL,
      NULL,
      10.085707,
      4.740950,
      3.646019,
      2.417264,
      2.346791,
      1.705933,
      NULL,
      NULL,
      0.732435,
      2,
      3,
      2.576145,
      2,
      NULL,
      NULL,
      4,
      1.581348,
      5,
      0,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      0,
      0.743102,
      1.598848,
      3.965285,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.810635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.074133,
      2.394724,
      1.650198,
      NULL,
      NULL,
      1.832141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.884686,
      NULL,
      NULL,
      NULL,
      3.088850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528870,
      NULL,
      NULL,
      NULL,
      0.193389,
      NULL,
      NULL,
      NULL,
      1.698231,
      NULL,
      NULL,
      NULL,
      0.071092,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.514919,
      NULL,
      NULL,
      NULL,
      0.051770,
      NULL,
      NULL,
      NULL,
      0,
      110.360678,
      178,
      0,
      NULL,
      NULL,
      0.359649,
      NULL,
      NULL,
      1.425198,
      0,
      1.885478,
      1,
      9,
      NULL,
      1.945584,
      NULL,
      NULL,
      1,
      NULL,
      0.388008,
      16113.403796,
      802.608373,
      0.126395,
      0,
      0.089990,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1.021666,
      0,
      1,
      1.506022,
      0,
      0,
      0,
      1.225918,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.173665,
      1,
      1.641234,
      2,
      2.600322,
      3.616185,
      1.244897,
      1.980443,
      NULL,
      NULL,
      NULL,
      1.073699,
      2,
      NULL,
      1.793599,
      2,
      NULL,
      0,
      3,
      NULL,
      1,
      1.187449,
      NULL,
      1,
      2.626046,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.268098,
      NULL,
      NULL,
      1.529802,
      NULL,
      0.953389,
      NULL,
      NULL,
      1.834098,
      NULL,
      NULL,
      3,
      1.924722,
      0.757686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821466,
      NULL,
      1.243001,
      NULL,
      NULL,
      NULL,
      2,
      2,
      5,
      2,
      0.498499,
      0,
      26.600519,
      NULL,
      2,
      1,
      NULL,
      '40214',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


