set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9988431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      0.156205,
      4.028059,
      0,
      NULL,
      1.952933,
      0.147402,
      NULL,
      '24423303',
      NULL,
      33,
      '3224213',
      NULL,
      1.796116,
      NULL,
      3,
      '3324',
      NULL,
      1.787375,
      NULL,
      NULL,
      '11-12-1980',
      34.049192,
      6.016810,
      NULL,
      2,
      0,
      ' 9-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 9- 4-1987',
      ' 1- 7-2003',
      1,
      NULL,
      0.716727,
      2,
      0,
      1.605726,
      3,
      NULL,
      0.701751,
      7,
      7,
      2,
      4.744766,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.886567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      3,
      3,
      NULL,
      0,
      NULL,
      5,
      NULL,
      1,
      1,
      2,
      4,
      3,
      1,
      3,
      3,
      1,
      NULL,
      NULL,
      1,
      0.116487,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      8,
      1.112663,
      1.807680,
      1.378530,
      1,
      0.328290,
      NULL,
      1,
      NULL,
      NULL,
      1.371946,
      3.449012,
      0,
      0,
      3.439591,
      1.065642,
      0,
      NULL,
      1,
      2,
      7.315618,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      5,
      2,
      2,
      1,
      0,
      NULL,
      0,
      1,
      1,
      3.644694,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      5,
      3,
      1,
      1,
      2,
      0,
      3,
      3,
      1,
      0,
      5,
      NULL,
      NULL,
      1,
      5,
      2,
      1,
      5,
      NULL,
      5.890361,
      1,
      '11- 4-1984',
      426,
      NULL,
      92.396707,
      3.016255,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.777519,
      NULL,
      0.540169,
      NULL,
      1.742528,
      NULL,
      NULL,
      NULL,
      1,
      1.777035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832815,
      0,
      0,
      NULL,
      1,
      1.073402,
      3,
      13.612948,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      0.953774,
      1,
      0,
      0,
      1,
      NULL,
      2.253825,
      0,
      1,
      NULL,
      1.997052,
      0,
      0,
      NULL,
      0.750197,
      1,
      0,
      5.537770,
      1,
      5,
      6.708320,
      3.087869,
      1,
      0,
      4,
      5.604732,
      3.389773,
      5.598231,
      NULL,
      NULL,
      1,
      50,
      3,
      2.994383,
      NULL,
      NULL,
      7,
      39.037829,
      5,
      1,
      0.486129,
      '11000',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.587913,
      9.880156,
      66.179372,
      NULL,
      0.056250,
      4,
      1,
      1,
      0,
      0.777145,
      2,
      0,
      1.485658,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.130061,
      NULL,
      2,
      3.270226,
      1.366921,
      0,
      0,
      NULL,
      NULL,
      3.132006,
      0.386285,
      3,
      1,
      NULL,
      NULL,
      2.730037,
      NULL,
      1.350416,
      0.823789,
      0.311557,
      0.140730,
      NULL,
      1.341711,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      1,
      0,
      1.638064,
      NULL,
      NULL,
      NULL,
      0.586875,
      NULL,
      NULL,
      NULL,
      3.105149,
      1,
      1.300711,
      2,
      0.983770,
      0,
      NULL,
      NULL,
      0.733215,
      0.299042,
      0,
      NULL,
      0.637772,
      3.867637,
      NULL,
      NULL,
      1.305490,
      0,
      2.257338,
      1,
      1,
      0,
      3.272007,
      1.824873,
      1.614394,
      0.760824,
      NULL,
      NULL,
      0.043416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      0,
      1.413159,
      1,
      1.785258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.291504,
      0.084132,
      3,
      NULL,
      2.242363,
      1.340629,
      NULL,
      NULL,
      1,
      NULL,
      2.644652,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425571,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409897,
      NULL,
      NULL,
      1.852784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235794,
      NULL,
      NULL,
      3.675115,
      NULL,
      NULL,
      5,
      2.889853,
      0.901923,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.170640,
      1.174152,
      3,
      0,
      1,
      2.687112,
      0.683159,
      3.591267,
      0.680060,
      3,
      2.799808,
      2.059064,
      NULL,
      2.540177,
      1,
      1.801261,
      5,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      0,
      0.484352,
      2,
      NULL,
      NULL,
      0.761732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.943156,
      NULL,
      NULL,
      1.058036,
      NULL,
      NULL,
      0.350839,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.660359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343426,
      NULL,
      1,
      0,
      1.227704,
      0.908628,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601452,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.765668,
      NULL,
      NULL,
      NULL,
      1.095180,
      NULL,
      NULL,
      NULL,
      0.989410,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.555768,
      NULL,
      NULL,
      NULL,
      3.222405,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522090,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0.941804,
      0.610524,
      NULL,
      0,
      1.378328,
      1,
      NULL,
      NULL,
      0,
      1.342164,
      1.503503,
      1,
      0.381992,
      1.963384,
      0.988095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.951575,
      NULL,
      0,
      NULL,
      6,
      0.202030,
      0,
      1.825536,
      0.709870,
      1.940179,
      NULL,
      0,
      1.968332,
      NULL,
      0.715656,
      1,
      NULL,
      0.956731,
      1,
      NULL,
      1.152757,
      0,
      NULL,
      1,
      0.494093,
      NULL,
      1.114730,
      0.972913,
      NULL,
      0.990233,
      0,
      NULL,
      1,
      1.177505,
      NULL,
      0,
      1.398275,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      1.485320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146205,
      NULL,
      0.021689,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      144,
      2,
      2,
      1.927755,
      '14304',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


