set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3303313',
      NULL,
      1.730570,
      2,
      1,
      '1130',
      3,
      0.462728,
      NULL,
      NULL,
      NULL,
      52.624046,
      NULL,
      5,
      NULL,
      0.866484,
      ' 5-20-1977',
      NULL,
      NULL,
      220,
      42.977449,
      3,
      NULL,
      ' 5- 7-1974',
      '11-12-1997',
      3,
      0.664739,
      2,
      NULL,
      NULL,
      3,
      NULL,
      1.284332,
      NULL,
      53,
      8,
      17,
      0,
      11,
      7,
      1,
      20.461737,
      1,
      NULL,
      0.862113,
      0.202628,
      0,
      0,
      1,
      0.256836,
      NULL,
      0,
      2,
      0,
      0,
      1,
      3,
      2,
      7,
      0,
      2,
      0,
      0,
      0,
      3,
      1,
      2,
      3,
      1,
      NULL,
      2,
      3,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.270291,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      3.490180,
      0,
      1.851945,
      NULL,
      NULL,
      0,
      2,
      0,
      0.380805,
      2,
      2.615320,
      0,
      0.479550,
      0,
      0,
      3,
      1,
      0,
      9,
      1,
      0,
      4.898341,
      1,
      NULL,
      NULL,
      0.388391,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      5,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      1,
      4,
      4,
      1,
      3,
      2,
      NULL,
      1,
      1,
      4,
      NULL,
      1,
      2,
      5,
      5,
      2,
      0,
      1,
      1.630495,
      1,
      ' 4-23-2003',
      151.297500,
      ' 4- 7-2002',
      160.444803,
      0.632864,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      1,
      2,
      2.939908,
      0,
      2.122077,
      0.035081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      2,
      2,
      1,
      0.755849,
      NULL,
      0.787262,
      0.564733,
      1.256888,
      2.430932,
      1.104287,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242389,
      0.809285,
      1.114816,
      NULL,
      0.058776,
      0,
      0,
      3.857663,
      5.185279,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.425266,
      0.455195,
      2,
      0,
      1,
      NULL,
      1,
      0,
      2,
      2,
      1,
      3,
      3,
      1.085070,
      0.536570,
      1,
      1.359209,
      2,
      3,
      NULL,
      1,
      0.408355,
      0,
      0.544527,
      0,
      1.010489,
      1.693725,
      NULL,
      0,
      4,
      1.203629,
      2,
      NULL,
      2,
      3.630852,
      NULL,
      1.397757,
      3.277227,
      0,
      1,
      NULL,
      0,
      NULL,
      52,
      NULL,
      1.358172,
      NULL,
      16,
      17,
      58,
      0,
      5.574666,
      2.730305,
      '2331',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.976680,
      '',
      '',
      '',
      1.986147,
      1,
      24,
      36.999450,
      3,
      NULL,
      2,
      3,
      0,
      1.706917,
      1.856181,
      0.346098,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.292623,
      NULL,
      NULL,
      1.682551,
      NULL,
      NULL,
      0.264583,
      NULL,
      NULL,
      2.243916,
      3.268914,
      1.648627,
      2,
      NULL,
      1,
      0,
      1.163000,
      1.461738,
      1,
      NULL,
      NULL,
      1,
      3.731054,
      3.255899,
      NULL,
      NULL,
      2,
      1,
      7,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.866895,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.357827,
      0,
      NULL,
      NULL,
      1.694152,
      1.935791,
      0.398858,
      0.119000,
      NULL,
      1,
      NULL,
      3.034480,
      0.467251,
      0.315846,
      1.010672,
      0,
      3,
      0.444676,
      1.006312,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.095644,
      NULL,
      7.763809,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.601867,
      1,
      NULL,
      NULL,
      1.309155,
      NULL,
      NULL,
      3,
      1,
      0.689811,
      1,
      NULL,
      NULL,
      5.799918,
      4.753227,
      4,
      0.128615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.311794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      3.653390,
      2,
      1,
      3,
      NULL,
      6,
      4.679254,
      1.422231,
      0.066067,
      1.498795,
      0,
      3,
      NULL,
      1.705349,
      3,
      0,
      NULL,
      2.682474,
      1.699665,
      1,
      2.426106,
      3,
      8.162414,
      1,
      0.257328,
      NULL,
      3.264638,
      1.033280,
      1.298812,
      3.298140,
      3.114997,
      2,
      0,
      1,
      2.063749,
      7.693032,
      5.178750,
      2.530449,
      6,
      NULL,
      5,
      1.438740,
      0,
      0,
      0.052554,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593272,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039291,
      NULL,
      NULL,
      2.825432,
      NULL,
      NULL,
      NULL,
      1,
      1.605078,
      0.567441,
      0,
      0.586057,
      NULL,
      NULL,
      4,
      2,
      5.329469,
      NULL,
      4,
      NULL,
      2.778429,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.305555,
      NULL,
      0,
      NULL,
      NULL,
      1.146977,
      1.717919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.302479,
      0.555341,
      NULL,
      NULL,
      2.442827,
      NULL,
      NULL,
      NULL,
      0.349356,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3.679617,
      NULL,
      NULL,
      NULL,
      1,
      3.137050,
      0,
      NULL,
      3,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.330234,
      3.533826,
      2.331830,
      NULL,
      0,
      0.377398,
      NULL,
      NULL,
      12.866578,
      3.635937,
      3.524519,
      NULL,
      1,
      0.812296,
      NULL,
      NULL,
      NULL,
      1,
      14.753367,
      6,
      3,
      6.427285,
      NULL,
      1.152844,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.362195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      16.371578,
      NULL,
      0.179690,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1.467059,
      0,
      0.145717,
      0.277863,
      0,
      0.191964,
      1.194885,
      NULL,
      1.549948,
      1.683860,
      0.838181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      3,
      3,
      NULL,
      3,
      0,
      0,
      2,
      3.938025,
      0,
      0,
      1.151468,
      NULL,
      1,
      1.905123,
      1,
      1.026155,
      1.761534,
      NULL,
      0.952884,
      NULL,
      0.470733,
      NULL,
      0.201181,
      3,
      3.003749,
      0,
      1,
      1.423094,
      NULL,
      1.093759,
      NULL,
      3.165283,
      1,
      1,
      NULL,
      0.641890,
      2.798489,
      0.219604,
      0,
      1.814660,
      0.269903,
      1.405984,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.105752,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.313401,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.413391,
      1,
      0.547370,
      NULL,
      NULL,
      1,
      1.939263,
      0.290446,
      NULL,
      1,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      0,
      NULL,
      2,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


