set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '0142204',
      0,
      NULL,
      3,
      2,
      '1403',
      1.464722,
      1,
      NULL,
      NULL,
      ' 8-24-1986',
      2.749161,
      NULL,
      5,
      NULL,
      NULL,
      ' 0-18-1991',
      NULL,
      0,
      7.574871,
      185.287199,
      2,
      '10-23-1992',
      NULL,
      ' 7-20-1980',
      NULL,
      1,
      NULL,
      0,
      0.776586,
      1.551136,
      5,
      0,
      NULL,
      57.749345,
      1,
      13,
      NULL,
      13,
      18.907094,
      5,
      NULL,
      1,
      1,
      9.484930,
      1.320150,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0.292693,
      0.707898,
      0,
      0,
      1,
      4,
      7,
      1.393453,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      5,
      NULL,
      2,
      NULL,
      1,
      1,
      8.116438,
      0,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2,
      2.989594,
      0.017501,
      0,
      NULL,
      2.256013,
      1,
      3.742189,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      1,
      2.350844,
      1,
      0,
      0,
      1,
      6,
      0,
      2,
      2.420015,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      5,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      2,
      1,
      1,
      1,
      NULL,
      0.676404,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      5,
      NULL,
      2,
      1,
      0,
      NULL,
      5,
      0,
      1,
      0,
      1,
      5,
      NULL,
      4,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      ' 4-16-1989',
      194.863960,
      ' 3-25-1980',
      182.197092,
      1.126184,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.708791,
      0,
      0.981428,
      2,
      1.825463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.480156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.516826,
      1.319724,
      1,
      180.244771,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      2,
      1,
      1,
      3,
      1,
      NULL,
      1,
      0,
      1,
      3,
      2.092200,
      0,
      1.692628,
      1.040535,
      0,
      1,
      NULL,
      0.267706,
      0.371192,
      NULL,
      NULL,
      1,
      1.100844,
      0,
      0,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      26,
      44,
      0,
      1.946157,
      1.048310,
      '33341',
      '',
      '',
      0.737619,
      NULL,
      '',
      '',
      0.162495,
      '',
      '',
      '',
      3.786249,
      65.039803,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.532139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.676229,
      0.787279,
      0.898788,
      NULL,
      3,
      0,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.949083,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.568562,
      2.729356,
      NULL,
      NULL,
      NULL,
      0.844708,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.950922,
      3,
      2,
      0.129988,
      1.707990,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.445932,
      5,
      0,
      0.845913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300280,
      NULL,
      NULL,
      NULL,
      0,
      1.327405,
      2.036579,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      NULL,
      0.410460,
      2.618324,
      1,
      0,
      1,
      3.897015,
      7,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.990338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541513,
      NULL,
      NULL,
      0.549665,
      NULL,
      NULL,
      2.642501,
      2.401391,
      0,
      1.602021,
      0.099233,
      NULL,
      1.058504,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.882474,
      2.022501,
      NULL,
      1.758533,
      NULL,
      1,
      NULL,
      NULL,
      4.953730,
      4,
      4,
      2,
      3.886428,
      1,
      0.217841,
      3.194360,
      2.957503,
      1,
      0.714118,
      3,
      3,
      3,
      3,
      4,
      8,
      2.352898,
      2.222341,
      NULL,
      0,
      3.826839,
      3,
      2,
      1.255805,
      1.746442,
      1.922258,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.757948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.653982,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.652101,
      0,
      0.540352,
      0.994974,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.945407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347448,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.117535,
      NULL,
      NULL,
      NULL,
      1.042743,
      NULL,
      NULL,
      NULL,
      0.859341,
      NULL,
      NULL,
      NULL,
      5.776225,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831077,
      NULL,
      NULL,
      0.006118,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.278914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9289,
      1.911330,
      1,
      1.433484,
      NULL,
      1.894729,
      0,
      0,
      1,
      0.710954,
      0,
      NULL,
      0.902011,
      0,
      1.024499,
      0.666957,
      NULL,
      NULL,
      0.522062,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      1,
      0.724964,
      NULL,
      0.552699,
      2,
      NULL,
      0.421070,
      1,
      0.039198,
      1,
      0,
      NULL,
      1.560374,
      0.879766,
      NULL,
      0.057106,
      1,
      NULL,
      0.869337,
      0.540143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937407,
      NULL,
      1.972498,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.786963,
      1.144440,
      NULL,
      0.220091,
      1.211972,
      NULL,
      NULL,
      0.997999,
      NULL,
      2,
      0.420105,
      0.063735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      30.042285,
      86,
      NULL,
      0.978517,
      NULL,
      NULL,
      '',
      '',
      0.276478,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


