set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '3311242',
      2,
      1,
      1,
      2,
      '2243',
      2.045040,
      0.784999,
      NULL,
      NULL,
      ' 9-14-2001',
      NULL,
      NULL,
      1,
      NULL,
      0,
      ' 6- 5-1983',
      40.277610,
      3,
      9,
      94.209700,
      NULL,
      ' 3-11-1996',
      ' 9-11-1985',
      NULL,
      0.362923,
      0.563019,
      1.630095,
      3.234923,
      NULL,
      0.541088,
      3,
      NULL,
      0.939089,
      15,
      NULL,
      4.140872,
      1,
      1,
      4.615329,
      NULL,
      18.290867,
      5,
      3,
      9.759050,
      0,
      3,
      0,
      1,
      0.332948,
      1.678749,
      1.030449,
      0,
      1,
      1,
      1,
      3,
      3,
      4,
      NULL,
      5,
      1,
      0,
      1,
      0,
      5,
      1,
      0,
      1,
      1,
      0,
      0,
      0.776264,
      1,
      2,
      NULL,
      0,
      1.551751,
      NULL,
      NULL,
      0.563347,
      NULL,
      NULL,
      NULL,
      0,
      1.337686,
      1.834809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      3,
      2,
      4,
      0,
      NULL,
      2,
      5,
      0,
      1,
      7,
      1,
      0,
      0,
      0,
      1.043309,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      2,
      NULL,
      2,
      3,
      NULL,
      0,
      0,
      NULL,
      2,
      5,
      5,
      0,
      5,
      4,
      0,
      2,
      4,
      NULL,
      3,
      2,
      6.633064,
      NULL,
      NULL,
      273,
      ' 4-16-1982',
      NULL,
      2.264230,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.831635,
      1,
      5,
      NULL,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.420672,
      1.005243,
      1.044176,
      0,
      0.997306,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      0,
      2,
      1,
      3,
      1,
      3,
      3,
      NULL,
      NULL,
      1.220673,
      3.594854,
      NULL,
      1,
      0,
      0.247852,
      NULL,
      1,
      NULL,
      0.096719,
      1,
      0,
      1,
      1,
      0,
      1,
      2.437641,
      0,
      3.293417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.632376,
      NULL,
      8,
      39,
      3.545510,
      4,
      1,
      0,
      '34130',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      54,
      1.396415,
      3.172432,
      12,
      3,
      0,
      NULL,
      2,
      1,
      NULL,
      1.083699,
      NULL,
      NULL,
      0.505553,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.786383,
      0,
      2.882662,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.346428,
      NULL,
      NULL,
      1.500882,
      NULL,
      NULL,
      4,
      6,
      4,
      0,
      0.915126,
      NULL,
      NULL,
      NULL,
      0.008230,
      NULL,
      NULL,
      NULL,
      0.299215,
      NULL,
      0.841489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.735458,
      1.414154,
      NULL,
      0.386975,
      1,
      1.039617,
      3,
      2.404057,
      0,
      2,
      0.228639,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.658721,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.601643,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.053275,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      1.164453,
      2,
      0.479060,
      0,
      0.263738,
      NULL,
      NULL,
      4,
      7.726925,
      1.188186,
      2,
      NULL,
      NULL,
      2.241647,
      2,
      0,
      NULL,
      5,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099785,
      NULL,
      NULL,
      2,
      2,
      1,
      2.414499,
      2,
      2,
      0.327032,
      8,
      3.810897,
      2.416059,
      NULL,
      NULL,
      0.335543,
      4,
      1.159958,
      0,
      1,
      1.690985,
      1.312081,
      1.648960,
      NULL,
      0,
      2,
      0.797717,
      0.552391,
      4.783148,
      5.618795,
      1.482078,
      NULL,
      0.878165,
      0,
      1.335837,
      2,
      3,
      NULL,
      3,
      3.344642,
      3,
      3.296697,
      2,
      1,
      7.037197,
      0,
      4.506239,
      NULL,
      3,
      2,
      NULL,
      0.419443,
      NULL,
      1.337291,
      1.587544,
      0,
      NULL,
      NULL,
      NULL,
      7.276060,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.070566,
      NULL,
      NULL,
      1.528934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.616148,
      NULL,
      NULL,
      2.196585,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897004,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.758145,
      NULL,
      NULL,
      NULL,
      0.977058,
      NULL,
      1.931153,
      0.814289,
      0,
      1.959721,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.863665,
      NULL,
      NULL,
      NULL,
      1.753150,
      NULL,
      NULL,
      NULL,
      1.266793,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.278293,
      NULL,
      NULL,
      NULL,
      1.480770,
      NULL,
      NULL,
      NULL,
      1.889627,
      NULL,
      NULL,
      NULL,
      2.691909,
      NULL,
      NULL,
      NULL,
      1.873439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999279,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588162,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.540432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.207327,
      NULL,
      1.253965,
      1721.550430,
      54,
      NULL,
      1.530568,
      NULL,
      1,
      NULL,
      0.566767,
      0,
      1.701147,
      0.014617,
      NULL,
      1,
      1.713061,
      1.105786,
      1.305006,
      1,
      1.417308,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.157962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.084138,
      NULL,
      1,
      1.996454,
      NULL,
      2.535247,
      3,
      0.188174,
      NULL,
      1.471661,
      NULL,
      NULL,
      0.076647,
      0.969898,
      NULL,
      0,
      0.558855,
      NULL,
      1,
      NULL,
      NULL,
      1.687827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0.864898,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.116506,
      NULL,
      2,
      1.933465,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297697,
      NULL,
      1.259849,
      NULL,
      0.758125,
      NULL,
      4,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      126.789474,
      5,
      0.613063,
      3,
      '21210',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.441202,
      '',
      '',
      '');
commit;
end;
/


